/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StringUtil {
    public static String[] split(String value, String separator) {
        return StringUtil.split(value, separator, 0);
    }

    public static String[] split(String value, String separator, int limit) {
        int next;
        int offset = 0;
        ArrayList<String> list = null;
        while ((next = value.indexOf(separator, offset)) != -1) {
            boolean limited;
            if (list == null) {
                list = new ArrayList<String>();
            }
            boolean bl = limited = limit > 0;
            if (limited && list.size() >= limit - 1) break;
            list.add(value.substring(offset, next));
            offset = next + separator.length();
        }
        if (offset == 0) {
            return new String[]{value};
        }
        list.add(value.substring(offset));
        return list.toArray(new String[list.size()]);
    }

    public static final String joinSingleQuoted(String ... values) {
        return "'" + String.join((CharSequence)"', '", values) + "'";
    }

    public static final String joinSingleQuoted(Object[] values) {
        String[] strings = new String[values.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = Objects.toString(values[i]);
        }
        return StringUtil.joinSingleQuoted(strings);
    }

    public static final String joinSingleQuoted(List<String> strings) {
        return StringUtil.joinSingleQuoted(strings.toArray(new String[strings.size()]));
    }

    public static String toSlashSeparated(String string) {
        return string.replace('.', '/');
    }

    public static String toDotSeparated(String string) {
        return string.replace('/', '.');
    }
}

