/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debugentry.StringTable;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.debug.DebugContext;

public class ClassEntry
extends StructureTypeEntry {
    protected ClassEntry superClass;
    protected LinkedList<InterfaceClassEntry> interfaces = new LinkedList();
    private FileEntry fileEntry;
    protected List<MethodEntry> methods;
    private LinkedList<PrimaryEntry> primaryEntries;
    private Map<Range, PrimaryEntry> primaryIndex;
    private Map<FileEntry, Integer> localFilesIndex;
    private LinkedList<FileEntry> localFiles;
    private HashMap<DirEntry, Integer> localDirsIndex;
    private LinkedList<DirEntry> localDirs;
    private boolean includesDeoptTarget;

    public ClassEntry(String className, FileEntry fileEntry, int size) {
        super(className, size);
        this.fileEntry = fileEntry;
        this.methods = new LinkedList<MethodEntry>();
        this.primaryEntries = new LinkedList();
        this.primaryIndex = new HashMap<Range, PrimaryEntry>();
        this.localFiles = new LinkedList();
        this.localFilesIndex = new HashMap<FileEntry, Integer>();
        this.localDirs = new LinkedList();
        this.localDirsIndex = new HashMap();
        if (fileEntry != null) {
            this.localFiles.add(fileEntry);
            this.localFilesIndex.put(fileEntry, this.localFiles.size());
            DirEntry dirEntry = fileEntry.getDirEntry();
            if (dirEntry != null) {
                this.localDirs.add(dirEntry);
                this.localDirsIndex.put(dirEntry, this.localDirs.size());
            }
        }
    }

    @Override
    public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
        return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INSTANCE;
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        assert (TypeEntry.canonicalize(debugTypeInfo.typeName()).equals(this.typeName));
        DebugInfoProvider.DebugInstanceTypeInfo debugInstanceTypeInfo = (DebugInfoProvider.DebugInstanceTypeInfo)debugTypeInfo;
        String superName = debugInstanceTypeInfo.superName();
        if (superName != null) {
            superName = TypeEntry.canonicalize(superName);
        }
        debugContext.log("typename %s adding super %s\n", (Object)this.typeName, (Object)superName);
        if (superName != null) {
            this.superClass = debugInfoBase.lookupClassEntry(superName);
        }
        debugInstanceTypeInfo.interfaces().forEach(interfaceName -> this.processInterface((String)interfaceName, debugInfoBase, debugContext));
        debugInstanceTypeInfo.fieldInfoProvider().forEach(debugFieldInfo -> this.processField((DebugInfoProvider.DebugFieldInfo)debugFieldInfo, debugInfoBase, debugContext));
        debugInstanceTypeInfo.methodInfoProvider().forEach(methodFieldInfo -> this.processMethod((DebugInfoProvider.DebugMethodInfo)methodFieldInfo, debugInfoBase, debugContext));
    }

    public void indexPrimary(Range primary, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize) {
        if (this.primaryIndex.get(primary) == null) {
            PrimaryEntry primaryEntry = new PrimaryEntry(primary, frameSizeInfos, frameSize, this);
            this.primaryEntries.add(primaryEntry);
            this.primaryIndex.put(primary, primaryEntry);
            if (primary.isDeoptTarget()) {
                this.includesDeoptTarget = true;
            } else assert (!this.includesDeoptTarget);
            FileEntry primaryFileEntry = primary.getFileEntry();
            assert (primaryFileEntry != null);
            this.indexLocalFileEntry(primaryFileEntry);
        }
    }

    public void indexSubRange(Range subrange) {
        Range primary = subrange.getPrimary();
        assert (primary != null);
        PrimaryEntry primaryEntry = this.primaryIndex.get(primary);
        assert (primaryEntry != null);
        assert (primaryEntry.getClassEntry() == this);
        primaryEntry.addSubRange(subrange);
        FileEntry subFileEntry = subrange.getFileEntry();
        if (subFileEntry != null) {
            this.indexLocalFileEntry(subFileEntry);
        }
    }

    private void indexLocalFileEntry(FileEntry localFileEntry) {
        if (this.localFilesIndex.get(localFileEntry) == null) {
            this.localFiles.add(localFileEntry);
            this.localFilesIndex.put(localFileEntry, this.localFiles.size());
            DirEntry dirEntry = localFileEntry.getDirEntry();
            if (dirEntry != null && this.localDirsIndex.get(dirEntry) == null) {
                this.localDirs.add(dirEntry);
                this.localDirsIndex.put(dirEntry, this.localDirs.size());
            }
        }
    }

    public int localDirsIdx(DirEntry dirEntry) {
        if (dirEntry != null) {
            return this.localDirsIndex.get(dirEntry);
        }
        return 0;
    }

    public int localFilesIdx() {
        return this.localFilesIndex.get(this.fileEntry);
    }

    public int localFilesIdx(FileEntry fileEntry) {
        return this.localFilesIndex.get(fileEntry);
    }

    public String getFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFileName();
        }
        return "";
    }

    String getFullFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFullName();
        }
        return null;
    }

    String getDirName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getPathName();
        }
        return "";
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public LinkedList<PrimaryEntry> getPrimaryEntries() {
        return this.primaryEntries;
    }

    public Object primaryIndexFor(Range primaryRange) {
        return this.primaryIndex.get(primaryRange);
    }

    public LinkedList<DirEntry> getLocalDirs() {
        return this.localDirs;
    }

    public LinkedList<FileEntry> getLocalFiles() {
        return this.localFiles;
    }

    public boolean includesDeoptTarget() {
        return this.includesDeoptTarget;
    }

    public String getCachePath() {
        Path cachePath;
        if (this.fileEntry != null && (cachePath = this.fileEntry.getCachePath()) != null) {
            return cachePath.toString();
        }
        return "";
    }

    private void processInterface(String interfaceName, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        debugContext.log("typename %s adding interface %s\n", (Object)this.typeName, (Object)interfaceName);
        ClassEntry entry = debugInfoBase.lookupClassEntry(TypeEntry.canonicalize(interfaceName));
        assert (entry instanceof InterfaceClassEntry);
        InterfaceClassEntry interfaceClassEntry = (InterfaceClassEntry)entry;
        this.interfaces.add(interfaceClassEntry);
        interfaceClassEntry.addImplementor(this, debugContext);
    }

    protected void processMethod(DebugInfoProvider.DebugMethodInfo debugMethodInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        String methodName = debugInfoBase.uniqueDebugString(debugMethodInfo.name());
        String resultTypeName = TypeEntry.canonicalize(debugMethodInfo.valueType());
        int modifiers = debugMethodInfo.modifiers();
        List<String> paramTypes = debugMethodInfo.paramTypes();
        List<String> paramNames = debugMethodInfo.paramNames();
        assert (paramTypes.size() == paramNames.size());
        int paramCount = paramTypes.size();
        debugContext.log("typename %s adding %s method %s %s(%s)\n", (Object)this.typeName, (Object)this.memberModifiers(modifiers), (Object)resultTypeName, (Object)methodName, (Object)ClassEntry.formatParams(paramTypes, paramNames));
        TypeEntry resultType = debugInfoBase.lookupTypeEntry(resultTypeName);
        TypeEntry[] paramTypeArray = new TypeEntry[paramCount];
        String[] paramNameArray = new String[paramCount];
        int idx = 0;
        for (String paramTypeName : paramTypes) {
            TypeEntry paramType = debugInfoBase.lookupTypeEntry(TypeEntry.canonicalize(paramTypeName));
            paramTypeArray[idx++] = paramType;
        }
        paramNameArray = paramNames.toArray(paramNameArray);
        String fileName = debugMethodInfo.fileName();
        Path filePath = debugMethodInfo.filePath();
        Path cachePath = debugMethodInfo.cachePath();
        FileEntry methodFileEntry = debugInfoBase.ensureFileEntry(fileName, filePath, cachePath);
        this.methods.add(new MethodEntry(methodFileEntry, methodName, this, resultType, paramTypeArray, paramNameArray, modifiers));
    }

    @Override
    protected FieldEntry addField(DebugInfoProvider.DebugFieldInfo debugFieldInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        FieldEntry fieldEntry = super.addField(debugFieldInfo, debugInfoBase, debugContext);
        FileEntry fieldFileEntry = fieldEntry.getFileEntry();
        if (fieldFileEntry != null) {
            this.indexLocalFileEntry(fieldFileEntry);
        }
        return fieldEntry;
    }

    private static String formatParams(List<String> paramTypes, List<String> paramNames) {
        if (paramNames.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (int i = 0; i < paramNames.size(); ++i) {
            builder.append(separator);
            builder.append(paramTypes.get(i));
            String paramName = paramNames.get(i);
            if (paramName.length() > 0) {
                builder.append(' ');
                builder.append(paramName);
            }
            separator = ", ";
        }
        return builder.toString();
    }

    public boolean isPrimary() {
        return this.primaryEntries.size() != 0;
    }

    public ClassEntry getSuperClass() {
        return this.superClass;
    }

    public Range makePrimaryRange(String methodName, String symbolName, String paramSignature, String returnTypeName, StringTable stringTable, FileEntry primaryFileEntry, int lo, int hi, int primaryLine, int modifiers, boolean isDeoptTarget) {
        FileEntry fileEntryToUse = primaryFileEntry;
        if (fileEntryToUse == null) {
            for (MethodEntry methodEntry : this.methods) {
                if (!methodEntry.match(methodName, paramSignature, returnTypeName)) continue;
                fileEntryToUse = methodEntry.getFileEntry();
                break;
            }
            if (fileEntryToUse == null) {
                fileEntryToUse = this.fileEntry;
            }
        }
        return new Range(this.typeName, methodName, symbolName, paramSignature, returnTypeName, stringTable, fileEntryToUse, lo, hi, primaryLine, modifiers, isDeoptTarget);
    }
}

