/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.MemberEntry;
import com.oracle.objectfile.debugentry.TypeEntry;

public class MethodEntry
extends MemberEntry {
    TypeEntry[] paramTypes;
    String[] paramNames;

    public MethodEntry(FileEntry fileEntry, String methodName, ClassEntry ownerType, TypeEntry valueType, TypeEntry[] paramTypes, String[] paramNames, int modifiers) {
        super(fileEntry, methodName, ownerType, valueType, modifiers);
        assert (paramTypes == null && paramNames == null || paramTypes != null && paramNames != null && paramTypes.length == paramNames.length);
        this.paramTypes = paramTypes;
        this.paramNames = paramNames;
    }

    public String methodName() {
        return this.memberName;
    }

    @Override
    public ClassEntry ownerType() {
        assert (this.ownerType instanceof ClassEntry);
        return (ClassEntry)this.ownerType;
    }

    public int getParamCount() {
        return this.paramTypes == null ? 0 : this.paramTypes.length;
    }

    public TypeEntry getParamType(int idx) {
        assert (this.paramTypes != null);
        assert (idx < this.paramTypes.length);
        return this.paramTypes[idx];
    }

    public String getParamTypeName(int idx) {
        assert (this.paramTypes != null);
        assert (idx < this.paramTypes.length);
        assert (this.paramTypes[idx] != null);
        return this.paramTypes[idx].getTypeName();
    }

    public String getParamName(int idx) {
        assert (this.paramNames != null);
        assert (idx < this.paramNames.length);
        return this.paramNames[idx];
    }

    public boolean match(String methodName, String paramSignature, String returnTypeName) {
        if (!methodName.equals(this.memberName)) {
            return false;
        }
        if (!returnTypeName.equals(this.valueType.getTypeName())) {
            return false;
        }
        int paramCount = this.getParamCount();
        if (paramCount == 0) {
            return paramSignature.trim().length() == 0;
        }
        String[] paramTypeNames = paramSignature.split(",");
        if (paramCount != paramTypeNames.length) {
            return false;
        }
        for (int i = 0; i < paramCount; ++i) {
            if (paramTypeNames[i].trim().equals(this.getParamTypeName(i))) continue;
            return false;
        }
        return true;
    }
}

