/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.StringTable;

public class Range {
    private static final String CLASS_DELIMITER = ".";
    private FileEntry fileEntry;
    private String className;
    private String methodName;
    private String symbolName;
    private String paramSignature;
    private String returnTypeName;
    private String fullMethodName;
    private String fullMethodNameWithParams;
    private int lo;
    private int hi;
    private int line;
    private boolean isDeoptTarget;
    private int modifiers;
    private Range primary;

    public Range(String className, String methodName, String symbolName, String paramSignature, String returnTypeName, StringTable stringTable, FileEntry fileEntry, int lo, int hi, int line, int modifiers, boolean isDeoptTarget) {
        this(className, methodName, symbolName, paramSignature, returnTypeName, stringTable, fileEntry, lo, hi, line, modifiers, isDeoptTarget, null);
    }

    public Range(String className, String methodName, String symbolName, StringTable stringTable, FileEntry fileEntry, int lo, int hi, int line, Range primary) {
        this(className, methodName, symbolName, "", "", stringTable, fileEntry, lo, hi, line, 0, false, primary);
    }

    private Range(String className, String methodName, String symbolName, String paramSignature, String returnTypeName, StringTable stringTable, FileEntry fileEntry, int lo, int hi, int line, int modifiers, boolean isDeoptTarget, Range primary) {
        this.fileEntry = fileEntry;
        if (fileEntry != null) {
            stringTable.uniqueDebugString(fileEntry.getFileName());
            stringTable.uniqueDebugString(fileEntry.getPathName());
        }
        this.className = stringTable.uniqueString(className);
        this.methodName = stringTable.uniqueString(methodName);
        this.symbolName = stringTable.uniqueString(symbolName);
        this.paramSignature = stringTable.uniqueString(paramSignature);
        this.returnTypeName = stringTable.uniqueString(returnTypeName);
        this.fullMethodName = stringTable.uniqueString(this.constructClassAndMethodName());
        this.fullMethodNameWithParams = stringTable.uniqueString(this.constructClassAndMethodNameWithParams());
        this.lo = lo;
        this.hi = hi;
        this.line = line;
        this.isDeoptTarget = isDeoptTarget;
        this.modifiers = modifiers;
        this.primary = primary;
    }

    public boolean contains(Range other) {
        return this.lo <= other.lo && this.hi >= other.hi;
    }

    public boolean isPrimary() {
        return this.getPrimary() == null;
    }

    public Range getPrimary() {
        return this.primary;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public int getHi() {
        return this.hi;
    }

    public int getLo() {
        return this.lo;
    }

    public int getLine() {
        return this.line;
    }

    public String getFullMethodName() {
        return this.fullMethodName;
    }

    public String getFullMethodNameWithParams() {
        return this.fullMethodNameWithParams;
    }

    public boolean isDeoptTarget() {
        return this.isDeoptTarget;
    }

    private String getExtendedMethodName(boolean includeClass, boolean includeParams, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        if (includeReturnType && this.returnTypeName.length() > 0) {
            builder.append(this.returnTypeName);
            builder.append(' ');
        }
        if (includeClass && this.className != null) {
            builder.append(this.className);
            builder.append(CLASS_DELIMITER);
        }
        builder.append(this.methodName);
        if (includeParams) {
            builder.append('(');
            builder.append(this.paramSignature);
            builder.append(')');
        }
        if (includeReturnType) {
            builder.append(" ");
            builder.append(this.returnTypeName);
        }
        return builder.toString();
    }

    private String constructClassAndMethodName() {
        return this.getExtendedMethodName(true, false, false);
    }

    private String constructClassAndMethodNameWithParams() {
        return this.getExtendedMethodName(true, true, false);
    }

    public String getMethodReturnTypeName() {
        return this.returnTypeName;
    }

    public String getParamSignature() {
        return this.paramSignature;
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public void setFileEntry(FileEntry fileEntry) {
        this.fileEntry = fileEntry;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return String.format("Range(lo=0x%05x hi=0x%05x %s %s:%d)", this.lo, this.hi, this.constructClassAndMethodNameWithParams(), this.fileEntry.getFullName(), this.line);
    }

    public String getFileName() {
        return this.fileEntry.getFileName();
    }
}

