/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import java.util.LinkedList;
import java.util.Map;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfARangesSectionImpl
extends DwarfSectionImpl {
    private static final int DW_AR_HEADER_SIZE = 12;
    private static final int DW_AR_HEADER_PAD_SIZE = 4;
    private static final String TARGET_SECTION_NAME = ".debug_frame";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfARangesSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return ".debug_aranges";
    }

    @Override
    public void createContent() {
        LinkedList<PrimaryEntry> classPrimaryEntries;
        assert (!this.contentByteArrayCreated());
        int pos = 0;
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            pos += 12;
            pos += 4;
            classPrimaryEntries = classEntry.getPrimaryEntries();
            if (classEntry.includesDeoptTarget()) {
                for (PrimaryEntry classPrimaryEntry : classPrimaryEntries) {
                    if (classPrimaryEntry.getPrimary().isDeoptTarget()) continue;
                    pos += 16;
                }
            } else {
                pos += classPrimaryEntries.size() * 2 * 8;
            }
            pos += 16;
        }
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            if (!classEntry.includesDeoptTarget()) continue;
            pos += 12;
            pos += 4;
            classPrimaryEntries = classEntry.getPrimaryEntries();
            for (PrimaryEntry classPrimaryEntry : classPrimaryEntries) {
                if (!classPrimaryEntry.getPrimary().isDeoptTarget()) continue;
                pos += 16;
            }
            pos += 16;
        }
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        Object valueObj;
        ObjectFile.Element textElement = this.getElement().getOwner().elementForName(".text");
        LayoutDecisionMap decisionMap = alreadyDecided.get(textElement);
        if (decisionMap != null && (valueObj = decisionMap.getDecidedValue(LayoutDecision.Kind.VADDR)) != null && valueObj instanceof Number) {
            this.debugTextBase = ((Number)valueObj).longValue();
        }
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public void writeContent(DebugContext context) {
        Range primary;
        LinkedList<PrimaryEntry> classPrimaryEntries;
        int cuIndex;
        int length;
        int lastpos;
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_ARANGES", pos);
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            lastpos = pos;
            length = 12;
            cuIndex = this.getCUIndex(classEntry);
            classPrimaryEntries = classEntry.getPrimaryEntries();
            for (PrimaryEntry classPrimaryEntry : classPrimaryEntries) {
                primary = classPrimaryEntry.getPrimary();
                if (primary.isDeoptTarget()) continue;
                length += 16;
            }
            this.log(context, "  [0x%08x] %s CU %d length 0x%x", pos, classEntry.getFileName(), cuIndex, length += 16);
            pos = this.putInt(length, buffer, pos);
            pos = this.putShort((short)2, buffer, pos);
            pos = this.putInt(cuIndex, buffer, pos);
            pos = this.putByte((byte)8, buffer, pos);
            pos = this.putByte((byte)0, buffer, pos);
            assert (pos - lastpos == 12);
            for (int i = 0; i < 4; ++i) {
                pos = this.putByte((byte)0, buffer, pos);
            }
            this.log(context, "  [0x%08x] Address          Length           Name", pos);
            for (PrimaryEntry classPrimaryEntry : classPrimaryEntries) {
                primary = classPrimaryEntry.getPrimary();
                if (primary.isDeoptTarget()) continue;
                this.log(context, "  [0x%08x] %016x %016x %s", pos, this.debugTextBase + (long)primary.getLo(), primary.getHi() - primary.getLo(), primary.getFullMethodNameWithParams());
                pos = this.putRelocatableCodeOffset(primary.getLo(), buffer, pos);
                pos = this.putLong(primary.getHi() - primary.getLo(), buffer, pos);
            }
            pos = this.putLong(0L, buffer, pos);
            pos = this.putLong(0L, buffer, pos);
        }
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            if (!classEntry.includesDeoptTarget()) continue;
            lastpos = pos;
            length = 12;
            cuIndex = this.getDeoptCUIndex(classEntry);
            classPrimaryEntries = classEntry.getPrimaryEntries();
            for (PrimaryEntry classPrimaryEntry : classPrimaryEntries) {
                primary = classPrimaryEntry.getPrimary();
                if (!primary.isDeoptTarget()) continue;
                length += 16;
            }
            assert (length > 12);
            this.log(context, "  [0x%08x] %s CU linkage stubs %d length 0x%x", pos, classEntry.getFileName(), cuIndex, length += 16);
            pos = this.putInt(length, buffer, pos);
            pos = this.putShort((short)2, buffer, pos);
            pos = this.putInt(cuIndex, buffer, pos);
            pos = this.putByte((byte)8, buffer, pos);
            pos = this.putByte((byte)0, buffer, pos);
            assert (pos - lastpos == 12);
            for (int i = 0; i < 4; ++i) {
                pos = this.putByte((byte)0, buffer, pos);
            }
            this.log(context, "  [0x%08x] Address          Length           Name", pos);
            for (PrimaryEntry classPrimaryEntry : classPrimaryEntries) {
                primary = classPrimaryEntry.getPrimary();
                if (!primary.isDeoptTarget()) continue;
                this.log(context, "  [0x%08x] %016x %016x %s", pos, this.debugTextBase + (long)primary.getLo(), primary.getHi() - primary.getLo(), primary.getFullMethodNameWithParams());
                pos = this.putRelocatableCodeOffset(primary.getLo(), buffer, pos);
                pos = this.putLong(primary.getHi() - primary.getLo(), buffer, pos);
            }
            pos = this.putLong(0L, buffer, pos);
            pos = this.putLong(0L, buffer, pos);
        }
        assert (pos == size);
    }

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

