/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import java.util.List;
import org.graalvm.compiler.debug.DebugContext;

public abstract class DwarfFrameSectionImpl
extends DwarfSectionImpl {
    private static final int PADDING_NOPS_ALIGNMENT = 8;
    private static final String TARGET_SECTION_NAME = ".debug_line";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfFrameSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return ".debug_frame";
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int pos = 0;
        pos = this.writeCIE(null, pos);
        pos = this.writeMethodFrames(null, pos);
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        pos = this.writeCIE(buffer, pos);
        pos = this.writeMethodFrames(buffer, pos);
        if (pos != size) {
            System.out.format("pos = 0x%x  size = 0x%x", pos, size);
        }
        assert (pos == size);
    }

    private int writeCIE(byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            pos += this.putInt(0, scratch, 0);
            pos += this.putInt(-1, scratch, 0);
            pos += this.putByte((byte)1, scratch, 0);
            pos += this.putAsciiStringBytes("", scratch, 0);
            pos += this.putULEB(1L, scratch, 0);
            pos += this.putSLEB(-8L, scratch, 0);
            pos += this.putByte((byte)this.getReturnPCIdx(), scratch, 0);
            pos = this.writeInitialInstructions(buffer, pos);
            pos = this.writePaddingNops(buffer, pos);
            return pos;
        }
        int lengthPos = pos;
        pos = this.putInt(0, buffer, pos);
        pos = this.putInt(-1, buffer, pos);
        pos = this.putByte((byte)1, buffer, pos);
        pos = this.putAsciiStringBytes("", buffer, pos);
        pos = this.putULEB(1L, buffer, pos);
        pos = this.putSLEB(-8L, buffer, pos);
        pos = this.putByte((byte)this.getReturnPCIdx(), buffer, pos);
        pos = this.writeInitialInstructions(buffer, pos);
        pos = this.writePaddingNops(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeMethodFrames(byte[] buffer, int p) {
        int lengthPos;
        long hi;
        long lo;
        Range range;
        int pos = p;
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            for (PrimaryEntry primaryEntry : classEntry.getPrimaryEntries()) {
                range = primaryEntry.getPrimary();
                if (range.isDeoptTarget()) continue;
                lo = range.getLo();
                hi = range.getHi();
                lengthPos = pos;
                pos = this.writeFDEHeader((int)lo, (int)hi, buffer, pos);
                pos = this.writeFDEs(primaryEntry.getFrameSize(), primaryEntry.getFrameSizeInfos(), buffer, pos);
                pos = this.writePaddingNops(buffer, pos);
                this.patchLength(lengthPos, buffer, pos);
            }
        }
        for (ClassEntry classEntry : this.getPrimaryClasses()) {
            for (PrimaryEntry primaryEntry : classEntry.getPrimaryEntries()) {
                range = primaryEntry.getPrimary();
                if (!range.isDeoptTarget()) continue;
                lo = range.getLo();
                hi = range.getHi();
                lengthPos = pos;
                pos = this.writeFDEHeader((int)lo, (int)hi, buffer, pos);
                pos = this.writeFDEs(primaryEntry.getFrameSize(), primaryEntry.getFrameSizeInfos(), buffer, pos);
                pos = this.writePaddingNops(buffer, pos);
                this.patchLength(lengthPos, buffer, pos);
            }
        }
        return pos;
    }

    protected abstract int writeFDEs(int var1, List<DebugInfoProvider.DebugFrameSizeChange> var2, byte[] var3, int var4);

    private int writeFDEHeader(int lo, int hi, byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            pos += this.putInt(0, scratch, 0);
            pos += this.putInt(0, scratch, 0);
            return (pos += this.putLong(lo, scratch, 0)) + this.putLong(hi - lo, scratch, 0);
        }
        pos = this.putInt(0, buffer, pos);
        pos = this.putInt(0, buffer, pos);
        pos = this.putRelocatableCodeOffset(lo, buffer, pos);
        return this.putLong(hi - lo, buffer, pos);
    }

    private int writePaddingNops(byte[] buffer, int p) {
        int pos = p;
        while ((pos & 7) != 0) {
            if (buffer == null) {
                ++pos;
                continue;
            }
            pos = this.putByte((byte)0, buffer, pos);
        }
        return pos;
    }

    protected int writeDefCFA(int register, int offset, byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            pos += this.putByte((byte)12, scratch, 0);
            return (pos += this.putSLEB(register, scratch, 0)) + this.putULEB(offset, scratch, 0);
        }
        pos = this.putByte((byte)12, buffer, pos);
        pos = this.putULEB(register, buffer, pos);
        return this.putULEB(offset, buffer, pos);
    }

    protected int writeDefCFAOffset(int offset, byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte((byte)14, scratch, 0)) + this.putULEB(offset, scratch, 0);
        }
        pos = this.putByte((byte)14, buffer, pos);
        return this.putULEB(offset, buffer, pos);
    }

    protected int writeAdvanceLoc(int offset, byte[] buffer, int pos) {
        if (offset <= 63) {
            return this.writeAdvanceLoc0((byte)offset, buffer, pos);
        }
        if (offset <= 255) {
            return this.writeAdvanceLoc1((byte)offset, buffer, pos);
        }
        if (offset <= 65535) {
            return this.writeAdvanceLoc2((short)offset, buffer, pos);
        }
        return this.writeAdvanceLoc4(offset, buffer, pos);
    }

    protected int writeAdvanceLoc0(byte offset, byte[] buffer, int pos) {
        byte op = DwarfFrameSectionImpl.advanceLoc0Op(offset);
        if (buffer == null) {
            return pos + this.putByte(op, scratch, 0);
        }
        return this.putByte(op, buffer, pos);
    }

    protected int writeAdvanceLoc1(byte offset, byte[] buffer, int p) {
        int pos = p;
        byte op = 2;
        if (buffer == null) {
            return (pos += this.putByte(op, scratch, 0)) + this.putByte(offset, scratch, 0);
        }
        pos = this.putByte(op, buffer, pos);
        return this.putByte(offset, buffer, pos);
    }

    protected int writeAdvanceLoc2(short offset, byte[] buffer, int p) {
        byte op = 3;
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte(op, scratch, 0)) + this.putShort(offset, scratch, 0);
        }
        pos = this.putByte(op, buffer, pos);
        return this.putShort(offset, buffer, pos);
    }

    protected int writeAdvanceLoc4(int offset, byte[] buffer, int p) {
        byte op = 4;
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte(op, scratch, 0)) + this.putInt(offset, scratch, 0);
        }
        pos = this.putByte(op, buffer, pos);
        return this.putInt(offset, buffer, pos);
    }

    protected int writeOffset(int register, int offset, byte[] buffer, int p) {
        byte op = DwarfFrameSectionImpl.offsetOp(register);
        int pos = p;
        if (buffer == null) {
            return (pos += this.putByte(op, scratch, 0)) + this.putULEB(offset, scratch, 0);
        }
        pos = this.putByte(op, buffer, pos);
        return this.putULEB(offset, buffer, pos);
    }

    protected int writeRestore(int register, byte[] buffer, int p) {
        byte op = DwarfFrameSectionImpl.restoreOp(register);
        int pos = p;
        if (buffer == null) {
            return pos + this.putByte(op, scratch, 0);
        }
        return this.putByte(op, buffer, pos);
    }

    protected int writeRegister(int savedReg, int savedToReg, byte[] buffer, int p) {
        int pos = p;
        if (buffer == null) {
            pos += this.putByte((byte)9, scratch, 0);
            return (pos += this.putULEB(savedReg, scratch, 0)) + this.putULEB(savedToReg, scratch, 0);
        }
        pos = this.putByte((byte)9, buffer, pos);
        pos = this.putULEB(savedReg, buffer, pos);
        return this.putULEB(savedToReg, buffer, pos);
    }

    protected abstract int getReturnPCIdx();

    protected abstract int getSPIdx();

    protected abstract int writeInitialInstructions(byte[] var1, int var2);

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }

    private static byte offsetOp(int register) {
        assert (register >> 6 == 0);
        return (byte)(0x80 | register);
    }

    private static byte restoreOp(int register) {
        assert (register >> 6 == 0);
        return (byte)(0xC0 | register);
    }

    private static byte advanceLoc0Op(int offset) {
        assert (offset >= 0 && offset <= 63);
        return (byte)(0x40 | offset);
    }
}

