/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ArrayTypeEntry;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.EnumClassEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.PrimitiveTypeEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debugentry.StringTable;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.debug.DebugContext;

public abstract class DebugInfoBase {
    protected ByteOrder byteOrder;
    private StringTable stringTable = new StringTable();
    private Map<Path, DirEntry> dirsIndex = new HashMap<Path, DirEntry>();
    private List<TypeEntry> types = new ArrayList<TypeEntry>();
    private Map<String, TypeEntry> typesIndex = new HashMap<String, TypeEntry>();
    private List<ClassEntry> primaryClasses = new ArrayList<ClassEntry>();
    private Map<String, ClassEntry> primaryClassesIndex = new HashMap<String, ClassEntry>();
    private Map<Path, FileEntry> filesIndex = new HashMap<Path, FileEntry>();
    private List<FileEntry> files = new ArrayList<FileEntry>();
    private boolean useHeapBase;
    private int oopCompressShift;
    private int oopTagsCount;
    private int oopReferenceSize;
    private int pointerSize;
    private int oopAlignment;
    private int oopAlignShift;

    public DebugInfoBase(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.useHeapBase = true;
        this.oopTagsCount = 0;
        this.oopCompressShift = 0;
        this.oopReferenceSize = 0;
        this.pointerSize = 0;
        this.oopAlignment = 0;
        this.oopAlignShift = 0;
    }

    public void installDebugInfo(DebugInfoProvider debugInfoProvider) {
        this.useHeapBase = debugInfoProvider.useHeapBase();
        int oopTagsMask = debugInfoProvider.oopTagsMask();
        assert (oopTagsMask > 0 && oopTagsMask < 32);
        assert ((oopTagsMask + 1 & oopTagsMask) == 0);
        this.oopTagsCount = Integer.bitCount(oopTagsMask);
        this.oopCompressShift = debugInfoProvider.oopCompressShift();
        assert (this.oopCompressShift == 0 || this.oopCompressShift == 3);
        this.oopReferenceSize = debugInfoProvider.oopReferenceSize();
        this.pointerSize = debugInfoProvider.pointerSize();
        this.oopAlignment = debugInfoProvider.oopAlignment();
        this.oopAlignShift = Integer.bitCount(this.oopAlignment - 1);
        assert (this.oopAlignment == 8);
        this.stringTable.uniqueDebugString("");
        debugInfoProvider.typeInfoProvider().forEach(debugTypeInfo -> debugTypeInfo.debugContext(debugContext -> {
            String typeName = TypeEntry.canonicalize(debugTypeInfo.typeName());
            typeName = this.stringTable.uniqueDebugString(typeName);
            DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind = debugTypeInfo.typeKind();
            int byteSize = debugTypeInfo.size();
            debugContext.log(2, "Register %s type %s ", (Object)typeKind.toString(), (Object)typeName);
            String fileName = debugTypeInfo.fileName();
            Path filePath = debugTypeInfo.filePath();
            Path cachePath = debugTypeInfo.cachePath();
            this.addTypeEntry(typeName, fileName, filePath, cachePath, byteSize, typeKind);
        }));
        debugInfoProvider.typeInfoProvider().forEach(debugTypeInfo -> debugTypeInfo.debugContext(debugContext -> {
            String typeName = TypeEntry.canonicalize(debugTypeInfo.typeName());
            DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind = debugTypeInfo.typeKind();
            debugContext.log(2, "Process %s type %s ", (Object)typeKind.toString(), (Object)typeName);
            TypeEntry typeEntry = this.lookupTypeEntry(typeName);
            typeEntry.addDebugInfo(this, (DebugInfoProvider.DebugTypeInfo)debugTypeInfo, (DebugContext)debugContext);
        }));
        debugInfoProvider.codeInfoProvider().forEach(debugCodeInfo -> debugCodeInfo.debugContext(debugContext -> {
            String fileName = debugCodeInfo.fileName();
            Path filePath = debugCodeInfo.filePath();
            String className = TypeEntry.canonicalize(debugCodeInfo.ownerType());
            String methodName = debugCodeInfo.name();
            String symbolName = debugCodeInfo.symbolNameForMethod();
            int lo = debugCodeInfo.addressLo();
            int hi = debugCodeInfo.addressHi();
            int primaryLine = debugCodeInfo.line();
            ClassEntry classEntry = this.ensureClassEntry(className);
            MethodEntry methodEntry = classEntry.getMethodEntry((DebugInfoProvider.DebugMethodInfo)debugCodeInfo, this, (DebugContext)debugContext);
            Range primaryRange = classEntry.makePrimaryRange(symbolName, this.stringTable, methodEntry, lo, hi, primaryLine);
            debugContext.log(2, "PrimaryRange %s.%s %s %s:%d [0x%x, 0x%x]", (Object)className, (Object)methodName, (Object)filePath, (Object)fileName, (Object)primaryLine, (Object)lo, (Object)hi);
            classEntry.indexPrimary(primaryRange, debugCodeInfo.getFrameSizeChanges(), debugCodeInfo.getFrameSize());
            debugCodeInfo.lineInfoProvider().forEach(debugLineInfo -> {
                String fileNameAtLine = debugLineInfo.fileName();
                Path filePathAtLine = debugLineInfo.filePath();
                String classNameAtLine = TypeEntry.canonicalize(debugLineInfo.ownerType());
                String methodNameAtLine = debugLineInfo.name();
                String symbolNameAtLine = debugLineInfo.symbolNameForMethod();
                int loAtLine = lo + debugLineInfo.addressLo();
                int hiAtLine = lo + debugLineInfo.addressHi();
                int line = debugLineInfo.line();
                ClassEntry subClassEntry = this.ensureClassEntry(classNameAtLine);
                MethodEntry subMethodEntry = subClassEntry.getMethodEntry((DebugInfoProvider.DebugMethodInfo)debugLineInfo, this, (DebugContext)debugContext);
                Range subRange = new Range(symbolNameAtLine, this.stringTable, subMethodEntry, loAtLine, hiAtLine, line, primaryRange);
                classEntry.indexSubRange(subRange);
                try (DebugContext.Scope s = debugContext.scope((Object)"Subranges");){
                    debugContext.log(3, "SubRange %s.%s %s %s:%d 0x%x, 0x%x]", (Object)classNameAtLine, (Object)methodNameAtLine, (Object)filePathAtLine, (Object)fileNameAtLine, (Object)line, (Object)loAtLine, (Object)hiAtLine);
                }
            });
        }));
        debugInfoProvider.dataInfoProvider().forEach(debugDataInfo -> debugDataInfo.debugContext(debugContext -> {
            String provenance = debugDataInfo.getProvenance();
            String typeName = debugDataInfo.getTypeName();
            String partitionName = debugDataInfo.getPartition();
            long address = debugDataInfo.getAddress();
            long size = debugDataInfo.getSize();
            debugContext.log(2, "Data: address 0x%x size 0x%x type %s partition %s provenance %s ", (Object)address, (Object)size, (Object)typeName, (Object)partitionName, (Object)provenance);
        }));
    }

    private TypeEntry createTypeEntry(String typeName, String fileName, Path filePath, Path cachePath, int size, DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind) {
        TypeEntry typeEntry = null;
        switch (typeKind) {
            case INSTANCE: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath, cachePath);
                typeEntry = new ClassEntry(typeName, fileEntry, size);
                break;
            }
            case INTERFACE: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath, cachePath);
                typeEntry = new InterfaceClassEntry(typeName, fileEntry, size);
                break;
            }
            case ENUM: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath, cachePath);
                typeEntry = new EnumClassEntry(typeName, fileEntry, size);
                break;
            }
            case PRIMITIVE: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new PrimitiveTypeEntry(typeName, size);
                break;
            }
            case ARRAY: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new ArrayTypeEntry(typeName, size);
                break;
            }
            case HEADER: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new HeaderTypeEntry(typeName, size);
            }
        }
        return typeEntry;
    }

    private TypeEntry addTypeEntry(String typeName, String fileName, Path filePath, Path cachePath, int size, DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind) {
        TypeEntry typeEntry = this.typesIndex.get(typeName);
        if (typeEntry == null) {
            typeEntry = this.createTypeEntry(typeName, fileName, filePath, cachePath, size, typeKind);
            this.types.add(typeEntry);
            this.typesIndex.put(typeName, typeEntry);
        } else if (!typeEntry.isClass()) assert (((ClassEntry)typeEntry).getFileName().equals(fileName));
        return typeEntry;
    }

    public TypeEntry lookupTypeEntry(String typeName) {
        TypeEntry typeEntry = this.typesIndex.get(typeName);
        if (typeEntry == null) {
            throw new RuntimeException("type entry not found " + typeName);
        }
        return typeEntry;
    }

    ClassEntry lookupClassEntry(String typeName) {
        TypeEntry typeEntry = this.typesIndex.get(typeName);
        if (typeEntry == null || !typeEntry.isClass()) {
            throw new RuntimeException("class entry not found " + typeName);
        }
        return (ClassEntry)typeEntry;
    }

    private ClassEntry ensureClassEntry(String className) {
        ClassEntry classEntry = this.primaryClassesIndex.get(className);
        if (classEntry == null) {
            TypeEntry typeEntry = this.typesIndex.get(className);
            assert (typeEntry != null && typeEntry.isClass());
            classEntry = (ClassEntry)typeEntry;
            this.primaryClasses.add(classEntry);
            this.primaryClassesIndex.put(className, classEntry);
        }
        assert (classEntry.getTypeName().equals(className));
        return classEntry;
    }

    private FileEntry addFileEntry(String fileName, Path filePath, Path cachePath) {
        assert (fileName != null);
        Path fileAsPath = filePath != null ? filePath.resolve(fileName) : Paths.get(fileName, new String[0]);
        FileEntry fileEntry = this.filesIndex.get(fileAsPath);
        if (fileEntry == null) {
            DirEntry dirEntry = this.ensureDirEntry(filePath);
            this.uniqueDebugString(fileName);
            this.uniqueDebugString(cachePath.toString());
            fileEntry = new FileEntry(fileName, dirEntry, cachePath);
            this.files.add(fileEntry);
            this.filesIndex.put(fileAsPath, fileEntry);
        } else assert (filePath == null || fileEntry.getDirEntry().getPath().equals(filePath));
        return fileEntry;
    }

    protected FileEntry ensureFileEntry(String fileName, Path filePath, Path cachePath) {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        Path fileAsPath = filePath == null ? Paths.get(fileName, new String[0]) : filePath.resolve(fileName);
        FileEntry fileEntry = this.findFile(fileAsPath);
        if (fileEntry == null) {
            fileEntry = this.addFileEntry(fileName, filePath, cachePath);
        }
        return fileEntry;
    }

    private DirEntry ensureDirEntry(Path filePath) {
        if (filePath == null) {
            return null;
        }
        DirEntry dirEntry = this.dirsIndex.get(filePath);
        if (dirEntry == null) {
            this.uniqueDebugString(filePath.toString());
            dirEntry = new DirEntry(filePath);
            this.dirsIndex.put(filePath, dirEntry);
        }
        return dirEntry;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public List<TypeEntry> getTypes() {
        return this.types;
    }

    public List<ClassEntry> getPrimaryClasses() {
        return this.primaryClasses;
    }

    public List<FileEntry> getFiles() {
        return this.files;
    }

    public FileEntry findFile(Path fullFileName) {
        return this.filesIndex.get(fullFileName);
    }

    public StringTable getStringTable() {
        return this.stringTable;
    }

    public String uniqueDebugString(String string) {
        return this.stringTable.uniqueDebugString(string);
    }

    public int debugStringIndex(String string) {
        return this.stringTable.debugStringIndex(string);
    }

    public boolean useHeapBase() {
        return this.useHeapBase;
    }

    public byte oopTagsMask() {
        return (byte)((1 << this.oopTagsCount) - 1);
    }

    public byte oopTagsShift() {
        return (byte)this.oopTagsCount;
    }

    public int oopCompressShift() {
        return this.oopCompressShift;
    }

    public int oopReferenceSize() {
        return this.oopReferenceSize;
    }

    public int pointerSize() {
        return this.pointerSize;
    }

    public int oopAlignment() {
        return this.oopAlignment;
    }

    public int oopAlignShift() {
        return this.oopAlignShift;
    }

    public boolean isHubClassEntry(ClassEntry classEntry) {
        return classEntry.getTypeName().equals("java.lang.Class");
    }

    public int classLayoutAbbrevCode(ClassEntry classEntry) {
        if (this.useHeapBase & this.isHubClassEntry(classEntry)) {
            return 9;
        }
        return 8;
    }
}

