/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.MemberEntry;
import com.oracle.objectfile.debugentry.TypeEntry;

public class MethodEntry
extends MemberEntry
implements Comparable<MethodEntry> {
    final TypeEntry[] paramTypes;
    final String[] paramNames;
    final boolean isDeoptTarget;

    public MethodEntry(FileEntry fileEntry, String methodName, ClassEntry ownerType, TypeEntry valueType, TypeEntry[] paramTypes, String[] paramNames, int modifiers, boolean isDeoptTarget) {
        super(fileEntry, methodName, ownerType, valueType, modifiers);
        assert (paramTypes == null && paramNames == null || paramTypes != null && paramNames != null && paramTypes.length == paramNames.length);
        this.paramTypes = paramTypes;
        this.paramNames = paramNames;
        this.isDeoptTarget = isDeoptTarget;
    }

    public String methodName() {
        return this.memberName;
    }

    @Override
    public ClassEntry ownerType() {
        assert (this.ownerType instanceof ClassEntry);
        return (ClassEntry)this.ownerType;
    }

    public int getParamCount() {
        return this.paramTypes == null ? 0 : this.paramTypes.length;
    }

    public TypeEntry getParamType(int idx) {
        assert (this.paramTypes != null);
        assert (idx < this.paramTypes.length);
        return this.paramTypes[idx];
    }

    public String getParamTypeName(int idx) {
        assert (this.paramTypes != null);
        assert (idx < this.paramTypes.length);
        assert (this.paramTypes[idx] != null);
        return this.paramTypes[idx].getTypeName();
    }

    public String getParamName(int idx) {
        assert (this.paramNames != null);
        assert (idx < this.paramNames.length);
        return this.paramNames[idx];
    }

    public int compareTo(String methodName, String paramSignature, String returnTypeName) {
        int nameComparison = this.memberName.compareTo(methodName);
        if (nameComparison != 0) {
            return nameComparison;
        }
        int typeComparison = this.valueType.getTypeName().compareTo(returnTypeName);
        if (typeComparison != 0) {
            return typeComparison;
        }
        String[] paramTypeNames = paramSignature.split(",");
        int length = paramSignature.trim().length() == 0 ? 0 : paramTypeNames.length;
        int paramCountComparison = this.getParamCount() - length;
        if (paramCountComparison != 0) {
            return paramCountComparison;
        }
        for (int i = 0; i < this.getParamCount(); ++i) {
            int paraComparison = this.getParamTypeName(i).compareTo(paramTypeNames[i].trim());
            if (paraComparison == 0) continue;
            return paraComparison;
        }
        return 0;
    }

    public boolean isDeoptTarget() {
        return this.isDeoptTarget;
    }

    @Override
    public int compareTo(MethodEntry other) {
        assert (other != null);
        int nameComparison = this.methodName().compareTo(other.methodName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        int typeComparison = this.valueType.getTypeName().compareTo(other.valueType.getTypeName());
        if (typeComparison != 0) {
            return typeComparison;
        }
        int paramCountComparison = this.getParamCount() - other.getParamCount();
        if (paramCountComparison != 0) {
            return paramCountComparison;
        }
        for (int i = 0; i < this.getParamCount(); ++i) {
            int paramComparison = this.getParamTypeName(i).compareTo(other.getParamTypeName(i));
            if (paramComparison == 0) continue;
            return paramComparison;
        }
        return 0;
    }
}

