/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.ArrayList;
import java.util.List;

public class PrimaryEntry {
    private Range primary;
    private ClassEntry classEntry;
    private List<Range> subranges;
    private List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos;
    private int frameSize;

    public PrimaryEntry(Range primary, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize, ClassEntry classEntry) {
        this.primary = primary;
        this.classEntry = classEntry;
        this.subranges = new ArrayList<Range>();
        this.frameSizeInfos = frameSizeInfos;
        this.frameSize = frameSize;
    }

    public void addSubRange(Range subrange) {
        assert (!this.subranges.contains(subrange));
        this.subranges.add(subrange);
    }

    public Range getPrimary() {
        return this.primary;
    }

    public ClassEntry getClassEntry() {
        return this.classEntry;
    }

    public List<Range> getSubranges() {
        return this.subranges;
    }

    public List<DebugInfoProvider.DebugFrameSizeChange> getFrameSizeInfos() {
        return this.frameSizeInfos;
    }

    public int getFrameSize() {
        return this.frameSize;
    }
}

