/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.StringTable;
import com.oracle.objectfile.debugentry.TypeEntry;

public class Range {
    private static final String CLASS_DELIMITER = ".";
    private final FileEntry fileEntry;
    private MethodEntry methodEntry;
    private final String symbolName;
    private final String fullMethodNameWithParams;
    private final int lo;
    private final int hi;
    private final int line;
    private final Range primary;

    public Range(String symbolName, StringTable stringTable, MethodEntry methodEntry, FileEntry fileEntry, int lo, int hi, int line) {
        this(symbolName, stringTable, methodEntry, fileEntry, lo, hi, line, null);
    }

    public Range(String symbolName, StringTable stringTable, MethodEntry methodEntry, int lo, int hi, int line, Range primary) {
        this(symbolName, stringTable, methodEntry, methodEntry.fileEntry, lo, hi, line, primary);
    }

    private Range(String symbolName, StringTable stringTable, MethodEntry methodEntry, FileEntry fileEntry, int lo, int hi, int line, Range primary) {
        this.fileEntry = fileEntry;
        if (fileEntry != null) {
            stringTable.uniqueDebugString(fileEntry.getFileName());
            stringTable.uniqueDebugString(fileEntry.getPathName());
        }
        assert (methodEntry != null);
        this.methodEntry = methodEntry;
        this.symbolName = stringTable.uniqueString(symbolName);
        this.fullMethodNameWithParams = stringTable.uniqueString(this.constructClassAndMethodNameWithParams());
        this.lo = lo;
        this.hi = hi;
        this.line = line;
        this.primary = primary;
    }

    public boolean contains(Range other) {
        return this.lo <= other.lo && this.hi >= other.hi;
    }

    public boolean isPrimary() {
        return this.getPrimary() == null;
    }

    public Range getPrimary() {
        return this.primary;
    }

    public String getClassName() {
        return this.methodEntry.ownerType.typeName;
    }

    public String getMethodName() {
        return this.methodEntry.memberName;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public int getHi() {
        return this.hi;
    }

    public int getLo() {
        return this.lo;
    }

    public int getLine() {
        return this.line;
    }

    public String getFullMethodName() {
        return this.constructClassAndMethodName();
    }

    public String getFullMethodNameWithParams() {
        return this.fullMethodNameWithParams;
    }

    public boolean isDeoptTarget() {
        return this.methodEntry.isDeoptTarget;
    }

    private String getExtendedMethodName(boolean includeClass, boolean includeParams, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        if (includeReturnType && this.methodEntry.valueType.typeName.length() > 0) {
            builder.append(this.methodEntry.valueType.typeName);
            builder.append(' ');
        }
        if (includeClass && this.getClassName() != null) {
            builder.append(this.getClassName());
            builder.append(CLASS_DELIMITER);
        }
        builder.append(this.getMethodName());
        if (includeParams) {
            builder.append('(');
            builder.append(String.join((CharSequence)", ", this.methodEntry.paramNames));
            builder.append(')');
        }
        if (includeReturnType) {
            builder.append(" ");
            builder.append(this.methodEntry.valueType.typeName);
        }
        return builder.toString();
    }

    private String constructClassAndMethodName() {
        return this.getExtendedMethodName(true, false, false);
    }

    private String constructClassAndMethodNameWithParams() {
        return this.getExtendedMethodName(true, true, false);
    }

    public String getMethodReturnTypeName() {
        return this.methodEntry.valueType.typeName;
    }

    public TypeEntry[] getParamTypes() {
        return this.methodEntry.paramTypes;
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public int getModifiers() {
        return this.methodEntry.modifiers;
    }

    public String toString() {
        return String.format("Range(lo=0x%05x hi=0x%05x %s %s:%d)", this.lo, this.hi, this.constructClassAndMethodNameWithParams(), this.fileEntry.getFullName(), this.line);
    }

    public String getFileName() {
        return this.fileEntry.getFileName();
    }
}

