/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.debugentry.StringEntry;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfStrSectionImpl
extends DwarfSectionImpl {
    private static final String TARGET_SECTION_NAME = ".debug_info";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfStrSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return ".debug_str";
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int pos = 0;
        for (StringEntry stringEntry : this.dwarfSections.getStringTable()) {
            if (!stringEntry.isAddToStrSection()) continue;
            stringEntry.setOffset(pos);
            String string = stringEntry.getString();
            pos += string.length() + 1;
        }
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.verboseLog(context, " [0x%08x] DEBUG_STR", pos);
        for (StringEntry stringEntry : this.dwarfSections.getStringTable()) {
            if (!stringEntry.isAddToStrSection()) continue;
            assert (stringEntry.getOffset() == pos);
            String string = stringEntry.getString();
            pos = this.putAsciiStringBytes(string, buffer, pos);
            this.verboseLog(context, " [0x%08x] string = %s", pos, string);
        }
        assert (pos == size);
    }

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

