/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.StringTable;
import com.oracle.objectfile.SymbolTable;
import com.oracle.objectfile.elf.ELFObjectFile;
import com.oracle.objectfile.elf.ELFStrtab;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.io.OutputAssembler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class ELFSymtab
extends ELFObjectFile.ELFSection
implements SymbolTable {
    private final ELFStrtab strtab;
    private SortedSet<Entry> entries;
    private Map<String, Entry> entriesByName;
    private Map<Entry, Integer> entriesToIndex;

    @Override
    public ElementImpl getImpl() {
        return this;
    }

    private static int compareEntries(Entry a, Entry b) {
        int cmp = -Boolean.compare(a.isNull(), b.isNull());
        if (cmp == 0) {
            cmp = -Boolean.compare(a.binding == SymBinding.LOCAL, b.binding == SymBinding.LOCAL);
        }
        if (cmp == 0) {
            cmp = Boolean.compare(a.isDefined(), b.isDefined());
        }
        if (cmp == 0) {
            cmp = Boolean.compare(a.isAbsolute(), b.isAbsolute());
        }
        if (cmp == 0 && a.isDefined() && !a.isAbsolute()) {
            cmp = Math.toIntExact(a.getDefinedOffset() - b.getDefinedOffset());
        }
        if (cmp == 0) {
            return a.getName().compareTo(b.getName());
        }
        return cmp;
    }

    private void createNullEntry() {
        assert (this.entries.size() == 0);
        this.addEntry(new Entry());
    }

    @Override
    public int getEntrySize() {
        return new EntryStruct().getWrittenSize();
    }

    public ELFSymtab(ELFObjectFile owner, String name, boolean dynamic) {
        this(owner, name, dynamic, EnumSet.noneOf(ELFObjectFile.ELFSectionFlag.class));
    }

    public ELFSymtab(ELFObjectFile owner, String name, boolean dynamic, EnumSet<ELFObjectFile.ELFSectionFlag> extraFlags) {
        ELFObjectFile eLFObjectFile = owner;
        Objects.requireNonNull(eLFObjectFile);
        super(name, dynamic ? ELFObjectFile.SectionType.DYNSYM : ELFObjectFile.SectionType.SYMTAB);
        this.entries = new TreeSet<Entry>(ELFSymtab::compareEntries);
        this.entriesByName = new HashMap<String, Entry>();
        this.createNullEntry();
        this.flags.add(ELFObjectFile.ELFSectionFlag.ALLOC);
        this.flags.addAll(extraFlags);
        if (!dynamic) {
            this.strtab = new DefaultStrtabImpl(owner, ".strtab");
        } else {
            this.strtab = new DefaultStrtabImpl(owner, ".dynstr");
            this.flags.add(ELFObjectFile.ELFSectionFlag.ALLOC);
            this.strtab.flags.add(ELFObjectFile.ELFSectionFlag.ALLOC);
        }
    }

    @Override
    public ELFObjectFile.ELFSection getLinkedSection() {
        return this.strtab;
    }

    @Override
    public long getLinkedInfo() {
        int lastLocal = -1;
        int i = 0;
        for (Entry entry : this.entries) {
            if (!entry.isNull()) {
                if (entry.binding == SymBinding.LOCAL) {
                    lastLocal = i;
                } else if (lastLocal != -1) break;
            }
            ++i;
        }
        return lastLocal + 1;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        byte[] strtabContent = (byte[])alreadyDecided.get(this.strtab).getDecidedValue(LayoutDecision.Kind.CONTENT);
        StringTable table = new StringTable(ByteBuffer.wrap(strtabContent).order(this.getOwner().getByteOrder()));
        ByteBuffer outBuffer = ByteBuffer.allocate(this.getWrittenSize()).order(this.getOwner().getByteOrder());
        OutputAssembler out = AssemblyBuffer.createOutputAssembler(outBuffer);
        for (Entry e : this.entries) {
            EntryStruct s = new EntryStruct();
            s.name = table.indexFor(e.name);
            if (e.name.isEmpty()) {
                assert (e.isNull());
                s.write(out);
                continue;
            }
            if (e.pseudoSection != null) {
                if (e.pseudoSection == PseudoSection.ABS) {
                    s.value = e.value;
                } else assert (e.pseudoSection == PseudoSection.UNDEF);
            } else {
                s.value = e.value;
                if (this.isDynamic()) {
                    s.value += (long)((Integer)alreadyDecided.get(e.referencedSection).getDecidedValue(LayoutDecision.Kind.VADDR)).intValue();
                }
            }
            s.size = e.size;
            s.info = e.binding.createInfoByte(e.symType);
            s.other = e.binding.createVisibilityByte();
            s.shndx = (short)this.getOwner().getIndexForSection(e.referencedSection);
            s.write(out);
        }
        return out.getBlob();
    }

    private int getWrittenSize() {
        return this.entries.size() * this.getEntrySize();
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.getWrittenSize();
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        ArrayList<BuildDependency> ourDeps = new ArrayList<BuildDependency>(ObjectFile.defaultDependencies(decisions, this));
        ourDeps.add(BuildDependency.createOrGet(decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT), decisions.get(this.strtab).getDecision(LayoutDecision.Kind.CONTENT)));
        if (this.isDynamic()) {
            HashSet<ELFObjectFile.ELFSection> referencedSections = new HashSet<ELFObjectFile.ELFSection>();
            for (Entry ent : this.entries) {
                ELFObjectFile.ELFSection es = ent.referencedSection;
                if (es == null) continue;
                referencedSections.add(es);
            }
            for (ELFObjectFile.ELFSection es : referencedSections) {
                ourDeps.add(BuildDependency.createOrGet(decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT), decisions.get(es).getDecision(LayoutDecision.Kind.VADDR)));
            }
        }
        return ourDeps;
    }

    public boolean isDynamic() {
        return this.type.equals((Object)ELFObjectFile.SectionType.DYNSYM);
    }

    @Override
    public ObjectFile.Symbol newDefinedEntry(String name, ObjectFile.Section referencedSection, long referencedOffset, long size, boolean isGlobal, boolean isCode) {
        return this.addEntry(new Entry(name, referencedOffset, size, isGlobal ? SymBinding.GLOBAL : SymBinding.LOCAL, isCode ? SymType.FUNC : SymType.OBJECT, (ELFObjectFile.ELFSection)referencedSection));
    }

    @Override
    public ObjectFile.Symbol newUndefinedEntry(String name, boolean isCode) {
        return this.addEntry(new Entry(name, 0L, 0L, SymBinding.GLOBAL, isCode ? SymType.FUNC : SymType.OBJECT, PseudoSection.UNDEF));
    }

    private Entry addEntry(Entry entry) {
        if (this.entriesToIndex != null) {
            throw new IllegalArgumentException("Symbol table already sealed");
        }
        this.entries.add(entry);
        this.entriesByName.put(entry.getName(), entry);
        return entry;
    }

    public Entry getNullEntry() {
        return (Entry)this.entries.iterator().next();
    }

    public int indexOf(ObjectFile.Symbol sym) {
        Integer result;
        if (this.entriesToIndex == null) {
            this.initializeEntriesToIndex();
        }
        if ((result = this.entriesToIndex.get(sym)) == null) {
            return -1;
        }
        return result;
    }

    private void initializeEntriesToIndex() {
        this.entriesToIndex = new HashMap<Entry, Integer>(this.entries.size());
        int index = 0;
        for (Entry entry : this.entries) {
            this.entriesToIndex.put(entry, index);
            ++index;
        }
        assert (this.entriesToIndex.size() == this.entries.size());
    }

    @Override
    public Iterator<ObjectFile.Symbol> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Entry getSymbol(String name) {
        return this.entriesByName.get(name);
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this, offsetHint);
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return ObjectFile.defaultDecisions(this, copyingIn);
    }

    class DefaultStrtabImpl
    extends ELFStrtab {
        DefaultStrtabImpl(ELFObjectFile owner, String name) {
            super(owner, name);
            assert (owner == this.getOwner());
            this.addContentProvider(ELFSymtab.this.entriesByName.keySet());
        }
    }

    class EntryStruct {
        int name;
        long value;
        long size;
        byte info;
        byte other;
        short shndx;

        EntryStruct() {
        }

        public void write(OutputAssembler out) {
            switch (ELFSymtab.this.getOwner().getFileClass()) {
                case ELFCLASS32: {
                    out.write4Byte(this.name);
                    out.write4Byte(Math.toIntExact(this.value));
                    out.write4Byte(Math.toIntExact(this.size));
                    out.writeByte(this.info);
                    out.writeByte(this.other);
                    out.write2Byte(this.shndx);
                    break;
                }
                case ELFCLASS64: {
                    out.write4Byte(this.name);
                    out.writeByte(this.info);
                    out.writeByte(this.other);
                    out.write2Byte(this.shndx);
                    out.write8Byte(this.value);
                    out.write8Byte(this.size);
                }
            }
        }

        public int getWrittenSize() {
            switch (ELFSymtab.this.getOwner().getFileClass()) {
                case ELFCLASS32: {
                    return 16;
                }
                case ELFCLASS64: {
                    return 24;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum PseudoSection {
        ABS,
        COMMON,
        UNDEF;

    }

    public static enum SymType {
        NOTYPE,
        OBJECT,
        FUNC,
        SECTION,
        FILE,
        LOPROC,
        HIPROC;


        byte createInfoByte(SymBinding b) {
            return (byte)(this.ordinal() | b.ordinal() << 4);
        }
    }

    public static enum SymBinding {
        LOCAL{

            @Override
            byte createVisibilityByte() {
                return 2;
            }
        }
        ,
        GLOBAL,
        WEAK,
        LOPROC,
        HIPROC;


        byte createInfoByte(SymType type) {
            return type.createInfoByte(this);
        }

        byte createVisibilityByte() {
            return 0;
        }
    }

    static final class Entry
    implements ObjectFile.Symbol {
        private final String name;
        private final long value;
        private final long size;
        private final SymBinding binding;
        private final SymType symType;
        private final ELFObjectFile.ELFSection referencedSection;
        private final PseudoSection pseudoSection;

        @Override
        public boolean isDefined() {
            return this.pseudoSection == null || this.pseudoSection != PseudoSection.UNDEF;
        }

        @Override
        public boolean isAbsolute() {
            return this.pseudoSection != null && this.pseudoSection == PseudoSection.ABS;
        }

        @Override
        public boolean isCommon() {
            return this.pseudoSection != null && this.pseudoSection == PseudoSection.COMMON;
        }

        @Override
        public boolean isFunction() {
            return this.symType == SymType.FUNC;
        }

        @Override
        public boolean isGlobal() {
            return SymBinding.GLOBAL.equals((Object)this.binding);
        }

        public boolean isNull() {
            return this.name.isEmpty() && this.value == 0L && this.size == 0L && this.binding == null && this.symType == null && this.referencedSection == null && this.pseudoSection == null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getDefinedOffset() {
            if (!this.isDefined() || this.isAbsolute()) {
                throw new IllegalStateException("queried offset of an undefined or absolute symbol");
            }
            return this.value;
        }

        @Override
        public ObjectFile.Section getDefinedSection() {
            return this.referencedSection;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public long getDefinedAbsoluteValue() {
            if (!this.isAbsolute()) {
                throw new IllegalStateException("queried absolute value of a non-absolute symbol");
            }
            return this.value;
        }

        private Entry(String name, long value, long size, SymBinding binding, SymType type, ELFObjectFile.ELFSection referencedSection, PseudoSection pseudoSection) {
            this.name = name;
            this.value = value;
            this.size = size;
            this.binding = binding;
            this.symType = type;
            this.referencedSection = referencedSection;
            this.pseudoSection = pseudoSection;
            assert (referencedSection == null != (pseudoSection == null) || this.isNull());
        }

        Entry(String name, long value, long size, SymBinding binding, SymType type, ELFObjectFile.ELFSection referencedSection) {
            this(name, value, size, binding, type, referencedSection, null);
        }

        Entry(String name, long value, long size, SymBinding binding, SymType type, PseudoSection pseudoSection) {
            this(name, value, size, binding, type, null, pseudoSection);
        }

        private Entry() {
            this("", 0L, 0L, null, null, null, null);
        }
    }
}

