/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;

public class PrimaryEntry {
    private Range primary;
    private ClassEntry classEntry;
    private List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos;
    private int frameSize;

    public PrimaryEntry(Range primary, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize, ClassEntry classEntry) {
        this.primary = primary;
        this.classEntry = classEntry;
        this.frameSizeInfos = frameSizeInfos;
        this.frameSize = frameSize;
    }

    public Range getPrimary() {
        return this.primary;
    }

    public ClassEntry getClassEntry() {
        return this.classEntry;
    }

    public Iterator<Range> topDownRangeIterator() {
        return new Iterator<Range>(){
            final ArrayDeque<Range> workStack = new ArrayDeque();
            Range current;
            {
                this.current = PrimaryEntry.this.primary.getFirstCallee();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Range next() {
                assert (this.hasNext());
                Range result = this.current;
                this.forward();
                return result;
            }

            private void forward() {
                Range sibling = this.current.getSiblingCallee();
                assert (sibling == null || this.current.getHi() <= sibling.getLo()) : this.current.getHi() + " > " + sibling.getLo();
                if (!this.current.isLeaf()) {
                    if (sibling != null) {
                        this.workStack.push(sibling);
                    }
                    this.current = this.current.getFirstCallee();
                } else {
                    this.current = sibling != null ? sibling : this.workStack.pollFirst();
                }
            }
        };
    }

    public Iterator<Range> leafRangeIterator() {
        final Iterator<Range> iter = this.topDownRangeIterator();
        return new Iterator<Range>(){
            Range current;
            {
                this.current = this.forwardLeaf(iter);
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Range next() {
                assert (this.hasNext());
                Range result = this.current;
                this.current = this.forwardLeaf(iter);
                return result;
            }

            private Range forwardLeaf(Iterator<Range> t) {
                if (t.hasNext()) {
                    Range next = t.next();
                    while (next != null && !next.isLeaf()) {
                        next = t.next();
                    }
                    return next;
                }
                return null;
            }
        };
    }

    public List<DebugInfoProvider.DebugFrameSizeChange> getFrameSizeInfos() {
        return this.frameSizeInfos;
    }

    public int getFrameSize() {
        return this.frameSize;
    }
}

