/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.ELFMachine;
import com.oracle.objectfile.elf.dwarf.DwarfARangesSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfAbbrevSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfFrameSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfFrameSectionImplAArch64;
import com.oracle.objectfile.elf.dwarf.DwarfFrameSectionImplX86_64;
import com.oracle.objectfile.elf.dwarf.DwarfInfoSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfLineSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfLocSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfStrSectionImpl;
import java.nio.ByteOrder;
import java.util.HashMap;

public class DwarfDebugInfo
extends DebugInfoBase {
    public static final String TEXT_SECTION_NAME = ".text";
    public static final String HEAP_BEGIN_NAME = "__svm_heap_begin";
    public static final String DW_STR_SECTION_NAME = ".debug_str";
    public static final String DW_LINE_SECTION_NAME = ".debug_line";
    public static final String DW_FRAME_SECTION_NAME = ".debug_frame";
    public static final String DW_ABBREV_SECTION_NAME = ".debug_abbrev";
    public static final String DW_INFO_SECTION_NAME = ".debug_info";
    public static final String DW_LOC_SECTION_NAME = ".debug_loc";
    public static final String DW_ARANGES_SECTION_NAME = ".debug_aranges";
    public static final short DW_VERSION_2 = 2;
    public static final short DW_VERSION_4 = 4;
    public static final int DW_ABBREV_CODE_null = 0;
    public static final int DW_ABBREV_CODE_builtin_unit = 1;
    public static final int DW_ABBREV_CODE_class_unit1 = 2;
    public static final int DW_ABBREV_CODE_class_unit2 = 3;
    public static final int DW_ABBREV_CODE_array_unit = 4;
    public static final int DW_ABBREV_CODE_primitive_type = 5;
    public static final int DW_ABBREV_CODE_void_type = 6;
    public static final int DW_ABBREV_CODE_object_header = 7;
    public static final int DW_ABBREV_CODE_namespace = 8;
    public static final int DW_ABBREV_CODE_class_layout1 = 9;
    public static final int DW_ABBREV_CODE_class_layout2 = 10;
    public static final int DW_ABBREV_CODE_class_pointer = 11;
    public static final int DW_ABBREV_CODE_method_location = 12;
    public static final int DW_ABBREV_CODE_abstract_inline_method = 13;
    public static final int DW_ABBREV_CODE_static_field_location = 14;
    public static final int DW_ABBREV_CODE_array_layout = 15;
    public static final int DW_ABBREV_CODE_array_pointer = 16;
    public static final int DW_ABBREV_CODE_interface_layout = 17;
    public static final int DW_ABBREV_CODE_interface_pointer = 18;
    public static final int DW_ABBREV_CODE_indirect_layout = 19;
    public static final int DW_ABBREV_CODE_indirect_pointer = 20;
    public static final int DW_ABBREV_CODE_method_declaration = 21;
    public static final int DW_ABBREV_CODE_method_declaration_static = 22;
    public static final int DW_ABBREV_CODE_field_declaration1 = 23;
    public static final int DW_ABBREV_CODE_field_declaration2 = 24;
    public static final int DW_ABBREV_CODE_field_declaration3 = 25;
    public static final int DW_ABBREV_CODE_field_declaration4 = 26;
    public static final int DW_ABBREV_CODE_header_field = 27;
    public static final int DW_ABBREV_CODE_array_data_type = 28;
    public static final int DW_ABBREV_CODE_super_reference = 29;
    public static final int DW_ABBREV_CODE_interface_implementor = 30;
    public static final int DW_ABBREV_CODE_inlined_subroutine = 31;
    public static final int DW_ABBREV_CODE_inlined_subroutine_with_children = 32;
    public static final int DW_ABBREV_CODE_method_parameter_declaration1 = 33;
    public static final int DW_ABBREV_CODE_method_parameter_declaration2 = 34;
    public static final int DW_ABBREV_CODE_method_parameter_declaration3 = 35;
    public static final int DW_ABBREV_CODE_method_local_declaration1 = 36;
    public static final int DW_ABBREV_CODE_method_local_declaration2 = 37;
    public static final int DW_ABBREV_CODE_method_parameter_location1 = 38;
    public static final int DW_ABBREV_CODE_method_parameter_location2 = 39;
    public static final int DW_ABBREV_CODE_method_local_location1 = 40;
    public static final int DW_ABBREV_CODE_method_local_location2 = 41;
    public static final int DW_TAG_array_type = 1;
    public static final int DW_TAG_class_type = 2;
    public static final int DW_TAG_formal_parameter = 5;
    public static final int DW_TAG_member = 13;
    public static final int DW_TAG_pointer_type = 15;
    public static final int DW_TAG_compile_unit = 17;
    public static final int DW_TAG_structure_type = 19;
    public static final int DW_TAG_union_type = 23;
    public static final int DW_TAG_inheritance = 28;
    public static final int DW_TAG_base_type = 36;
    public static final int DW_TAG_subprogram = 46;
    public static final int DW_TAG_variable = 52;
    public static final int DW_TAG_namespace = 57;
    public static final int DW_TAG_unspecified_type = 59;
    public static final int DW_TAG_inlined_subroutine = 29;
    public static final int DW_AT_null = 0;
    public static final int DW_AT_location = 2;
    public static final int DW_AT_name = 3;
    public static final int DW_AT_byte_size = 11;
    public static final int DW_AT_bit_size = 13;
    public static final int DW_AT_stmt_list = 16;
    public static final int DW_AT_low_pc = 17;
    public static final int DW_AT_hi_pc = 18;
    public static final int DW_AT_language = 19;
    public static final int DW_AT_comp_dir = 27;
    public static final int DW_AT_containing_type = 29;
    public static final int DW_AT_inline = 32;
    public static final int DW_AT_abstract_origin = 49;
    public static final int DW_AT_accessibility = 50;
    public static final int DW_AT_artificial = 52;
    public static final int DW_AT_data_member_location = 56;
    public static final int DW_AT_decl_column = 57;
    public static final int DW_AT_decl_file = 58;
    public static final int DW_AT_decl_line = 59;
    public static final int DW_AT_declaration = 60;
    public static final int DW_AT_encoding = 62;
    public static final int DW_AT_external = 63;
    public static final int DW_AT_return_addr = 42;
    public static final int DW_AT_frame_base = 64;
    public static final int DW_AT_specification = 71;
    public static final int DW_AT_type = 73;
    public static final int DW_AT_data_location = 80;
    public static final int DW_AT_use_UTF8 = 83;
    public static final int DW_AT_call_file = 88;
    public static final int DW_AT_call_line = 89;
    public static final int DW_AT_object_pointer = 100;
    public static final int DW_AT_linkage_name = 110;
    public static final int DW_FORM_null = 0;
    public static final int DW_FORM_addr = 1;
    public static final int DW_FORM_data2 = 5;
    public static final int DW_FORM_data4 = 6;
    public static final int DW_FORM_data8 = 7;
    private static final int DW_FORM_string = 8;
    public static final int DW_FORM_block1 = 10;
    public static final int DW_FORM_ref_addr = 16;
    public static final int DW_FORM_ref1 = 17;
    public static final int DW_FORM_ref2 = 18;
    public static final int DW_FORM_ref4 = 19;
    public static final int DW_FORM_ref8 = 20;
    public static final int DW_FORM_sec_offset = 23;
    public static final int DW_FORM_data1 = 11;
    public static final int DW_FORM_flag = 12;
    public static final int DW_FORM_strp = 14;
    public static final int DW_FORM_expr_loc = 24;
    public static final byte DW_CHILDREN_no = 0;
    public static final byte DW_CHILDREN_yes = 1;
    public static final byte DW_FLAG_false = 0;
    public static final byte DW_FLAG_true = 1;
    public static final byte DW_LANG_Java = 11;
    public static final byte LANG_ENCODING = 11;
    public static final byte DW_INL_not_inlined = 0;
    public static final byte DW_INL_inlined = 1;
    public static final byte DW_INL_declared_not_inlined = 2;
    public static final byte DW_INL_declared_inlined = 3;
    public static final byte DW_ACCESS_public = 1;
    public static final byte DW_ACCESS_protected = 2;
    public static final byte DW_ACCESS_private = 3;
    public static final byte DW_ATE_address = 1;
    public static final byte DW_ATE_boolean = 2;
    public static final byte DW_ATE_float = 4;
    public static final byte DW_ATE_signed = 5;
    public static final byte DW_ATE_signed_char = 6;
    public static final byte DW_ATE_unsigned = 7;
    public static final int DW_CFA_CIE_id = -1;
    public static final int DW_CFA_FDE_id = 0;
    public static final byte DW_CFA_CIE_version = 1;
    public static final byte DW_CFA_advance_loc = 1;
    public static final byte DW_CFA_offset = 2;
    public static final byte DW_CFA_restore = 3;
    public static final byte DW_CFA_nop = 0;
    public static final byte DW_CFA_set_loc1 = 1;
    public static final byte DW_CFA_advance_loc1 = 2;
    public static final byte DW_CFA_advance_loc2 = 3;
    public static final byte DW_CFA_advance_loc4 = 4;
    public static final byte DW_CFA_offset_extended = 5;
    public static final byte DW_CFA_restore_extended = 6;
    public static final byte DW_CFA_undefined = 7;
    public static final byte DW_CFA_same_value = 8;
    public static final byte DW_CFA_register = 9;
    public static final byte DW_CFA_def_cfa = 12;
    public static final byte DW_CFA_def_cfa_register = 13;
    public static final byte DW_CFA_def_cfa_offset = 14;
    public static final byte DW_OP_addr = 3;
    public static final byte DW_OP_deref = 6;
    public static final byte DW_OP_dup = 18;
    public static final byte DW_OP_and = 26;
    public static final byte DW_OP_not = 32;
    public static final byte DW_OP_plus = 34;
    public static final byte DW_OP_shl = 36;
    public static final byte DW_OP_shr = 37;
    public static final byte DW_OP_bra = 40;
    public static final byte DW_OP_eq = 41;
    public static final byte DW_OP_lit0 = 48;
    public static final byte DW_OP_reg0 = 80;
    public static final byte DW_OP_breg0 = 112;
    public static final byte DW_OP_regx = -112;
    public static final byte DW_OP_bregx = -110;
    public static final byte DW_OP_push_object_address = -105;
    public static final byte DW_OP_implicit_value = -98;
    public static final byte DW_OP_stack_value = -97;
    public static final byte rheapbase_aarch64 = 27;
    public static final byte rthread_aarch64 = 28;
    public static final byte rheapbase_x86 = 14;
    public static final byte rthread_x86 = 15;
    public static final String INDIRECT_PREFIX = "_z_.";
    public static final String HUB_TYPE_NAME = "java.lang.Class";
    private DwarfStrSectionImpl dwarfStrSection;
    private DwarfAbbrevSectionImpl dwarfAbbrevSection;
    private DwarfInfoSectionImpl dwarfInfoSection;
    private DwarfLocSectionImpl dwarfLocSection;
    private DwarfARangesSectionImpl dwarfARangesSection;
    private DwarfLineSectionImpl dwarfLineSection;
    private DwarfFrameSectionImpl dwarfFameSection;
    public final ELFMachine elfMachine;
    private byte heapbaseRegister;
    private byte threadRegister;
    private HashMap<TypeEntry, DwarfTypeProperties> typePropertiesIndex;
    private HashMap<MethodEntry, DwarfMethodProperties> methodPropertiesIndex;
    private HashMap<MethodEntry, DwarfLocalProperties> methodLocalPropertiesIndex;
    private HashMap<Range, DwarfLocalProperties> rangeLocalPropertiesIndex;

    public DwarfDebugInfo(ELFMachine elfMachine, ByteOrder byteOrder) {
        super(byteOrder);
        this.elfMachine = elfMachine;
        this.dwarfStrSection = new DwarfStrSectionImpl(this);
        this.dwarfAbbrevSection = new DwarfAbbrevSectionImpl(this);
        this.dwarfInfoSection = new DwarfInfoSectionImpl(this);
        this.dwarfLocSection = new DwarfLocSectionImpl(this);
        this.dwarfARangesSection = new DwarfARangesSectionImpl(this);
        this.dwarfLineSection = new DwarfLineSectionImpl(this);
        if (elfMachine == ELFMachine.AArch64) {
            this.dwarfFameSection = new DwarfFrameSectionImplAArch64(this);
            this.heapbaseRegister = (byte)27;
            this.threadRegister = (byte)28;
        } else {
            this.dwarfFameSection = new DwarfFrameSectionImplX86_64(this);
            this.heapbaseRegister = (byte)14;
            this.threadRegister = (byte)15;
        }
        this.typePropertiesIndex = new HashMap();
        this.methodPropertiesIndex = new HashMap();
        this.methodLocalPropertiesIndex = new HashMap();
        this.rangeLocalPropertiesIndex = new HashMap();
    }

    public DwarfStrSectionImpl getStrSectionImpl() {
        return this.dwarfStrSection;
    }

    public DwarfAbbrevSectionImpl getAbbrevSectionImpl() {
        return this.dwarfAbbrevSection;
    }

    public DwarfFrameSectionImpl getFrameSectionImpl() {
        return this.dwarfFameSection;
    }

    public DwarfInfoSectionImpl getInfoSectionImpl() {
        return this.dwarfInfoSection;
    }

    public DwarfLocSectionImpl getLocSectionImpl() {
        return this.dwarfLocSection;
    }

    public DwarfARangesSectionImpl getARangesSectionImpl() {
        return this.dwarfARangesSection;
    }

    public DwarfLineSectionImpl getLineSectionImpl() {
        return this.dwarfLineSection;
    }

    public byte getHeapbaseRegister() {
        return this.heapbaseRegister;
    }

    public byte getThreadRegister() {
        return this.threadRegister;
    }

    private DwarfTypeProperties addTypeProperties(TypeEntry typeEntry) {
        assert (typeEntry != null);
        assert (!typeEntry.isClass());
        assert (this.typePropertiesIndex.get(typeEntry) == null);
        DwarfTypeProperties typeProperties = new DwarfTypeProperties(typeEntry);
        this.typePropertiesIndex.put(typeEntry, typeProperties);
        return typeProperties;
    }

    private DwarfClassProperties addClassProperties(StructureTypeEntry entry) {
        assert (this.typePropertiesIndex.get(entry) == null);
        DwarfClassProperties classProperties = new DwarfClassProperties(entry);
        this.typePropertiesIndex.put(entry, classProperties);
        return classProperties;
    }

    private DwarfMethodProperties addMethodProperties(MethodEntry methodEntry) {
        assert (this.methodPropertiesIndex.get(methodEntry) == null);
        DwarfMethodProperties methodProperties = new DwarfMethodProperties();
        this.methodPropertiesIndex.put(methodEntry, methodProperties);
        return methodProperties;
    }

    private DwarfTypeProperties lookupTypeProperties(TypeEntry typeEntry) {
        if (typeEntry instanceof ClassEntry) {
            return this.lookupClassProperties((ClassEntry)typeEntry);
        }
        DwarfTypeProperties typeProperties = this.typePropertiesIndex.get(typeEntry);
        if (typeProperties == null) {
            typeProperties = this.addTypeProperties(typeEntry);
        }
        return typeProperties;
    }

    private DwarfClassProperties lookupClassProperties(StructureTypeEntry entry) {
        DwarfTypeProperties typeProperties = this.typePropertiesIndex.get(entry);
        assert (typeProperties == null || typeProperties instanceof DwarfClassProperties);
        DwarfClassProperties classProperties = (DwarfClassProperties)typeProperties;
        if (classProperties == null) {
            classProperties = this.addClassProperties(entry);
        }
        return classProperties;
    }

    private DwarfMethodProperties lookupMethodProperties(MethodEntry methodEntry) {
        DwarfMethodProperties methodProperties = this.methodPropertiesIndex.get(methodEntry);
        if (methodProperties == null) {
            methodProperties = this.addMethodProperties(methodEntry);
        }
        return methodProperties;
    }

    void setTypeIndex(TypeEntry typeEntry, int idx) {
        DwarfTypeProperties typeProperties = this.lookupTypeProperties(typeEntry);
        assert (typeProperties.getTypeInfoIndex() == -1 || typeProperties.getTypeInfoIndex() == idx);
        typeProperties.setTypeInfoIndex(idx);
    }

    int getTypeIndex(TypeEntry typeEntry) {
        DwarfTypeProperties typeProperties = this.lookupTypeProperties(typeEntry);
        return this.getTypeIndex(typeProperties);
    }

    int getTypeIndex(DwarfTypeProperties typeProperties) {
        assert (typeProperties.getTypeInfoIndex() >= 0);
        return typeProperties.getTypeInfoIndex();
    }

    void setIndirectTypeIndex(TypeEntry typeEntry, int idx) {
        DwarfTypeProperties typeProperties = this.lookupTypeProperties(typeEntry);
        assert (typeProperties.getIndirectTypeInfoIndex() == -1 || typeProperties.getIndirectTypeInfoIndex() == idx);
        typeProperties.setIndirectTypeInfoIndex(idx);
    }

    int getIndirectTypeIndex(TypeEntry typeEntry) {
        DwarfTypeProperties typeProperties = this.lookupTypeProperties(typeEntry);
        return this.getIndirectTypeIndex(typeProperties);
    }

    int getIndirectTypeIndex(DwarfTypeProperties typeProperties) {
        assert (typeProperties.getIndirectTypeInfoIndex() >= 0);
        return typeProperties.getIndirectTypeInfoIndex();
    }

    void setCUIndex(ClassEntry classEntry, int idx) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.cuIndex == -1 || classProperties.cuIndex == idx);
        classProperties.cuIndex = idx;
    }

    int getCUIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.cuIndex >= 0);
        return classProperties.cuIndex;
    }

    void setDeoptCUIndex(ClassEntry classEntry, int idx) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.deoptCUIndex == -1 || classProperties.deoptCUIndex == idx);
        classProperties.deoptCUIndex = idx;
    }

    int getDeoptCUIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.deoptCUIndex >= 0);
        return classProperties.deoptCUIndex;
    }

    void setLayoutIndex(ClassEntry classEntry, int idx) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.layoutIndex == -1 || classProperties.layoutIndex == idx);
        classProperties.layoutIndex = idx;
    }

    int getLayoutIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.layoutIndex >= 0);
        return classProperties.layoutIndex;
    }

    void setIndirectLayoutIndex(ClassEntry classEntry, int idx) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.indirectLayoutIndex == -1 || classProperties.indirectLayoutIndex == idx);
        classProperties.indirectLayoutIndex = idx;
    }

    int getIndirectLayoutIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.indirectLayoutIndex >= 0);
        return classProperties.indirectLayoutIndex;
    }

    void setLineIndex(ClassEntry classEntry, int idx) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.lineIndex == -1 || classProperties.lineIndex == idx);
        classProperties.lineIndex = idx;
    }

    public int getLineIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.lineIndex >= -1);
        return classProperties.lineIndex;
    }

    public void setLinePrologueSize(ClassEntry classEntry, int prologueSize) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.linePrologueSize == -1 || classProperties.linePrologueSize == prologueSize);
        classProperties.linePrologueSize = prologueSize;
    }

    public int getLinePrologueSize(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.linePrologueSize >= 0);
        return classProperties.linePrologueSize;
    }

    public void setLineSectionSize(ClassEntry classEntry, int totalSize) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.lineSectionSize == -1 || classProperties.lineSectionSize == totalSize);
        classProperties.lineSectionSize = totalSize;
    }

    public int getLineSectionSize(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.lineSectionSize >= 0);
        return classProperties.lineSectionSize;
    }

    public void setFieldDeclarationIndex(StructureTypeEntry entry, String fieldName, int pos) {
        DwarfClassProperties classProperties = this.lookupClassProperties(entry);
        assert (classProperties.getTypeEntry() == entry);
        HashMap<String, Integer> fieldDeclarationIndex = classProperties.fieldDeclarationIndex;
        if (fieldDeclarationIndex == null) {
            fieldDeclarationIndex = new HashMap();
            classProperties.fieldDeclarationIndex = fieldDeclarationIndex;
        }
        if (fieldDeclarationIndex.get(fieldName) != null) {
            assert (fieldDeclarationIndex.get(fieldName) == pos) : entry.getTypeName() + fieldName;
        } else {
            fieldDeclarationIndex.put(fieldName, pos);
        }
    }

    public int getFieldDeclarationIndex(StructureTypeEntry entry, String fieldName) {
        DwarfClassProperties classProperties = this.lookupClassProperties(entry);
        assert (classProperties.getTypeEntry() == entry);
        HashMap<String, Integer> fieldDeclarationIndex = classProperties.fieldDeclarationIndex;
        assert (fieldDeclarationIndex != null) : fieldName;
        assert (fieldDeclarationIndex.get(fieldName) != null) : entry.getTypeName() + fieldName;
        return fieldDeclarationIndex.get(fieldName);
    }

    public void setMethodDeclarationIndex(MethodEntry methodEntry, int pos) {
        DwarfMethodProperties methodProperties = this.lookupMethodProperties(methodEntry);
        methodProperties.setMethodDeclarationIndex(pos);
    }

    public int getMethodDeclarationIndex(MethodEntry methodEntry) {
        DwarfMethodProperties methodProperties = this.lookupMethodProperties(methodEntry);
        return methodProperties.getMethodDeclarationIndex();
    }

    public void setAbstractInlineMethodIndex(ClassEntry classEntry, MethodEntry methodEntry, int pos) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        HashMap<MethodEntry, Integer> abstractInlineMethodIndex = classProperties.abstractInlineMethodIndex;
        if (abstractInlineMethodIndex == null) {
            abstractInlineMethodIndex = new HashMap();
            classProperties.abstractInlineMethodIndex = abstractInlineMethodIndex;
        }
        if (abstractInlineMethodIndex.get(methodEntry) != null) {
            assert (abstractInlineMethodIndex.get(methodEntry) == pos) : classEntry.getTypeName() + " & " + methodEntry.getSymbolName();
        } else {
            abstractInlineMethodIndex.put(methodEntry, pos);
        }
    }

    public int getAbstractInlineMethodIndex(ClassEntry classEntry, MethodEntry methodEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        HashMap<MethodEntry, Integer> abstractInlineMethodIndex = classProperties.abstractInlineMethodIndex;
        assert (abstractInlineMethodIndex != null) : classEntry.getTypeName() + " & " + methodEntry.getSymbolName();
        assert (abstractInlineMethodIndex.get(methodEntry) != null) : classEntry.getTypeName() + " & " + methodEntry.getSymbolName();
        return abstractInlineMethodIndex.get(methodEntry);
    }

    private DwarfLocalProperties addRangeLocalProperties(Range range) {
        DwarfLocalProperties localProperties = new DwarfLocalProperties();
        this.rangeLocalPropertiesIndex.put(range, localProperties);
        return localProperties;
    }

    public DwarfLocalProperties lookupLocalProperties(ClassEntry classEntry, MethodEntry methodEntry) {
        HashMap<MethodEntry, DwarfLocalProperties> map;
        if (classEntry == null) {
            map = this.methodLocalPropertiesIndex;
        } else {
            DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
            assert (classProperties != null);
            map = classProperties.methodLocalPropertiesIndex;
            if (map == null) {
                classProperties.methodLocalPropertiesIndex = new HashMap();
                map = classProperties.methodLocalPropertiesIndex;
            }
        }
        DwarfLocalProperties localProperties = map.get(methodEntry);
        if (localProperties == null) {
            localProperties = new DwarfLocalProperties();
            map.put(methodEntry, localProperties);
        }
        return localProperties;
    }

    public void setMethodLocalIndex(ClassEntry classEntry, MethodEntry methodEntry, DebugInfoProvider.DebugLocalInfo localInfo, int index) {
        DwarfLocalProperties localProperties = this.lookupLocalProperties(classEntry, methodEntry);
        localProperties.setIndex(localInfo, index);
    }

    public int getMethodLocalIndex(ClassEntry classEntry, MethodEntry methodEntry, DebugInfoProvider.DebugLocalInfo localinfo) {
        DwarfLocalProperties localProperties = this.lookupLocalProperties(classEntry, methodEntry);
        assert (localProperties != null) : "get of non-existent local index";
        int index = localProperties.getIndex(localinfo);
        assert (index >= 0) : "get of local index before it was set";
        return index;
    }

    public void setRangeLocalIndex(Range range, DebugInfoProvider.DebugLocalInfo localInfo, int index) {
        DwarfLocalProperties rangeProperties = this.rangeLocalPropertiesIndex.get(range);
        if (rangeProperties == null) {
            rangeProperties = this.addRangeLocalProperties(range);
        }
        rangeProperties.setIndex(localInfo, index);
    }

    public int getRangeLocalIndex(Range range, DebugInfoProvider.DebugLocalInfo localinfo) {
        DwarfLocalProperties rangeProperties = this.rangeLocalPropertiesIndex.get(range);
        assert (rangeProperties != null) : "get of non-existent local index";
        int index = rangeProperties.getIndex(localinfo);
        assert (index >= 0) : "get of local index before it was set";
        return index;
    }

    static final class DwarfLocalProperties {
        private HashMap<DebugInfoProvider.DebugLocalInfo, Integer> locals = new HashMap();

        private DwarfLocalProperties() {
        }

        int getIndex(DebugInfoProvider.DebugLocalInfo localInfo) {
            return this.locals.get(localInfo);
        }

        void setIndex(DebugInfoProvider.DebugLocalInfo localInfo, int index) {
            if (this.locals.get(localInfo) != null) {
                assert (this.locals.get(localInfo) == index);
            } else {
                this.locals.put(localInfo, index);
            }
        }
    }

    static class DwarfMethodProperties {
        private int methodDeclarationIndex = -1;
        private int abstractInlineMethodIndex = -1;

        DwarfMethodProperties() {
        }

        public int getMethodDeclarationIndex() {
            assert (this.methodDeclarationIndex >= 0) : "unset declaration index";
            return this.methodDeclarationIndex;
        }

        public int getAbstractInlineMethodIndex() {
            assert (this.abstractInlineMethodIndex >= 0) : "unset inline index";
            return this.abstractInlineMethodIndex;
        }

        public void setMethodDeclarationIndex(int pos) {
            assert (this.methodDeclarationIndex == -1 || this.methodDeclarationIndex == pos) : "bad declaration index";
            this.methodDeclarationIndex = pos;
        }

        public void setAbstractInlineMethodIndex(int pos) {
            assert (this.abstractInlineMethodIndex == -1 || this.abstractInlineMethodIndex == pos) : "bad inline index";
            this.abstractInlineMethodIndex = pos;
        }
    }

    static class DwarfClassProperties
    extends DwarfTypeProperties {
        private int cuIndex = -1;
        private int deoptCUIndex = -1;
        private int layoutIndex = -1;
        private int indirectLayoutIndex = -1;
        private int lineIndex = -1;
        private int linePrologueSize = -1;
        private int lineSectionSize = -1;
        private HashMap<String, Integer> fieldDeclarationIndex = null;
        private HashMap<MethodEntry, Integer> abstractInlineMethodIndex = null;
        private HashMap<MethodEntry, DwarfLocalProperties> methodLocalPropertiesIndex = null;

        DwarfClassProperties(StructureTypeEntry entry) {
            super(entry);
        }
    }

    static class DwarfTypeProperties {
        private int typeInfoIndex;
        private int indirectTypeInfoIndex;
        private final TypeEntry typeEntry;

        public int getTypeInfoIndex() {
            return this.typeInfoIndex;
        }

        public void setTypeInfoIndex(int typeInfoIndex) {
            this.typeInfoIndex = typeInfoIndex;
        }

        public int getIndirectTypeInfoIndex() {
            return this.indirectTypeInfoIndex;
        }

        public void setIndirectTypeInfoIndex(int typeInfoIndex) {
            this.indirectTypeInfoIndex = typeInfoIndex;
        }

        public TypeEntry getTypeEntry() {
            return this.typeEntry;
        }

        DwarfTypeProperties(TypeEntry typeEntry) {
            this.typeEntry = typeEntry;
            this.typeInfoIndex = -1;
            this.indirectTypeInfoIndex = -1;
        }
    }
}

