/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.MemberEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.ArrayList;
import java.util.ListIterator;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

public class MethodEntry
extends MemberEntry {
    private final TypeEntry[] paramTypes;
    private final DebugInfoProvider.DebugLocalInfo thisParam;
    private final DebugInfoProvider.DebugLocalInfo[] paramInfos;
    private final int firstLocalSlot;
    private final ArrayList<DebugInfoProvider.DebugLocalInfo> locals;
    static final int DEOPT = 1;
    static final int IN_RANGE = 2;
    static final int INLINED = 4;
    static final int IS_OVERRIDE = 8;
    static final int IS_CONSTRUCTOR = 16;
    int flags;
    int vtableOffset = -1;
    final String symbolName;

    public MethodEntry(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugMethodInfo debugMethodInfo, FileEntry fileEntry, int line, String methodName, ClassEntry ownerType, TypeEntry valueType, TypeEntry[] paramTypes, DebugInfoProvider.DebugLocalInfo[] paramInfos, DebugInfoProvider.DebugLocalInfo thisParam) {
        super(fileEntry, line, methodName, ownerType, valueType, debugMethodInfo.modifiers());
        this.paramTypes = paramTypes;
        this.paramInfos = paramInfos;
        this.thisParam = thisParam;
        this.symbolName = debugMethodInfo.symbolNameForMethod();
        this.flags = 0;
        if (debugMethodInfo.isDeoptTarget()) {
            this.setIsDeopt();
        }
        if (debugMethodInfo.isConstructor()) {
            this.setIsConstructor();
        }
        if (debugMethodInfo.isOverride()) {
            this.setIsOverride();
        }
        this.vtableOffset = debugMethodInfo.vtableOffset();
        int paramCount = paramInfos.length;
        if (paramCount > 0) {
            DebugInfoProvider.DebugLocalInfo lastParam = paramInfos[paramCount - 1];
            this.firstLocalSlot = lastParam.slot() + lastParam.slotCount();
        } else {
            this.firstLocalSlot = thisParam == null ? 0 : thisParam.slotCount();
        }
        this.locals = new ArrayList();
        this.updateRangeInfo(debugInfoBase, debugMethodInfo);
    }

    public String methodName() {
        return this.memberName;
    }

    @Override
    public ClassEntry ownerType() {
        assert (this.ownerType instanceof ClassEntry);
        return (ClassEntry)this.ownerType;
    }

    public int getParamCount() {
        return this.paramInfos.length;
    }

    public TypeEntry getParamType(int idx) {
        assert (idx < this.paramInfos.length);
        return this.paramTypes[idx];
    }

    public TypeEntry[] getParamTypes() {
        return this.paramTypes;
    }

    public String getParamTypeName(int idx) {
        assert (idx < this.paramTypes.length);
        return this.paramTypes[idx].getTypeName();
    }

    public String getParamName(int idx) {
        assert (idx < this.paramInfos.length);
        return this.paramInfos[idx].name();
    }

    public int getParamLine(int idx) {
        assert (idx < this.paramInfos.length);
        return this.paramInfos[idx].line();
    }

    public DebugInfoProvider.DebugLocalInfo getParam(int i) {
        assert (i >= 0 && i < this.paramInfos.length) : "bad param index";
        return this.paramInfos[i];
    }

    public DebugInfoProvider.DebugLocalInfo getThisParam() {
        return this.thisParam;
    }

    public int getLocalCount() {
        return this.locals.size();
    }

    public DebugInfoProvider.DebugLocalInfo getLocal(int i) {
        assert (i >= 0 && i < this.locals.size()) : "bad param index";
        return this.locals.get(i);
    }

    private void setIsDeopt() {
        this.flags |= 1;
    }

    public boolean isDeopt() {
        return (this.flags & 1) != 0;
    }

    private void setIsInRange() {
        this.flags |= 2;
    }

    public boolean isInRange() {
        return (this.flags & 2) != 0;
    }

    private void setIsInlined() {
        this.flags |= 4;
    }

    public boolean isInlined() {
        return (this.flags & 4) != 0;
    }

    private void setIsOverride() {
        this.flags |= 8;
    }

    public boolean isOverride() {
        return (this.flags & 8) != 0;
    }

    private void setIsConstructor() {
        this.flags |= 0x10;
    }

    public boolean isConstructor() {
        return (this.flags & 0x10) != 0;
    }

    public void updateRangeInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugMethodInfo debugMethodInfo) {
        if (debugMethodInfo instanceof DebugInfoProvider.DebugLocationInfo) {
            DebugInfoProvider.DebugLocationInfo locationInfo = (DebugInfoProvider.DebugLocationInfo)debugMethodInfo;
            if (locationInfo.getCaller() != null) {
                this.setIsInlined();
            }
        } else if (debugMethodInfo instanceof DebugInfoProvider.DebugCodeInfo) {
            if (this.isInRange()) {
                assert (this.fileEntry == debugInfoBase.ensureFileEntry(debugMethodInfo));
            } else {
                this.setIsInRange();
                this.fileEntry = debugInfoBase.ensureFileEntry(debugMethodInfo);
            }
        }
    }

    public boolean isVirtual() {
        return this.vtableOffset >= 0;
    }

    public int getVtableOffset() {
        return this.vtableOffset;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public DebugInfoProvider.DebugLocalInfo recordLocal(DebugInfoProvider.DebugLocalValueInfo localValueInfo) {
        int slot = localValueInfo.slot();
        if (slot < 0) {
            return null;
        }
        if (slot < this.firstLocalSlot) {
            return this.matchParam(localValueInfo);
        }
        return this.matchLocal(localValueInfo);
    }

    private DebugInfoProvider.DebugLocalInfo matchParam(DebugInfoProvider.DebugLocalValueInfo localValueInfo) {
        if (this.thisParam != null && this.checkMatch(this.thisParam, localValueInfo)) {
            return this.thisParam;
        }
        for (int i = 0; i < this.paramInfos.length; ++i) {
            DebugInfoProvider.DebugLocalInfo paramInfo = this.paramInfos[i];
            if (!this.checkMatch(paramInfo, localValueInfo)) continue;
            return paramInfo;
        }
        return null;
    }

    private DebugInfoProvider.DebugLocalInfo matchLocal(DebugInfoProvider.DebugLocalValueInfo localValueInfo) {
        ListIterator<DebugInfoProvider.DebugLocalInfo> listIterator = this.locals.listIterator();
        while (listIterator.hasNext()) {
            DebugLocalInfoWrapper next = (DebugLocalInfoWrapper)listIterator.next();
            if (this.checkMatch(next, localValueInfo)) {
                int currentLine = next.line();
                int newLine = localValueInfo.line();
                if (currentLine < 0 && newLine >= 0 || newLine >= 0 && newLine < currentLine) {
                    next.setLine(newLine);
                }
                return next;
            }
            if (next.slot() <= localValueInfo.slot()) continue;
            listIterator.previous();
            break;
        }
        DebugLocalInfoWrapper newLocal = new DebugLocalInfoWrapper(localValueInfo);
        listIterator.add(newLocal);
        return newLocal;
    }

    boolean checkMatch(DebugInfoProvider.DebugLocalInfo local, DebugInfoProvider.DebugLocalValueInfo value) {
        boolean isMatch;
        boolean bl = isMatch = local.slot() == value.slot() && local.name().equals(value.name()) && local.typeName().equals(value.typeName());
        assert (!isMatch || MethodEntry.verifyMatch(local, value)) : "failed to verify matched var and value";
        return isMatch;
    }

    private static boolean verifyMatch(DebugInfoProvider.DebugLocalInfo local, DebugInfoProvider.DebugLocalValueInfo value) {
        if (local.slotCount() == value.slotCount()) {
            return true;
        }
        if (local.slotCount() == 0 || value.slotCount() == 0) {
            return true;
        }
        return local.javaKind() == JavaKind.Object && value.javaKind() == JavaKind.Long;
    }

    private static class DebugLocalInfoWrapper
    implements DebugInfoProvider.DebugLocalInfo {
        DebugInfoProvider.DebugLocalValueInfo value;
        int line;

        DebugLocalInfoWrapper(DebugInfoProvider.DebugLocalValueInfo value) {
            this.value = value;
            this.line = value.line();
        }

        @Override
        public ResolvedJavaType valueType() {
            return this.value.valueType();
        }

        @Override
        public String name() {
            return this.value.name();
        }

        @Override
        public String typeName() {
            return this.value.typeName();
        }

        @Override
        public int slot() {
            return this.value.slot();
        }

        @Override
        public int slotCount() {
            return this.value.slotCount();
        }

        @Override
        public JavaKind javaKind() {
            return this.value.javaKind();
        }

        @Override
        public int line() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }
    }
}

