/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import org.graalvm.compiler.debug.DebugContext;

public abstract class TypeEntry {
    protected final String typeName;
    private long classOffset;
    protected final int size;

    protected TypeEntry(String typeName, int size) {
        this.typeName = typeName;
        this.size = size;
        this.classOffset = -1L;
    }

    public long getClassOffset() {
        return this.classOffset;
    }

    public int getSize() {
        return this.size;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public abstract DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind();

    public boolean isPrimitive() {
        return this.typeKind() == DebugInfoProvider.DebugTypeInfo.DebugTypeKind.PRIMITIVE;
    }

    public boolean isHeader() {
        return this.typeKind() == DebugInfoProvider.DebugTypeInfo.DebugTypeKind.HEADER;
    }

    public boolean isArray() {
        return this.typeKind() == DebugInfoProvider.DebugTypeInfo.DebugTypeKind.ARRAY;
    }

    public boolean isInstance() {
        return this.typeKind() == DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INSTANCE;
    }

    public boolean isInterface() {
        return this.typeKind() == DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INTERFACE;
    }

    public boolean isEnum() {
        return this.typeKind() == DebugInfoProvider.DebugTypeInfo.DebugTypeKind.ENUM;
    }

    public boolean isClass() {
        return this.isInstance() | this.isInterface() || this.isEnum();
    }

    public boolean isStructure() {
        return this.isClass() || this.isHeader();
    }

    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        this.classOffset = debugTypeInfo.classOffset();
    }
}

