/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.pecoff.PECoff;
import com.oracle.objectfile.pecoff.PECoffObjectFile;
import com.oracle.objectfile.pecoff.PECoffRelocTableStruct;
import com.oracle.objectfile.pecoff.PECoffSymtab;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;

public class PECoffRelocationTable
extends ObjectFile.Element {
    private final PECoffSymtab syms;
    private PECoffObjectFile owner;
    PECoffRelocTableStruct relocTabStruct;

    @Override
    public ElementImpl getImpl() {
        return this;
    }

    PECoffRelocationTable(PECoffObjectFile owner, String name, PECoffSymtab syms) {
        PECoffObjectFile pECoffObjectFile = owner;
        Objects.requireNonNull(pECoffObjectFile);
        super(name, 4);
        this.owner = null;
        this.relocTabStruct = null;
        this.owner = owner;
        this.syms = syms;
    }

    void addEntry(PECoffObjectFile.PECoffSection s, long offset, PECoffRelocationMethod t, PECoffSymtab.Entry sym, long addend) {
        TreeMap entries = (TreeMap)s.getRelocEntries();
        if (entries == null) {
            entries = new TreeMap(Comparator.comparingLong(Entry::getOffset));
            s.setRelocEntries(entries);
        }
        entries.computeIfAbsent(new Entry(s, offset, t, sym, addend), Function.identity());
    }

    public int getRelocCount(int sectionIndex) {
        int entryCount = 0;
        PECoffObjectFile.PECoffSection s = this.getOwner().getSectionByIndex(sectionIndex + 1);
        Map entries = (Map)s.getRelocEntries();
        if (entries == null) {
            return 0;
        }
        entryCount = entries.size();
        if (entryCount > 65535) {
            ++entryCount;
        }
        return entryCount;
    }

    public int getRelocOffset(int sectionIndex) {
        int offset = 0;
        int maxSection = this.getOwner().getPECoffSections().size();
        for (int i = 0; i < maxSection; ++i) {
            if (i == sectionIndex) {
                return offset;
            }
            offset += this.getRelocCount(i) * PECoff.IMAGE_RELOCATION.totalsize;
        }
        return offset;
    }

    @Override
    public PECoffObjectFile getOwner() {
        return this.owner;
    }

    @Override
    public boolean isLoadable() {
        return true;
    }

    private PECoffRelocTableStruct getNativeReloctab() {
        if (this.relocTabStruct != null) {
            return this.relocTabStruct;
        }
        this.relocTabStruct = new PECoffRelocTableStruct(this.getOwner().getSections().size());
        for (PECoffObjectFile.PECoffSection s : this.getOwner().getPECoffSections()) {
            Map entries = (Map)s.getRelocEntries();
            if (entries == null) continue;
            for (Entry ent : entries.keySet()) {
                long offset = ent.getOffset();
                int sectionID = ent.section == null ? 0 : s.getSectionID();
                this.relocTabStruct.createRelocationEntry(sectionID, (int)offset, this.syms.indexOf(ent.sym), (int)ent.t.toLong());
            }
        }
        return this.relocTabStruct;
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
        return deps;
    }

    private int getWrittenSize() {
        int size = 0;
        for (PECoffObjectFile.PECoffSection s : this.getOwner().getPECoffSections()) {
            Map entries = (Map)s.getRelocEntries();
            if (entries == null) continue;
            int esize = entries.size();
            if (esize > 65535) {
                ++esize;
            }
            size += (esize *= PECoff.IMAGE_RELOCATION.totalsize);
        }
        return size;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        PECoffRelocTableStruct rt = this.getNativeReloctab();
        AssemblyBuffer oa = AssemblyBuffer.createOutputAssembler(ByteBuffer.allocate(this.getWrittenSize()).order(this.getOwner().getByteOrder()));
        int sectionIndex = 0;
        for (PECoffObjectFile.PECoffSection s : this.getOwner().getPECoffSections()) {
            if (s.getSectionID() != sectionIndex) {
                System.out.println("Out of order PECoffSection " + s.getSectionID() + " should be " + sectionIndex);
                System.out.println(s);
            }
            ++sectionIndex;
            if (s.getRelocEntries() == null) continue;
            oa.writeBlob(rt.getRelocData(s.getSectionID()));
        }
        return oa.getBlob();
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this, offsetHint);
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.getWrittenSize();
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return ObjectFile.defaultDecisions(this, copyingIn);
    }

    static final class Entry
    implements ObjectFile.RelocationRecord {
        final PECoffObjectFile.PECoffSection section;
        final long offset;
        final PECoffRelocationMethod t;
        final PECoffSymtab.Entry sym;
        final long addend;

        Entry(PECoffObjectFile.PECoffSection section, long offset, PECoffRelocationMethod t, PECoffSymtab.Entry sym, long addend) {
            this.section = section;
            this.offset = offset;
            this.t = t;
            this.sym = sym;
            this.addend = addend;
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        @Override
        public ObjectFile.Symbol getReferencedSymbol() {
            return this.sym;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                Entry other = (Entry)obj;
                return Objects.equals(this.section, other.section) && this.offset == other.offset && Objects.equals(this.t, other.t) && Objects.equals(this.sym, other.sym) && this.addend == other.addend;
            }
            return false;
        }

        public int hashCode() {
            return (((this.section.hashCode() * 31 + Long.hashCode(this.offset)) * 31 + this.t.hashCode()) * 31 + this.sym.hashCode()) * 31 + Long.hashCode(this.addend);
        }
    }

    static interface PECoffRelocationMethod
    extends ObjectFile.RelocationMethod {
        public long toLong();
    }
}

