/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.ObjectFile;
import java.util.ArrayList;
import java.util.List;

public final class LayoutDecision
implements Comparable<LayoutDecision> {
    private final Kind kind;
    private final ObjectFile.Element element;
    private final List<LayoutDecision> dependsOn = new ArrayList<LayoutDecision>();
    private final List<LayoutDecision> dependedOnBy = new ArrayList<LayoutDecision>();
    private Object value;

    LayoutDecision(Kind kind, ObjectFile.Element element, Object value) {
        this.kind = kind;
        this.element = element;
        assert (!(value instanceof LayoutDecision));
        this.value = value;
    }

    public String toString() {
        return "LayoutDecision(" + this.element + ", " + this.kind + ", " + this.value + ")";
    }

    List<LayoutDecision> dependedOnBy() {
        return this.dependedOnBy;
    }

    List<LayoutDecision> dependsOn() {
        return this.dependsOn;
    }

    Kind getKind() {
        return this.kind;
    }

    void setValue(Object value) {
        assert (this.value == null);
        assert (value instanceof Integer || value instanceof byte[]);
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isTaken() {
        return this.value != null;
    }

    public ObjectFile.Element getElement() {
        return this.element;
    }

    @Override
    public int compareTo(LayoutDecision arg) {
        ObjectFile.Element ourElement = this.getElement();
        int ourElementIndex = ourElement == null ? -1 : ourElement.getOwner().getElements().indexOf(ourElement);
        int ourKindOrdinal = this.getKind().ordinal();
        ObjectFile.Element argElement = arg.getElement();
        int argElementIndex = argElement == null ? -1 : argElement.getOwner().getElements().indexOf(argElement);
        int argKindOrdinal = arg.getKind().ordinal();
        if (ourElement != null && argElement != null && ourElement.getOwner() != argElement.getOwner()) {
            throw new IllegalArgumentException("Cannot compare decisions across object files");
        }
        if (ourElementIndex < argElementIndex) {
            return -1;
        }
        if (ourElementIndex > argElementIndex) {
            return 1;
        }
        if (ourKindOrdinal < argKindOrdinal) {
            return -1;
        }
        if (ourKindOrdinal > argKindOrdinal) {
            return 1;
        }
        return 0;
    }

    public static enum Kind {
        OFFSET,
        SIZE,
        CONTENT,
        IDENTITY,
        VADDR;

    }
}

