/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.common.JVMCIError;

public class ArrayElementsTypeFlow
extends TypeFlow<AnalysisType> {
    private AnalysisObject object;

    public ArrayElementsTypeFlow(AnalysisObject sourceObject) {
        super(sourceObject.type(), sourceObject.type().getComponentType());
        this.object = sourceObject;
    }

    public AnalysisObject getSourceObject() {
        return this.object;
    }

    @Override
    public TypeFlow<AnalysisType> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        throw JVMCIError.shouldNotReachHere((String)"The mixed elements flow should not be cloned. Use Load/StoreFlows.");
    }

    @Override
    public TypeState filter(BigBang bb, TypeState update) {
        if (this.declaredType.equals(bb.getObjectType())) {
            return update;
        }
        return TypeState.forIntersection(bb, update, this.declaredType.getTypeFlow(bb, true).getState());
    }

    public AnalysisObject object() {
        return this.object;
    }

    @Override
    public String toString() {
        return "MixedElementsFlow<" + ((AnalysisType)this.source).getName() + "\n" + this.getState() + ">";
    }
}

