/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import org.graalvm.compiler.serviceprovider.GraalServices;

public class Timer {
    private String prefix;
    private final String name;
    private final boolean autoPrint;
    private long startTime;
    private long totalTime;

    public Timer(String name) {
        this(null, name, true);
    }

    public Timer(String prefix, String name) {
        this(prefix, name, true);
    }

    public Timer(String name, boolean autoPrint) {
        this(null, name, autoPrint);
    }

    public Timer(String prefix, String name, boolean autoPrint) {
        this.prefix = prefix;
        this.name = name;
        this.autoPrint = autoPrint;
    }

    public void setPrefix(String value) {
        this.prefix = value;
    }

    public StopTimer start() {
        this.startTime = System.nanoTime();
        return new StopTimer();
    }

    public void stop() {
        long addTime = System.nanoTime() - this.startTime;
        this.totalTime += addTime;
        if (this.autoPrint) {
            this.print(addTime);
        }
    }

    private void print(long time) {
        String concurrentPrefix;
        if (this.prefix != null) {
            String pid = GraalServices.getExecutionID();
            concurrentPrefix = String.format("[%s:%s] ", this.prefix, pid);
        } else {
            concurrentPrefix = "";
        }
        double heap = (double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0 / 1024.0;
        System.out.format("%s%12s: %,10.2f ms, %,5.2f GB%n", concurrentPrefix, this.name, (double)time / 1000000.0, heap);
    }

    public void print() {
        this.print(this.totalTime);
    }

    public class StopTimer
    implements AutoCloseable {
        @Override
        public void close() {
            Timer.this.stop();
        }
    }
}

