/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.word.WordBase;

public abstract class ObjectScanner {
    protected final BigBang bb;
    private final ReusableSet scannedObjects;
    protected final Deque<WorklistEntry> worklist;
    private final AtomicLong workInProgressCount = new AtomicLong(0L);

    public ObjectScanner(BigBang bigbang, ReusableSet scannedObjects) {
        this.bb = bigbang;
        this.worklist = new ConcurrentLinkedDeque<WorklistEntry>();
        this.scannedObjects = scannedObjects;
    }

    public void scanBootImageHeapRoots(CompletionExecutor executor) {
        this.scanBootImageHeapRoots(executor, null, null);
    }

    public void scanBootImageHeapRoots(Comparator<AnalysisField> fieldComparator, Comparator<AnalysisMethod> methodComparator) {
        this.scanBootImageHeapRoots(null, fieldComparator, methodComparator);
    }

    private void scanBootImageHeapRoots(CompletionExecutor exec, Comparator<AnalysisField> fieldComparator, Comparator<AnalysisMethod> methodComparator) {
        Object fieldsList;
        Object fields = this.bb.getUniverse().getFields();
        if (fieldComparator != null) {
            fieldsList = new ArrayList<AnalysisField>((Collection<AnalysisField>)fields);
            ((ArrayList)fieldsList).sort(fieldComparator);
            fields = fieldsList;
        }
        fieldsList = fields.iterator();
        while (fieldsList.hasNext()) {
            final AnalysisField field = (AnalysisField)fieldsList.next();
            if (!Modifier.isStatic(field.getModifiers()) || field.getJavaKind() != JavaKind.Object || !field.isAccessed()) continue;
            if (exec != null) {
                this.workInProgressCount.incrementAndGet();
                exec.execute(new CompletionExecutor.DebugContextRunnable(){

                    @Override
                    public void run(DebugContext debug) {
                        try {
                            ObjectScanner.this.scanRootField(field);
                        }
                        finally {
                            ObjectScanner.this.workInProgressCount.decrementAndGet();
                        }
                    }
                });
                continue;
            }
            this.scanRootField(field);
        }
        Collection<AnalysisMethod> methods = this.bb.getUniverse().getMethods();
        if (methodComparator != null) {
            ArrayList<AnalysisMethod> methodsList = new ArrayList<AnalysisMethod>(methods);
            methodsList.sort(methodComparator);
            methods = methodsList;
        }
        for (final AnalysisMethod method : methods) {
            if (exec != null) {
                this.workInProgressCount.incrementAndGet();
                exec.execute(new CompletionExecutor.DebugContextRunnable(){

                    @Override
                    public void run(DebugContext debug) {
                        try {
                            ObjectScanner.this.scanMethod(method);
                        }
                        finally {
                            ObjectScanner.this.workInProgressCount.decrementAndGet();
                        }
                    }
                });
                continue;
            }
            this.scanMethod(method);
        }
        this.finish(exec);
    }

    public abstract void forRelocatedPointerFieldValue(JavaConstant var1, AnalysisField var2, JavaConstant var3);

    public abstract void forNullFieldValue(JavaConstant var1, AnalysisField var2);

    public abstract void forNonNullFieldValue(JavaConstant var1, AnalysisField var2, JavaConstant var3);

    protected final void scanRootField(AnalysisField field) {
        this.scanField(field, null, null);
    }

    protected final void scanField(AnalysisField field, JavaConstant receiver, WorklistEntry previous) {
        FieldScan reason = new FieldScan(field);
        try {
            JavaConstant fieldValue = this.bb.getConstantReflectionProvider().readFieldValue((ResolvedJavaField)field, receiver);
            if (fieldValue == null) {
                StringBuilder backtrace = new StringBuilder();
                this.buildObjectBacktrace(reason, previous, backtrace);
                throw AnalysisError.shouldNotReachHere("Could not find field " + field.format("%H.%n") + (receiver == null ? "" : " on " + this.bb.getSnippetReflectionProvider().asObject(Object.class, receiver).getClass()) + System.lineSeparator() + backtrace);
            }
            if (fieldValue.getJavaKind() == JavaKind.Object && this.bb.getHostVM().isRelocatedPointer(this.bb.getSnippetReflectionProvider().asObject(Object.class, fieldValue))) {
                this.forRelocatedPointerFieldValue(receiver, field, fieldValue);
            } else if (fieldValue.isNull()) {
                this.forNullFieldValue(receiver, field);
            } else if (fieldValue.getJavaKind() == JavaKind.Object) {
                if (receiver == null) {
                    this.registerRoot(fieldValue, field);
                } else {
                    this.propagateRoot(receiver, fieldValue);
                }
                this.scanConstant(fieldValue, reason, previous);
                this.forNonNullFieldValue(receiver, field, fieldValue);
            }
        }
        catch (UnsupportedFeatureException ex) {
            this.unsupportedFeature(field.format("%H.%n"), ex.getMessage(), reason, previous);
        }
    }

    private void registerRoot(JavaConstant fieldValue, AnalysisField field) {
        this.bb.addRoot(fieldValue, field);
    }

    private void propagateRoot(JavaConstant receiver, JavaConstant value) {
        Object receiverRoot = this.bb.getRoot(receiver);
        if (receiverRoot != null) {
            this.bb.addRoot(value, receiverRoot);
        }
    }

    public abstract void forNullArrayElement(JavaConstant var1, AnalysisType var2, int var3);

    public abstract void forNonNullArrayElement(JavaConstant var1, AnalysisType var2, JavaConstant var3, AnalysisType var4, int var5);

    protected final void scanArray(JavaConstant array, WorklistEntry previous) {
        Object valueObj = this.bb.getSnippetReflectionProvider().asObject(Object.class, array);
        ResolvedJavaType arrayType = this.bb.getMetaAccess().lookupJavaType((Class)valueObj.getClass());
        assert (valueObj instanceof Object[]);
        ArrayScan reason = new ArrayScan((AnalysisType)arrayType);
        Object[] arrayObject = (Object[])valueObj;
        for (int idx = 0; idx < arrayObject.length; ++idx) {
            Object e = arrayObject[idx];
            try {
                if (e == null) {
                    this.forNullArrayElement(array, (AnalysisType)arrayType, idx);
                    continue;
                }
                Object element = this.bb.getUniverse().replaceObject(e);
                JavaConstant elementConstant = this.bb.getSnippetReflectionProvider().forObject(element);
                ResolvedJavaType elementType = this.bb.getMetaAccess().lookupJavaType((Class)element.getClass());
                this.propagateRoot(array, elementConstant);
                this.scanConstant(elementConstant, reason, previous);
                this.forNonNullArrayElement(array, (AnalysisType)arrayType, elementConstant, (AnalysisType)elementType, idx);
                continue;
            }
            catch (UnsupportedFeatureException ex) {
                this.unsupportedFeature(arrayType.toJavaName(true), ex.getMessage(), reason, previous);
            }
        }
    }

    protected abstract void forScannedConstant(JavaConstant var1, ScanReason var2);

    public final void scanConstant(JavaConstant value, ScanReason reason) {
        this.scanConstant(value, reason, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scanConstant(JavaConstant value, ScanReason reason, WorklistEntry previous) {
        Object valueObj = this.bb.getSnippetReflectionProvider().asObject(Object.class, value);
        if (valueObj == null || valueObj instanceof WordBase) {
            return;
        }
        if (this.scannedObjects.putAndAcquire(valueObj) == null) {
            try {
                this.forScannedConstant(value, reason);
            }
            finally {
                this.scannedObjects.release(valueObj);
                this.workInProgressCount.incrementAndGet();
                this.worklist.push(new WorklistEntry(previous, value, reason));
            }
        }
    }

    private void unsupportedFeature(String key, String message, ScanReason reason, WorklistEntry entry) {
        StringBuilder objectBacktrace = new StringBuilder();
        AnalysisMethod method = this.buildObjectBacktrace(reason, entry, objectBacktrace);
        this.bb.getUnsupportedFeatures().addMessage(key, method, message, objectBacktrace.toString());
    }

    private AnalysisMethod buildObjectBacktrace(ScanReason reason, WorklistEntry entry, StringBuilder objectBacktrace) {
        WorklistEntry cur = entry;
        objectBacktrace.append("Object was reached by ").append(System.lineSeparator());
        objectBacktrace.append('\t').append(this.asString(reason));
        ScanReason rootReason = null;
        while (cur != null) {
            objectBacktrace.append(System.lineSeparator());
            objectBacktrace.append("\t\t").append("constant ").append(this.asString(cur.constant)).append(" reached by ").append(System.lineSeparator());
            objectBacktrace.append('\t').append(this.asString(cur.reason));
            rootReason = cur.reason;
            cur = cur.previous;
        }
        if (rootReason instanceof MethodScan) {
            return ((MethodScan)rootReason).method;
        }
        return null;
    }

    String asString(ScanReason reason) {
        if (reason instanceof FieldScan) {
            FieldScan fieldScan = (FieldScan)reason;
            if (fieldScan.field.isStatic()) {
                return "reading field " + reason;
            }
            return "reading field " + reason + " of";
        }
        if (reason instanceof MethodScan) {
            return "scanning method " + reason;
        }
        if (reason instanceof ArrayScan) {
            return "indexing into array";
        }
        return reason.toString();
    }

    private String asString(JavaConstant constant) {
        Object obj = this.bb.getSnippetReflectionProvider().asObject(Object.class, constant);
        return obj.getClass().getTypeName() + '@' + Integer.toHexString(obj.hashCode());
    }

    private void doScan(WorklistEntry entry) {
        Object valueObj = this.bb.getSnippetReflectionProvider().asObject(Object.class, entry.constant);
        assert (this.checkCorrectClassloaders(entry, valueObj)) : "Invalid classloader " + valueObj.getClass().getClassLoader() + " for " + valueObj + ".\nThis error happens when objects from previous image compilations are reached in the current compilation. To prevent this issue reset all static state from the bootclasspath and application classpath that points to the application objects. For reference, see com.oracle.svm.truffle.TruffleFeature.cleanup().";
        try {
            ResolvedJavaType type = this.bb.getMetaAccess().lookupJavaType((Class)valueObj.getClass());
            if (type.isInstanceClass()) {
                for (AnalysisField field : type.getInstanceFields(true)) {
                    if (field.getJavaKind() != JavaKind.Object || !field.isAccessed()) continue;
                    assert (!Modifier.isStatic(field.getModifiers()));
                    this.scanField(field, entry.constant, entry);
                }
            } else if (type.isArray() && this.bb.getProviders().getWordTypes().asKind((JavaType)type.getComponentType()) == JavaKind.Object) {
                this.scanArray(entry.constant, entry);
            }
        }
        catch (UnsupportedFeatureException ex) {
            this.unsupportedFeature("", ex.getMessage(), entry.reason, entry.previous);
        }
    }

    private void scanMethod(AnalysisMethod method) {
        try {
            EconomicMap<JavaConstant, BytecodePosition> objectConstants = method.getTypeFlow().getObjectConstants();
            if (objectConstants != null) {
                MapCursor cursor = objectConstants.getEntries();
                while (cursor.advance()) {
                    this.scanConstant((JavaConstant)cursor.getKey(), new MethodScan(method, (BytecodePosition)cursor.getValue()));
                }
            }
        }
        catch (UnsupportedFeatureException ex) {
            this.bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, ex.getMessage(), null, ex);
        }
    }

    private boolean checkCorrectClassloaders(WorklistEntry entry, Object valueObj) {
        boolean result = this.bb.isValidClassLoader(valueObj);
        if (!result) {
            System.err.println("detected an object that originates from previous compilations: " + valueObj.toString());
            ScanReason reason = entry.getReason();
            while (reason instanceof WorklistEntry) {
                Object value = this.bb.getSnippetReflectionProvider().asObject(Object.class, ((WorklistEntry)((Object)reason)).constant);
                System.err.println("  referenced from " + value.toString());
                reason = ((WorklistEntry)((Object)reason)).getReason();
            }
            System.err.println("  referenced from " + reason);
        }
        return result;
    }

    protected void finish(final CompletionExecutor exec) {
        if (exec != null) {
            exec.execute(new CompletionExecutor.DebugContextRunnable(){

                @Override
                public void run(DebugContext ignored) {
                    if (ObjectScanner.this.workInProgressCount.get() > 0L) {
                        int worklistLength = ObjectScanner.this.worklist.size();
                        while (!ObjectScanner.this.worklist.isEmpty()) {
                            int bucketSize = Integer.max(1, Integer.max(worklistLength, ObjectScanner.this.worklist.size()) / (2 * exec.getExecutorService().getPoolSize()));
                            final ArrayList<WorklistEntry> items = new ArrayList<WorklistEntry>();
                            while (!ObjectScanner.this.worklist.isEmpty() && items.size() < bucketSize) {
                                items.add(ObjectScanner.this.worklist.remove());
                            }
                            exec.execute(new CompletionExecutor.DebugContextRunnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run(DebugContext ignored2) {
                                    Iterator it = items.iterator();
                                    try {
                                        while (it.hasNext()) {
                                            try {
                                                ObjectScanner.this.doScan((WorklistEntry)it.next());
                                            }
                                            finally {
                                                ObjectScanner.this.workInProgressCount.decrementAndGet();
                                            }
                                        }
                                    }
                                    finally {
                                        while (it.hasNext()) {
                                            ObjectScanner.this.worklist.push((WorklistEntry)it.next());
                                        }
                                    }
                                }
                            });
                        }
                        exec.execute(this);
                    }
                }
            });
        } else {
            while (!this.worklist.isEmpty()) {
                int size = this.worklist.size();
                for (int i = 0; i < size; ++i) {
                    this.doScan(this.worklist.remove());
                }
            }
        }
    }

    public static final class ReusableSet {
        private final IdentityHashMap<Object, AtomicInteger> store = new IdentityHashMap(65536);
        private int sequence = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object putAndAcquire(Object object) {
            IdentityHashMap<Object, AtomicInteger> map = this.store;
            AtomicInteger i = map.get(object);
            int seq = this.sequence;
            int inflightSequence = seq - 1;
            while (true) {
                if (i != null) {
                    int current = i.get();
                    if (current == seq) {
                        return object;
                    }
                    if (current != inflightSequence && i.compareAndSet(current, inflightSequence)) {
                        return null;
                    }
                    while (i.get() != seq) {
                        Thread.yield();
                    }
                    return object;
                }
                AtomicInteger newSequence = new AtomicInteger(inflightSequence);
                IdentityHashMap<Object, AtomicInteger> identityHashMap = map;
                synchronized (identityHashMap) {
                    i = map.putIfAbsent(object, newSequence);
                    if (i == null) {
                        return null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Object o) {
            IdentityHashMap<Object, AtomicInteger> map = this.store;
            AtomicInteger i = map.get(o);
            if (i == null) {
                IdentityHashMap<Object, AtomicInteger> identityHashMap = map;
                synchronized (identityHashMap) {
                    i = map.get(o);
                }
            }
            i.set(this.sequence);
        }

        public void reset() {
            this.sequence += 2;
        }
    }

    protected static class MethodScan
    implements ScanReason {
        final AnalysisMethod method;
        final BytecodePosition sourcePosition;

        MethodScan(AnalysisMethod method, BytecodePosition nodeSourcePosition) {
            this.method = method;
            this.sourcePosition = nodeSourcePosition;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }

        public String toString() {
            return this.sourcePosition == null ? this.method.format("%H.%n(%p)") : this.method.asStackTraceElement(this.sourcePosition.getBCI()).toString();
        }
    }

    static class ArrayScan
    implements ScanReason {
        final AnalysisType arrayType;

        ArrayScan(AnalysisType arrayType) {
            this.arrayType = arrayType;
        }

        public String toString() {
            return this.arrayType.toJavaName(true);
        }
    }

    protected static class FieldScan
    implements ScanReason {
        final AnalysisField field;

        FieldScan(AnalysisField field) {
            this.field = field;
        }

        public AnalysisField getField() {
            return this.field;
        }

        public String toString() {
            return this.field.format("%H.%n");
        }
    }

    static class OtherReason
    implements ScanReason {
        final String reason;

        OtherReason(String reason) {
            this.reason = reason;
        }

        public String toString() {
            return this.reason;
        }
    }

    public static interface ScanReason {
        public static final OtherReason HUB = new OtherReason("Hub");
    }

    static class WorklistEntry {
        private final WorklistEntry previous;
        private final JavaConstant constant;
        private final ScanReason reason;

        WorklistEntry(WorklistEntry previous, JavaConstant constant, ScanReason reason) {
            this.previous = previous;
            this.constant = constant;
            this.reason = reason;
        }

        public WorklistEntry getPrevious() {
            return this.previous;
        }

        public JavaConstant getConstant() {
            return this.constant;
        }

        public ScanReason getReason() {
            return this.reason;
        }
    }
}

