/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaKind;

public class FieldTypeFlow
extends TypeFlow<AnalysisField> {
    private AnalysisObject object;

    private static TypeState initialFieldState(AnalysisField field) {
        if (field.getJavaKind() == JavaKind.Object && field.canBeNull()) {
            return TypeState.forNull();
        }
        return TypeState.forEmpty();
    }

    public FieldTypeFlow(AnalysisField field, AnalysisType type) {
        super(field, type, FieldTypeFlow.initialFieldState(field));
    }

    public FieldTypeFlow(AnalysisField field, AnalysisType type, AnalysisObject object) {
        this(field, type);
        this.object = object;
    }

    public AnalysisObject object() {
        return this.object;
    }

    @Override
    public TypeFlow<AnalysisField> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        throw JVMCIError.shouldNotReachHere((String)"The field flow should not be cloned. Use Load/StoreFieldTypeFlow.");
    }

    @Override
    public boolean canSaturate() {
        return false;
    }

    @Override
    protected void onInputSaturated(BigBang bb, TypeFlow<?> input) {
        this.getDeclaredType().getTypeFlow(bb, true).addUse(bb, this);
    }

    @Override
    public String toString() {
        return "FieldFlow<" + ((AnalysisField)this.source).format("%h.%n") + "\n" + this.getState() + ">";
    }
}

