/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.UnsafePartitionKind;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.UnsafeWriteSinkTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.nodes.AnalysisUnsafePartitionStoreNode;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndSwapNode;

public abstract class OffsetStoreTypeFlow
extends TypeFlow<BytecodePosition> {
    private final AnalysisType objectType;
    private final TypeFlow<?> valueFlow;
    protected TypeFlow<?> objectFlow;

    public OffsetStoreTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
        super(node.getNodeSourcePosition(), componentType);
        this.objectType = objectType;
        this.valueFlow = valueFlow;
        this.objectFlow = objectFlow;
    }

    public OffsetStoreTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, OffsetStoreTypeFlow original) {
        super(original, methodFlows);
        this.objectType = original.objectType;
        this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
        this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
    }

    @Override
    public TypeFlow<?> receiver() {
        return this.objectFlow;
    }

    public TypeState getObjectState() {
        return this.objectFlow.getState();
    }

    @Override
    public abstract TypeFlow<BytecodePosition> copy(BigBang var1, MethodFlowsGraph var2);

    @Override
    public abstract boolean addState(BigBang var1, TypeState var2);

    @Override
    public void setObserved(TypeFlow<?> newObjectFlow) {
        this.objectFlow = newObjectFlow;
    }

    @Override
    public abstract void onObservedUpdate(BigBang var1);

    @Override
    public void onObservedSaturated(BigBang bb, TypeFlow<?> observed) {
        assert (this.isClone());
        this.replaceObservedWith(bb, this.objectType);
    }

    public static class JavaWriteTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        public JavaWriteTypeFlow(JavaWriteNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super((ValueNode)node, objectType, componentType, objectFlow, valueFlow);
        }

        public JavaWriteTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, JavaWriteTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public JavaWriteTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new JavaWriteTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "JavaWriteTypeFlow<" + this.getState() + ">";
        }
    }

    public static class UnsafePartitionStoreTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        protected final UnsafePartitionKind partitionKind;
        protected final AnalysisType partitionType;

        public UnsafePartitionStoreTypeFlow(AnalysisUnsafePartitionStoreNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow, UnsafePartitionKind partitionKind, AnalysisType partitionType) {
            super((ValueNode)node, objectType, componentType, objectFlow, valueFlow);
            this.partitionKind = partitionKind;
            this.partitionType = partitionType;
        }

        public UnsafePartitionStoreTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, UnsafePartitionStoreTypeFlow original) {
            super(bb, methodFlows, original);
            this.partitionKind = original.partitionKind;
            this.partitionType = original.partitionType;
        }

        @Override
        public UnsafePartitionStoreTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new UnsafePartitionStoreTypeFlow(bb, methodFlows, this);
        }

        @Override
        public boolean addState(BigBang bb, TypeState add) {
            assert (this.isClone());
            if (add.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (BytecodePosition)this.source, "Illegal: Store UnknownTypeState via unsafe. Store: " + this.source);
                return false;
            }
            return super.addState(bb, add, true);
        }

        @Override
        public TypeState filter(BigBang bb, TypeState update) {
            if (this.partitionType.equals(bb.getObjectType())) {
                return update;
            }
            return TypeState.forIntersection(bb, update, this.partitionType.getTypeFlow(bb, true).getState());
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            if (objectState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (BytecodePosition)this.source, "Illegal: Unsafe store into UnknownTypeState objects. Store: " + this.source);
                return;
            }
            for (AnalysisObject object : objectState.objects()) {
                AnalysisType objectType = object.type();
                assert (!objectType.isArray());
                this.handleUnsafeAccessedFields(bb, objectType.unsafeAccessedFields(this.partitionKind), object);
            }
        }

        @Override
        public String toString() {
            return "UnsafePartitionStoreTypeFlow<" + this.getState() + "> : " + this.partitionKind;
        }
    }

    public static class AtomicWriteTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        public AtomicWriteTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super(node, objectType, componentType, objectFlow, valueFlow);
        }

        public AtomicWriteTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, AtomicWriteTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public AtomicWriteTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new AtomicWriteTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "AtomicWriteTypeFlow<" + this.getState() + ">";
        }
    }

    public static class CompareAndSwapTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        public CompareAndSwapTypeFlow(UnsafeCompareAndSwapNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super((ValueNode)node, objectType, componentType, objectFlow, valueFlow);
        }

        public CompareAndSwapTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, CompareAndSwapTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public CompareAndSwapTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new CompareAndSwapTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "CompareAndSwapTypeFlow<" + this.getState() + ">";
        }
    }

    public static class UnsafeStoreTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        public UnsafeStoreTypeFlow(RawStoreNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super((ValueNode)node, objectType, componentType, objectFlow, valueFlow);
        }

        public UnsafeStoreTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, UnsafeStoreTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public UnsafeStoreTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new UnsafeStoreTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "UnsafeStoreTypeFlow<" + this.getState() + ">";
        }
    }

    public static abstract class AbstractUnsafeStoreTypeFlow
    extends OffsetStoreTypeFlow {
        AbstractUnsafeStoreTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super(node, objectType, componentType, objectFlow, valueFlow);
        }

        AbstractUnsafeStoreTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, OffsetStoreTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public final AbstractUnsafeStoreTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            AbstractUnsafeStoreTypeFlow copy = this.makeCopy(bb, methodFlows);
            bb.registerUnsafeStore(copy);
            return copy;
        }

        protected abstract AbstractUnsafeStoreTypeFlow makeCopy(BigBang var1, MethodFlowsGraph var2);

        @Override
        public boolean addState(BigBang bb, TypeState add) {
            assert (this.isClone());
            if (add.isUnknown()) {
                bb.getUnsupportedFeatures().addMessage(this.graphRef.getMethod().format("%H.%n(%p)"), this.graphRef.getMethod(), "Illegal: Store UnknownTypeState via unsafe. Store: " + this.getSource());
                return false;
            }
            return super.addState(bb, add, true);
        }

        void handleUnsafeAccessedFields(BigBang bb, List<AnalysisField> unsafeAccessedFields, AnalysisObject object) {
            for (AnalysisField field : unsafeAccessedFields) {
                if (field.hasUnsafeFrozenTypeState()) {
                    UnsafeWriteSinkTypeFlow unsafeWriteSink = object.getUnsafeWriteSinkFrozenFilterFlow(bb, this.method(), field);
                    this.addUse(bb, unsafeWriteSink);
                    continue;
                }
                FieldFilterTypeFlow fieldFilterFlow = object.getInstanceFieldFilterFlow(bb, this.method(), field);
                this.addUse(bb, fieldFilterFlow);
            }
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            if (objectState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (BytecodePosition)this.source, "Illegal: Unsafe store into UnknownTypeState objects. Store: " + this);
                return;
            }
            for (AnalysisObject object : objectState.objects()) {
                AnalysisType objectType = object.type();
                if (objectType.isArray()) {
                    if (object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                    ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, true);
                    this.addUse(bb, elementsFlow);
                    continue;
                }
                this.handleUnsafeAccessedFields(bb, objectType.unsafeAccessedFields(), object);
            }
        }
    }

    public static class StoreIndexedTypeFlow
    extends OffsetStoreTypeFlow {
        public StoreIndexedTypeFlow(ValueNode node, AnalysisType arrayType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super(node, arrayType, arrayType.getComponentType(), objectFlow, valueFlow);
        }

        public StoreIndexedTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, StoreIndexedTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public StoreIndexedTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new StoreIndexedTypeFlow(bb, methodFlows, this);
        }

        @Override
        public boolean addState(BigBang bb, TypeState add) {
            assert (this.isClone());
            if (add.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (BytecodePosition)this.source, "Illegal: Index storing UnknownTypeState into object array. Store: " + this.source);
                return false;
            }
            return super.addState(bb, add, true);
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            if (objectState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (BytecodePosition)this.source, "Illegal: Index storing into UnknownTypeState objects. Store: " + this);
                return;
            }
            for (AnalysisObject object : objectState.objects()) {
                if (bb.analysisPolicy().relaxTypeFlowConstraints() && !object.type().isArray() || object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, true);
                this.addUse(bb, elementsFlow);
            }
        }

        @Override
        public String toString() {
            return "StoreIndexedTypeFlow<" + this.getState() + ">";
        }
    }
}

