/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.function.Consumer;
import jdk.vm.ci.common.JVMCIError;

public class ReportUtils {
    static final String CONNECTING_INDENT = "\u2502   ";
    static final String EMPTY_INDENT = "    ";
    static final String CHILD = "\u251c\u2500\u2500 ";
    static final String LAST_CHILD = "\u2514\u2500\u2500 ";
    static final Comparator<AnalysisMethod> methodComparator = Comparator.comparing(m -> m.format("%H.%n(%p)"));
    static final Comparator<AnalysisField> fieldComparator = (f1, f2) -> f1.format("%H.%n").compareTo(f2.format("%H.%n"));
    static final Comparator<InvokeTypeFlow> invokeComparator = Comparator.comparing(i -> i.getTargetMethod().format("%H.%n(%p)"));

    public static void report(String description, String path, String name, String extension, Consumer<PrintWriter> reporter) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        String timeStamp = LocalDateTime.now().format(formatter);
        Path reportDir = Paths.get(path, new String[0]);
        String fileName = name + "_" + timeStamp + "." + extension;
        ReportUtils.reportImpl(description, reportDir, fileName, reporter);
    }

    public static void report(String description, Path file, Consumer<PrintWriter> reporter) {
        Path folder = file.getParent();
        Path fileName = file.getFileName();
        if (folder == null || fileName == null) {
            throw new IllegalArgumentException("File parameter must be a file, got: " + file);
        }
        ReportUtils.reportImpl(description, folder, fileName.toString(), reporter);
    }

    private static void reportImpl(String description, Path folder, String fileName, Consumer<PrintWriter> reporter) {
        try {
            Path reportDir = Files.createDirectories(folder, new FileAttribute[0]);
            Path file = reportDir.resolve(fileName);
            Files.deleteIfExists(file);
            try (FileWriter fw = new FileWriter(Files.createFile(file, new FileAttribute[0]).toFile());
                 PrintWriter writer = new PrintWriter(fw);){
                System.out.println("Printing " + description + " to " + file.toAbsolutePath());
                reporter.accept(writer);
            }
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public static String extractImageName(String imageName) {
        return imageName.substring(imageName.lastIndexOf(File.separatorChar) + 1);
    }
}

