/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;

public final class StatisticsPrinter {
    private final BigBang bigbang;

    public static void print(BigBang bigbang, String path, String reportName) {
        StatisticsPrinter printer = new StatisticsPrinter(bigbang);
        ReportUtils.report("analysis results stats", path + File.separatorChar + "reports", "analysis_stats_" + reportName, "txt", writer -> printer.printStats((PrintWriter)writer));
    }

    public StatisticsPrinter(BigBang bigbang) {
        this.bigbang = bigbang;
    }

    private void printStats(PrintWriter out) {
        out.println("Analysis Results Statistics");
        int[] reachableTypes = StatisticsPrinter.getNumReachableTypes(this.bigbang);
        int[] reachableMethods = StatisticsPrinter.getNumReachableMethods(this.bigbang);
        long[] typeChecksStats = StatisticsPrinter.getTypeCheckStats(this.bigbang);
        out.format("Total reachable types          %8s %n", reachableTypes[0]);
        out.format("App reachable types            %8s %n", reachableTypes[1]);
        out.format("Total reachable methods        %8s %n", reachableMethods[0]);
        out.format("App reachable methods          %8s %n", reachableMethods[1]);
        out.format("Total type checks              %8s %n", typeChecksStats[0]);
        out.format("Total removable type checks    %8s %n", typeChecksStats[1]);
        out.format("App type checks                %8s %n", typeChecksStats[2]);
        out.format("App removable type checks      %8s %n", typeChecksStats[3]);
        out.println();
    }

    private static int[] getNumReachableTypes(BigBang bb) {
        int reachable = 0;
        int appReachable = 0;
        for (AnalysisType type : bb.getUniverse().getTypes()) {
            if (!type.isInstantiated()) continue;
            ++reachable;
            if (StatisticsPrinter.isRuntimeLibraryType(type)) continue;
            ++appReachable;
        }
        return new int[]{reachable, appReachable};
    }

    private static int[] getNumReachableMethods(BigBang bb) {
        int reachable = 0;
        int appReachable = 0;
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            if (!method.isImplementationInvoked()) continue;
            ++reachable;
            if (StatisticsPrinter.isRuntimeLibraryType(method.getDeclaringClass())) continue;
            ++appReachable;
        }
        return new int[]{reachable, appReachable};
    }

    private static long[] getTypeCheckStats(BigBang bb) {
        long totalFilters = 0L;
        long totalRemovableFilters = 0L;
        long appTotalFilters = 0L;
        long appTotalRemovableFilters = 0L;
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            boolean runtimeMethod = StatisticsPrinter.isRuntimeLibraryType(method.getDeclaringClass());
            MethodTypeFlow methodFlow = method.getTypeFlow();
            MethodFlowsGraph originalFlows = methodFlow.getOriginalMethodFlows();
            for (Map.Entry<Object, InstanceOfTypeFlow> entry : originalFlows.getInstanceOfFlows()) {
                if (!BytecodeLocation.isValidBci(entry.getKey())) continue;
                ++totalFilters;
                InstanceOfTypeFlow originalInstanceOf = entry.getValue();
                boolean isSaturated = methodFlow.isSaturated(bb, originalInstanceOf);
                TypeState instanceOfTypeState = methodFlow.foldTypeFlow(bb, originalInstanceOf);
                if (!isSaturated && instanceOfTypeState.typesCount() < 2) {
                    ++totalRemovableFilters;
                }
                if (runtimeMethod) continue;
                ++appTotalFilters;
                if (isSaturated || instanceOfTypeState.typesCount() >= 2) continue;
                ++appTotalRemovableFilters;
            }
        }
        return new long[]{totalFilters, totalRemovableFilters, appTotalFilters, appTotalRemovableFilters};
    }

    public static boolean isRuntimeLibraryType(AnalysisType type) {
        String name = type.getName();
        return name.startsWith("Ljava/") || name.startsWith("Ljavax/") || name.startsWith("Lsun/") || name.startsWith("Lcom/sun/") || name.startsWith("Lcom/oracle/") || name.startsWith("Lorg/graalvm/") || name.startsWith("Ljdk/");
    }
}

