/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnalysisObjectScanner
extends ObjectScanner {
    public AnalysisObjectScanner(BigBang bigbang, ObjectScanner.ReusableSet scannedObjects) {
        super(bigbang, scannedObjects);
    }

    @Override
    public void forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
        if (!field.isWritten()) {
            field.registerAsWritten(null);
        }
    }

    @Override
    public void forNullFieldValue(JavaConstant receiver, AnalysisField field) {
        FieldTypeFlow fieldTypeFlow = this.getFieldTypeFlow(field, receiver);
        if (!fieldTypeFlow.getState().canBeNull()) {
            fieldTypeFlow.addState(this.bb, TypeState.forNull());
        }
    }

    @Override
    public void forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
        ResolvedJavaType fieldType = this.bb.getMetaAccess().lookupJavaType((Class)this.bb.getSnippetReflectionProvider().asObject(Object.class, fieldValue).getClass());
        assert (fieldType.isInstantiated()) : fieldType;
        if (this.bb.getAllInstantiatedTypeFlow().getState().containsType((AnalysisType)fieldType)) {
            FieldTypeFlow fieldTypeFlow = this.getFieldTypeFlow(field, receiver);
            AnalysisObject constantObject = this.bb.analysisPolicy().createConstantObject(this.bb, fieldValue, (AnalysisType)fieldType);
            if (!fieldTypeFlow.getState().isUnknown() && !fieldTypeFlow.getState().containsObject(constantObject)) {
                TypeState constantTypeState = TypeState.forNonNullObject(this.bb, constantObject);
                fieldTypeFlow.addState(this.bb, constantTypeState);
            }
        }
    }

    private FieldTypeFlow getFieldTypeFlow(AnalysisField field, JavaConstant receiver) {
        if (field.isStatic()) {
            return field.getStaticFieldFlow();
        }
        ResolvedJavaType receiverType = this.bb.getMetaAccess().lookupJavaType((Class)this.bb.getSnippetReflectionProvider().asObject(Object.class, receiver).getClass());
        AnalysisObject constantReceiverObj = this.bb.analysisPolicy().createConstantObject(this.bb, receiver, (AnalysisType)receiverType);
        return constantReceiverObj.getInstanceFieldFlow(this.bb, field, true);
    }

    @Override
    public void forNullArrayElement(JavaConstant array, AnalysisType arrayType, int elementIndex) {
        ArrayElementsTypeFlow arrayObjElementsFlow = this.getArrayElementsFlow(array, arrayType);
        if (!arrayObjElementsFlow.getState().canBeNull()) {
            arrayObjElementsFlow.addState(this.bb, TypeState.forNull());
        }
    }

    @Override
    public void forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int elementIndex) {
        if (this.bb.getAllInstantiatedTypeFlow().getState().containsType(elementType)) {
            ArrayElementsTypeFlow arrayObjElementsFlow = this.getArrayElementsFlow(array, arrayType);
            AnalysisObject constantObject = this.bb.analysisPolicy().createConstantObject(this.bb, elementConstant, elementType);
            if (!arrayObjElementsFlow.getState().isUnknown() && !arrayObjElementsFlow.getState().containsObject(constantObject)) {
                TypeState elementTypeState = TypeState.forNonNullObject(this.bb, constantObject);
                arrayObjElementsFlow.addState(this.bb, elementTypeState);
            }
        }
    }

    private ArrayElementsTypeFlow getArrayElementsFlow(JavaConstant array, AnalysisType arrayType) {
        AnalysisObject arrayObjConstant = this.bb.analysisPolicy().createConstantObject(this.bb, array, arrayType);
        return arrayObjConstant.getArrayElementsFlow(this.bb, true);
    }

    @Override
    protected void forScannedConstant(JavaConstant value, ObjectScanner.ScanReason reason) {
        Object valueObj = this.bb.getSnippetReflectionProvider().asObject(Object.class, value);
        ResolvedJavaType type = this.bb.getMetaAccess().lookupJavaType((Class)valueObj.getClass());
        type.registerAsInHeap();
    }
}

