/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.nodes.UnsafePartitionLoadNode;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.UnsafePartitionKind;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;

public abstract class OffsetLoadTypeFlow
extends TypeFlow<BytecodePosition> {
    private final AnalysisType objectType;
    protected TypeFlow<?> objectFlow;

    public OffsetLoadTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, MethodTypeFlow methodFlow) {
        super(node.getNodeSourcePosition(), componentType);
        this.objectType = objectType;
        this.objectFlow = objectFlow;
    }

    public OffsetLoadTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, OffsetLoadTypeFlow original) {
        super(original, methodFlows);
        this.objectType = original.objectType;
        this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
    }

    @Override
    public boolean addState(BigBang bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }

    @Override
    public void setObserved(TypeFlow<?> newObjectFlow) {
        this.objectFlow = newObjectFlow;
    }

    @Override
    public abstract void onObservedUpdate(BigBang var1);

    @Override
    public void onObservedSaturated(BigBang bb, TypeFlow<?> observed) {
        assert (this.isClone());
        this.replaceObservedWith(bb, this.objectType);
    }

    @Override
    public TypeFlow<?> receiver() {
        return this.objectFlow;
    }

    public TypeState getObjectState() {
        return this.objectFlow.getState();
    }

    public static class JavaReadTypeFlow
    extends AbstractUnsafeLoadTypeFlow {
        public JavaReadTypeFlow(JavaReadNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> arrayFlow, MethodTypeFlow methodFlow) {
            super((ValueNode)node, objectType, componentType, arrayFlow, methodFlow);
        }

        public JavaReadTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, JavaReadTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public JavaReadTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new JavaReadTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "JavaReadTypeFlow<" + this.getState() + ">";
        }
    }

    public static class AtomicReadTypeFlow
    extends AbstractUnsafeLoadTypeFlow {
        public AtomicReadTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, MethodTypeFlow methodFlow) {
            super(node, objectType, componentType, objectFlow, methodFlow);
        }

        public AtomicReadTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, AtomicReadTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public AtomicReadTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new AtomicReadTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "AtomicReadTypeFlow<" + this.getState() + ">";
        }
    }

    public static class UnsafePartitionLoadTypeFlow
    extends AbstractUnsafeLoadTypeFlow {
        protected final UnsafePartitionKind partitionKind;
        protected final AnalysisType partitionType;

        public UnsafePartitionLoadTypeFlow(UnsafePartitionLoadNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> arrayFlow, MethodTypeFlow methodFlow, UnsafePartitionKind partitionKind, AnalysisType partitionType) {
            super((ValueNode)node, objectType, componentType, arrayFlow, methodFlow);
            this.partitionKind = partitionKind;
            this.partitionType = partitionType;
        }

        private UnsafePartitionLoadTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, UnsafePartitionLoadTypeFlow original) {
            super(bb, methodFlows, original);
            this.partitionKind = original.partitionKind;
            this.partitionType = original.partitionType;
        }

        @Override
        public UnsafePartitionLoadTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new UnsafePartitionLoadTypeFlow(bb, methodFlows, this);
        }

        @Override
        public TypeState filter(BigBang bb, TypeState update) {
            if (this.partitionType.equals(bb.getObjectType())) {
                return update;
            }
            return TypeState.forIntersection(bb, update, this.partitionType.getTypeFlow(bb, true).getState());
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState objectState = this.getObjectState();
            if (objectState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (BytecodePosition)this.source, "Illegal: Unsafe loading from UnknownTypeState. Load: " + this.source);
                return;
            }
            for (AnalysisObject object : objectState.objects()) {
                AnalysisType objectType = object.type();
                assert (!objectType.isArray());
                for (AnalysisField field : objectType.unsafeAccessedFields(this.partitionKind)) {
                    FieldTypeFlow fieldFlow = object.getInstanceFieldFlow(bb, this.method(), field, false);
                    if (fieldFlow.getState().isUnknown()) {
                        bb.getUnsupportedFeatures().addMessage(this.graphRef.getMethod().format("%H.%n(%p)"), this.graphRef.getMethod(), "Illegal: Unsafe loading UnknownTypeState from object. Load: " + this.getSource());
                        return;
                    }
                    fieldFlow.addUse(bb, this);
                }
            }
        }

        @Override
        public String toString() {
            return "UnsafePartitionLoadTypeFlow<" + this.getState() + "> : " + this.partitionKind;
        }
    }

    public static class UnsafeLoadTypeFlow
    extends AbstractUnsafeLoadTypeFlow {
        public UnsafeLoadTypeFlow(RawLoadNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> arrayFlow, MethodTypeFlow methodFlow) {
            super((ValueNode)node, objectType, componentType, arrayFlow, methodFlow);
        }

        private UnsafeLoadTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, UnsafeLoadTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public UnsafeLoadTypeFlow makeCopy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new UnsafeLoadTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "UnsafeLoadTypeFlow<" + this.getState() + ">";
        }
    }

    public static abstract class AbstractUnsafeLoadTypeFlow
    extends OffsetLoadTypeFlow {
        AbstractUnsafeLoadTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, MethodTypeFlow methodFlow) {
            super(node, objectType, componentType, objectFlow, methodFlow);
        }

        AbstractUnsafeLoadTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, AbstractUnsafeLoadTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public final AbstractUnsafeLoadTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            AbstractUnsafeLoadTypeFlow copy = this.makeCopy(bb, methodFlows);
            bb.registerUnsafeLoad(copy);
            return copy;
        }

        protected abstract AbstractUnsafeLoadTypeFlow makeCopy(BigBang var1, MethodFlowsGraph var2);

        @Override
        public void initClone(BigBang bb) {
            for (AnalysisField field : bb.getUniverse().getUnsafeAccessedStaticFields()) {
                field.getStaticFieldFlow().addUse(bb, this);
            }
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState objectState = this.getObjectState();
            if (objectState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (BytecodePosition)this.source, "Illegal: Unsafe loading from UnknownTypeState. Load: " + this.source);
                return;
            }
            for (AnalysisObject object : objectState.objects()) {
                AnalysisType objectType = object.type();
                if (objectType.isArray()) {
                    if (object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                    ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, false);
                    if (elementsFlow.getState().equals(TypeState.forUnknown())) {
                        bb.getUnsupportedFeatures().addMessage(this.graphRef.getMethod().format("%H.%n(%p)"), this.graphRef.getMethod(), "Illegal: Unsafe loading UnknownTypeState from object. Load:" + this.getSource());
                        return;
                    }
                    elementsFlow.addUse(bb, this);
                    continue;
                }
                for (AnalysisField field : objectType.unsafeAccessedFields()) {
                    assert (field != null);
                    FieldTypeFlow fieldFlow = object.getInstanceFieldFlow(bb, this.method(), field, false);
                    if (fieldFlow.getState().isUnknown()) {
                        bb.getUnsupportedFeatures().addMessage(this.graphRef.getMethod().format("%H.%n(%p)"), this.graphRef.getMethod(), "Illegal: Unsafe loading UnknownTypeState from object. Load: " + this.getSource());
                        return;
                    }
                    fieldFlow.addUse(bb, this);
                }
            }
        }
    }

    public static class LoadIndexedTypeFlow
    extends OffsetLoadTypeFlow {
        public LoadIndexedTypeFlow(ValueNode node, AnalysisType arrayType, TypeFlow<?> arrayFlow, MethodTypeFlow methodFlow) {
            super(node, arrayType, arrayType.getComponentType(), arrayFlow, methodFlow);
        }

        public LoadIndexedTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, LoadIndexedTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public LoadIndexedTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new LoadIndexedTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState arrayState = this.getObjectState();
            if (arrayState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (BytecodePosition)this.source, "Illegal: Index loading from UnknownTypeState. Load: " + this.source);
                return;
            }
            for (AnalysisObject object : arrayState.objects()) {
                if (bb.analysisPolicy().relaxTypeFlowConstraints() && !object.type().isArray() || object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, false);
                if (elementsFlow.getState().isUnknown()) {
                    bb.getUnsupportedFeatures().addMessage(this.graphRef.getMethod().format("%H.%n(%p)"), this.graphRef.getMethod(), "Illegal: Index loading UnknownTypeState from array. Store: " + this.getSource());
                    return;
                }
                elementsFlow.addUse(bb, this);
            }
        }

        @Override
        public String toString() {
            return "LoadIndexedTypeFlow<" + this.getState() + ">";
        }
    }
}

