/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.FieldSinkTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.util.GuardedAnnotationAccess;

public class AnalysisField
implements ResolvedJavaField,
OriginalFieldProvider {
    private final int id;
    public final ResolvedJavaField wrapped;
    private FieldTypeFlow staticFieldFlow;
    private FieldTypeFlow initialInstanceFieldFlow;
    private FieldSinkTypeFlow instanceFieldFlow;
    private boolean isAccessed;
    private boolean isRead;
    private boolean isWritten;
    private boolean isUsedInComparison;
    private AtomicBoolean isUnsafeAccessed;
    private AtomicBoolean unsafeFrozenTypeState;
    private boolean canBeNull;
    private ConcurrentMap<MethodTypeFlow, Boolean> readBy;
    private ConcurrentMap<MethodTypeFlow, Boolean> writtenBy;
    protected TypeState instanceFieldTypeState;
    private int position;
    private final AnalysisType declaringClass;
    private final AnalysisType fieldType;

    public AnalysisField(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        assert (!wrappedField.isInternal());
        this.position = -1;
        this.isUnsafeAccessed = new AtomicBoolean();
        this.unsafeFrozenTypeState = new AtomicBoolean();
        this.wrapped = wrappedField;
        this.id = universe.nextFieldId.getAndIncrement();
        this.readBy = (Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options()) != false ? new ConcurrentHashMap() : null;
        this.writtenBy = new ConcurrentHashMap<MethodTypeFlow, Boolean>();
        this.declaringClass = universe.lookup((JavaType)wrappedField.getDeclaringClass());
        this.fieldType = AnalysisField.getDeclaredType(universe, wrappedField);
        this.isUsedInComparison = false;
        if (this.isStatic()) {
            this.canBeNull = false;
            this.staticFieldFlow = new FieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = null;
        } else {
            this.canBeNull = true;
            this.instanceFieldFlow = new FieldSinkTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = new FieldTypeFlow(this, this.getType());
        }
    }

    private static AnalysisType getDeclaredType(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        ResolvedJavaType resolvedType;
        try {
            resolvedType = wrappedField.getType().resolve(universe.substitutions.resolve(wrappedField.getDeclaringClass()));
        }
        catch (LinkageError e) {
            return universe.objectType();
        }
        return universe.lookup((JavaType)resolvedType);
    }

    public void copyAccessInfos(AnalysisField other) {
        this.isAccessed = other.isAccessed;
        this.isUnsafeAccessed = other.isUnsafeAccessed;
        this.canBeNull = other.canBeNull;
        this.isWritten = other.isWritten;
        this.isRead = other.isRead;
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public JavaKind getStorageKind() {
        return this.fieldType.getStorageKind();
    }

    public TypeState getTypeState() {
        if (this.getType().getStorageKind() != JavaKind.Object) {
            return null;
        }
        if (this.isStatic()) {
            return this.staticFieldFlow.getState();
        }
        return this.getInstanceFieldTypeState();
    }

    public TypeState getInstanceFieldTypeState() {
        return this.instanceFieldFlow.getState();
    }

    public FieldTypeFlow getInitialInstanceFieldFlow() {
        return this.initialInstanceFieldFlow;
    }

    public FieldTypeFlow getStaticFieldFlow() {
        assert (Modifier.isStatic(this.getModifiers()));
        return this.staticFieldFlow;
    }

    public FieldSinkTypeFlow getInstanceFieldFlow() {
        assert (!Modifier.isStatic(this.getModifiers()));
        return this.instanceFieldFlow;
    }

    public void cleanupAfterAnalysis() {
        this.staticFieldFlow = null;
        this.instanceFieldFlow = null;
        this.initialInstanceFieldFlow = null;
        this.readBy = null;
        this.writtenBy = null;
        this.instanceFieldTypeState = null;
    }

    public void registerAsAccessed() {
        this.isAccessed = true;
    }

    public void registerAsRead(MethodTypeFlow method) {
        this.isRead = true;
        if (this.readBy != null && method != null) {
            this.readBy.put(method, Boolean.TRUE);
        }
    }

    public void registerAsWritten(MethodTypeFlow method) {
        this.isWritten = true;
        if (this.writtenBy != null && method != null) {
            this.writtenBy.put(method, Boolean.TRUE);
        }
    }

    public void registerAsUnsafeAccessed(AnalysisUniverse universe) {
        this.registerAsUnsafeAccessed(universe, DefaultUnsafePartition.get());
    }

    public void registerAsUnsafeAccessed(AnalysisUniverse universe, UnsafePartitionKind partitionKind) {
        if (!this.isUnsafeAccessed.getAndSet(true)) {
            this.registerAsWritten(null);
            if (this.isStatic()) {
                universe.registerUnsafeAccessedStaticField(this);
            } else {
                AnalysisType declaringType = this.getDeclaringClass();
                declaringType.registerUnsafeAccessedField(this, partitionKind);
            }
        }
    }

    public boolean isUnsafeAccessed() {
        return this.isUnsafeAccessed.get();
    }

    public void setUnsafeFrozenTypeState(boolean value) {
        this.unsafeFrozenTypeState.getAndSet(value);
    }

    public boolean hasUnsafeFrozenTypeState() {
        return this.unsafeFrozenTypeState.get();
    }

    public Set<MethodTypeFlow> getReadBy() {
        return this.readBy.keySet();
    }

    public Set<MethodTypeFlow> getWrittenBy() {
        return this.writtenBy.keySet();
    }

    public boolean isAccessed() {
        return this.isAccessed || this.isRead || this.isWritten && (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object);
    }

    public boolean isInImageHeap() {
        return this.isAccessed || this.isRead;
    }

    public boolean isWritten() {
        return this.isAccessed || this.isWritten;
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public void setPosition(int newPosition) {
        assert (this.position == -1 || this.position == newPosition);
        this.position = newPosition;
    }

    public int getPosition() {
        assert (this.position != -1) : this;
        return this.position;
    }

    public AnalysisType getType() {
        return this.fieldType;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        throw GraalError.shouldNotReachHere();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public Annotation[] getAnnotations() {
        return GuardedAnnotationAccess.getAnnotations((AnnotatedElement)this.wrapped);
    }

    public Annotation[] getDeclaredAnnotations() {
        return GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)this.wrapped);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)this.wrapped, annotationClass);
    }

    public String toString() {
        return "AnalysisField<" + this.format("%h.%n") + " accessed: " + this.isAccessed + " reads: " + this.isRead + " written: " + this.isWritten + ">";
    }

    public void markAsUsedInComparison() {
        this.isUsedInComparison = true;
    }

    public boolean isUsedInComparison() {
        return this.isUsedInComparison;
    }

    @Override
    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField(this.getDeclaringClass().universe.getOriginalSnippetReflection(), this.wrapped);
    }
}

