/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.function.Consumer;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class ReportUtils {
    static final String CONNECTING_INDENT = "\u2502   ";
    static final String EMPTY_INDENT = "    ";
    static final String CHILD = "\u251c\u2500\u2500 ";
    static final String LAST_CHILD = "\u2514\u2500\u2500 ";
    public static final Comparator<ResolvedJavaMethod> methodComparator = Comparator.comparing(m -> m.format("%H.%n(%p)"));
    static final Comparator<AnalysisField> fieldComparator = Comparator.comparing(f -> f.format("%H.%n"));
    static final Comparator<InvokeTypeFlow> invokeComparator = Comparator.comparing(i -> i.getTargetMethod().format("%H.%n(%p)"));
    static final Comparator<BytecodePosition> positionMethodComparator = Comparator.comparing(pos -> pos.getMethod().format("%H.%n(%p)"));
    static final Comparator<BytecodePosition> positionComparator = positionMethodComparator.thenComparing(pos -> pos.getBCI());

    public static void report(String description, String path, String name, String extension, Consumer<PrintWriter> reporter) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        String timeStamp = LocalDateTime.now().format(formatter);
        Path reportDir = Paths.get(path, new String[0]);
        String fileName = name + "_" + timeStamp + "." + extension;
        ReportUtils.reportImpl(description, reportDir, fileName, reporter);
    }

    public static void report(String description, Path file, Consumer<PrintWriter> reporter) {
        Path folder = file.getParent();
        Path fileName = file.getFileName();
        if (folder == null || fileName == null) {
            throw new IllegalArgumentException("File parameter must be a file, got: " + file);
        }
        ReportUtils.reportImpl(description, folder, fileName.toString(), reporter);
    }

    private static void reportImpl(String description, Path folder, String fileName, Consumer<PrintWriter> reporter) {
        try {
            Path reportDir = Files.createDirectories(folder, new FileAttribute[0]);
            Path file = reportDir.resolve(fileName);
            Files.deleteIfExists(file);
            try (FileWriter fw = new FileWriter(Files.createFile(file, new FileAttribute[0]).toFile());
                 PrintWriter writer = new PrintWriter(fw);){
                System.out.println("# Printing " + description + " to: " + ReportUtils.getCWDRelativePath(file));
                reporter.accept(writer);
            }
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }

    public static Path getCWDRelativePath(Path path) {
        Path cwd = Paths.get("", new String[0]).toAbsolutePath();
        try {
            return cwd.relativize(path);
        }
        catch (IllegalArgumentException e) {
            return path;
        }
    }

    public static String extractImageName(String imageName) {
        return imageName.substring(imageName.lastIndexOf(File.separatorChar) + 1);
    }

    public static void report(String description, Path file, boolean append, Consumer<OutputStream> reporter) {
        Path folder = file.getParent();
        Path fileName = file.getFileName();
        if (folder == null || fileName == null) {
            throw new IllegalArgumentException("File parameter must be a file, got: " + file);
        }
        ReportUtils.reportImpl(description, folder, fileName.toString(), reporter, append);
    }

    private static void reportImpl(String description, Path folder, String fileName, Consumer<OutputStream> reporter, boolean append) {
        try {
            Path reportDir = Files.createDirectories(folder, new FileAttribute[0]);
            Path file = reportDir.resolve(fileName);
            try (OutputStream fos = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);){
                System.out.println("# Printing " + description + " to: " + ReportUtils.getCWDRelativePath(file));
                reporter.accept(fos);
                fos.flush();
            }
        }
        catch (IOException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
    }
}

