/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;

public class FilterTypeFlow
extends TypeFlow<BytecodePosition> {
    private final boolean isExact;
    private final boolean isAssignable;
    private final boolean includeNull;

    public FilterTypeFlow(ValueNode node, AnalysisType filterType, boolean isAssignable, boolean includeNull) {
        this(node, filterType, false, isAssignable, includeNull);
    }

    public FilterTypeFlow(ValueNode node, AnalysisType filterType, boolean isExact, boolean isAssignable, boolean includeNull) {
        super(node.getNodeSourcePosition(), filterType);
        this.isExact = isExact;
        this.isAssignable = isAssignable;
        this.includeNull = includeNull;
    }

    public FilterTypeFlow(MethodFlowsGraph methodFlows, FilterTypeFlow original) {
        super(original, methodFlows);
        this.isExact = original.isExact;
        this.isAssignable = original.isAssignable;
        this.includeNull = original.includeNull;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return new FilterTypeFlow(methodFlows, this);
    }

    @Override
    public TypeState filter(BigBang bb, TypeState update) {
        TypeState result = this.isExact ? (this.isAssignable ? TypeState.forIntersection(bb, update, TypeState.forExactType(bb, this.declaredType, this.includeNull)) : TypeState.forSubtraction(bb, update, TypeState.forExactType(bb, this.declaredType, !this.includeNull))) : (this.isAssignable ? TypeState.forIntersection(bb, update, this.declaredType.getTypeFlow(bb, this.includeNull).getState()) : TypeState.forSubtraction(bb, update, this.declaredType.getTypeFlow(bb, !this.includeNull).getState()));
        return result;
    }

    @Override
    protected void onInputSaturated(BigBang bb, TypeFlow<?> input) {
        if (this.isAssignable) {
            AllInstantiatedTypeFlow sourceFlow = this.declaredType.getTypeFlow(bb, this.includeNull);
            this.setSaturated();
            this.swapOut(bb, sourceFlow);
        } else {
            super.onInputSaturated(bb, input);
        }
    }

    @Override
    public boolean addState(BigBang bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }

    public boolean isExact() {
        return this.isExact;
    }

    public boolean isAssignable() {
        return this.isAssignable;
    }

    public boolean includeNull() {
        return this.includeNull;
    }

    @Override
    public String toString() {
        return "FilterTypeFlow<" + this.declaredType + ", isAssignable: " + this.isAssignable + ", includeNull: " + this.includeNull + ">";
    }
}

