/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AccessFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.typestate.TypeState;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;

public abstract class StoreFieldTypeFlow
extends AccessFieldTypeFlow {
    protected StoreFieldTypeFlow(StoreFieldNode node) {
        super((AccessFieldNode)node);
    }

    protected StoreFieldTypeFlow(StoreFieldTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
    }

    @Override
    public TypeState filter(BigBang bb, TypeState newState) {
        return this.declaredTypeFilter(bb, newState);
    }

    public static class StoreInstanceFieldTypeFlow
    extends StoreFieldTypeFlow {
        private final TypeFlow<?> valueFlow;
        private TypeFlow<?> objectFlow;

        StoreInstanceFieldTypeFlow(StoreFieldNode node, TypeFlow<?> valueFlow, TypeFlow<?> objectFlow) {
            super(node);
            this.valueFlow = valueFlow;
            this.objectFlow = objectFlow;
        }

        StoreInstanceFieldTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, StoreInstanceFieldTypeFlow original) {
            super(original, methodFlows);
            this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
            this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
        }

        public StoreInstanceFieldTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new StoreInstanceFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public TypeFlow<?> receiver() {
            return this.objectFlow;
        }

        @Override
        public void setObserved(TypeFlow<?> newObjectFlow) {
            this.objectFlow = newObjectFlow;
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            objectState = this.filterObjectState(bb, objectState);
            for (AnalysisObject receiver : objectState.objects()) {
                FieldTypeFlow fieldFlow = receiver.getInstanceFieldFlow(bb, this.method(), this.field, true);
                this.addUse(bb, fieldFlow);
            }
        }

        @Override
        public void onObservedSaturated(BigBang bb, TypeFlow<?> observed) {
            assert (this.isClone());
            this.replaceObservedWith(bb, this.field.getDeclaringClass());
        }

        @Override
        public String toString() {
            return "StoreInstanceFieldTypeFlow<" + this.getState() + ">";
        }
    }

    public static class StoreStaticFieldTypeFlow
    extends StoreFieldTypeFlow {
        private final FieldTypeFlow fieldFlow;
        private final TypeFlow<?> valueFlow;

        StoreStaticFieldTypeFlow(StoreFieldNode node, TypeFlow<?> valueFlow, FieldTypeFlow fieldFlow) {
            super(node);
            this.valueFlow = valueFlow;
            this.fieldFlow = fieldFlow;
        }

        StoreStaticFieldTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, StoreStaticFieldTypeFlow original) {
            super(original, methodFlows);
            this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
            this.fieldFlow = original.fieldFlow;
        }

        public StoreFieldTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new StoreStaticFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void initClone(BigBang bb) {
            this.addUse(bb, this.fieldFlow);
        }

        @Override
        public String toString() {
            return "StoreStaticFieldTypeFlow<" + this.getState() + ">";
        }
    }
}

