/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.FilterTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;

public abstract class TypeFlow<T> {
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> USE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "uses");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> INPUTS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "inputs");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> OBSERVERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "observers");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> OBSERVEES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "observees");
    protected static final AtomicInteger nextId = new AtomicInteger();
    protected final int id = nextId.incrementAndGet();
    protected final T source;
    protected final AnalysisType declaredType;
    private volatile TypeState state;
    private volatile Object uses;
    private volatile Object inputs;
    private volatile Object observers;
    private volatile Object observees;
    private int slot;
    private final boolean isClone;
    protected final MethodFlowsGraph graphRef;
    protected final AnalysisContext context;
    protected boolean usedAsAParameter;
    protected boolean usedAsAReceiver;
    public volatile boolean inQueue;
    private volatile boolean isSaturated;
    private static final AtomicReferenceFieldUpdater<TypeFlow, TypeState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, TypeState.class, "state");

    private TypeFlow(T source, AnalysisType declaredType, TypeState typeState, int slot, boolean isClone, MethodFlowsGraph graphRef) {
        this.source = source;
        this.declaredType = declaredType;
        this.slot = slot;
        this.isClone = isClone;
        this.graphRef = graphRef;
        this.context = graphRef != null ? graphRef.context() : null;
        this.state = typeState;
        this.usedAsAParameter = false;
        this.usedAsAReceiver = false;
        assert (!(source instanceof Node)) : "must not reference Graal node from TypeFlow: " + source;
    }

    public TypeFlow() {
        this(null, null, TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(TypeState typeState) {
        this(null, null, typeState, -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType) {
        this(source, declaredType, TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType, TypeState state) {
        this(source, declaredType, state, -1, false, null);
    }

    public TypeFlow(TypeFlow<T> original, MethodFlowsGraph graphRef) {
        this(original.getSource(), original.getDeclaredType(), TypeState.forEmpty(), original.getSlot(), true, graphRef);
        this.usedAsAParameter = original.usedAsAParameter;
        this.usedAsAReceiver = original.usedAsAReceiver;
        PointsToStats.registerTypeFlowRetainReason(this, original);
    }

    public TypeFlow<T> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return this;
    }

    public void initClone(BigBang bb) {
    }

    public void setUsedAsAParameter(boolean usedAsAParameter) {
        this.usedAsAParameter = usedAsAParameter;
    }

    public boolean isUsedAsAParameter() {
        return this.usedAsAParameter;
    }

    public void setUsedAsAReceiver(boolean usedAsAReceiver) {
        this.usedAsAReceiver = usedAsAReceiver;
    }

    public boolean isUsedAsAReceiver() {
        return this.usedAsAReceiver;
    }

    public TypeFlow<?> receiver() {
        return null;
    }

    public int id() {
        return this.id;
    }

    public AnalysisContext context() {
        return this.context;
    }

    public MethodFlowsGraph graphRef() {
        return this.graphRef;
    }

    public AnalysisMethod method() {
        return this.graphRef != null ? this.graphRef.getMethod() : null;
    }

    public T getSource() {
        return this.source;
    }

    public boolean isClone() {
        return this.isClone;
    }

    public AnalysisType getDeclaredType() {
        return this.declaredType;
    }

    public TypeState getState() {
        return this.state;
    }

    public boolean isAllInstantiated() {
        return this instanceof AllInstantiatedTypeFlow;
    }

    public boolean isCloseToAllInstantiated(BigBang bb) {
        return this.getState().closeToAllInstantiated(bb);
    }

    public void setState(BigBang bb, TypeState state) {
        assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || this instanceof InstanceOfTypeFlow || state.verifyDeclaredType(this.declaredType)) : "declaredType: " + this.declaredType.toJavaName(true) + " state: " + state;
        this.state = state;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isSaturated() {
        return this.isSaturated;
    }

    public boolean canSaturate() {
        return true;
    }

    public void setSaturated() {
        this.isSaturated = true;
    }

    public boolean addState(BigBang bb, TypeState add) {
        return this.addState(bb, add, true);
    }

    public boolean addState(BigBang bb, TypeState add, boolean postFlow) {
        TypeState after;
        TypeState before;
        PointsToStats.registerTypeFlowUpdate(bb, this, add);
        do {
            TypeState filteredAdd;
            if (!(after = TypeState.forUnion(bb, before = this.state, filteredAdd = this.filter(bb, add))).equals(before)) continue;
            return false;
        } while (!STATE_UPDATER.compareAndSet(this, before, after));
        PointsToStats.registerTypeFlowSuccessfulUpdate(bb, this, add);
        assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || this.checkTypeState(bb, before, after));
        if (this.checkSaturated(bb, after)) {
            this.onSaturated(bb);
        } else if (postFlow) {
            bb.postFlow(this);
        }
        return true;
    }

    private boolean checkTypeState(BigBang bb, TypeState before, TypeState after) {
        assert (((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue());
        if (this instanceof InstanceOfTypeFlow || this instanceof FilterTypeFlow) {
            return true;
        }
        assert (after.verifyDeclaredType(this.declaredType)) : String.format("The type state of %s contains types that are not assignable from its declared type %s. %nState before: %s. %nState after: %s", this.formatFlow(false), this.declaredType.toJavaName(true), TypeFlow.formatState(bb, before), TypeFlow.formatState(bb, after));
        return true;
    }

    private static String formatState(BigBang bb, TypeState typeState) {
        if (typeState.closeToAllInstantiated(bb)) {
            return "close to AllInstantiated";
        }
        return typeState.toString();
    }

    public boolean addOriginalUse(BigBang bb, TypeFlow<?> use) {
        return this.addUse(bb, use, false, false);
    }

    public boolean addUse(BigBang bb, TypeFlow<?> use) {
        return this.addUse(bb, use, true, false);
    }

    private boolean addUse(BigBang bb, TypeFlow<?> use, boolean propagateTypeState, boolean registerInput) {
        if (this.isSaturated() && propagateTypeState) {
            use.onInputSaturated(bb, this);
            return false;
        }
        if (this.doAddUse(bb, use, registerInput)) {
            if (propagateTypeState) {
                if (this.isSaturated()) {
                    use.onInputSaturated(bb, this);
                    this.removeUse(use);
                    return false;
                }
                use.addState(bb, this.getState());
            }
            return true;
        }
        return false;
    }

    protected boolean doAddUse(BigBang bb, TypeFlow<?> use, boolean registerInput) {
        if (use.isSaturated()) {
            return false;
        }
        if (use.equals(this)) {
            return false;
        }
        if (bb.trackTypeFlowInputs() || registerInput) {
            use.addInput(this);
        }
        return ConcurrentLightHashSet.addElement(this, USE_UPDATER, use);
    }

    public boolean removeUse(TypeFlow<?> use) {
        return ConcurrentLightHashSet.removeElement(this, USE_UPDATER, use);
    }

    public Collection<TypeFlow<?>> getUses() {
        return ConcurrentLightHashSet.getElements(this, USE_UPDATER);
    }

    public boolean addOriginalObserver(BigBang bb, TypeFlow<?> observer) {
        return this.addObserver(bb, observer, false, false);
    }

    public void addObserver(BigBang bb, TypeFlow<?> observer) {
        this.addObserver(bb, observer, true, false);
    }

    private boolean addObserver(final BigBang bb, final TypeFlow<?> observer, boolean triggerUpdate, boolean registerObservees) {
        if (this.isSaturated() && triggerUpdate) {
            observer.onObservedSaturated(bb, this);
            return false;
        }
        if (this.doAddObserver(bb, observer, registerObservees)) {
            if (triggerUpdate) {
                if (this.isSaturated()) {
                    observer.onObservedSaturated(bb, this);
                    this.removeObserver(observer);
                    return false;
                }
                if (!this.state.isEmpty()) {
                    bb.postTask(new CompletionExecutor.DebugContextRunnable(){

                        @Override
                        public void run(DebugContext ignore) {
                            observer.onObservedUpdate(bb);
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    private boolean doAddObserver(BigBang bb, TypeFlow<?> observer, boolean registerObservees) {
        if (observer.equals(this)) {
            return false;
        }
        if (bb.trackTypeFlowInputs() || registerObservees) {
            observer.addObservee(this);
        }
        return ConcurrentLightHashSet.addElement(this, OBSERVERS_UPDATER, observer);
    }

    public boolean removeObserver(TypeFlow<?> observer) {
        observer.removeObservee(this);
        return ConcurrentLightHashSet.removeElement(this, OBSERVERS_UPDATER, observer);
    }

    public Collection<TypeFlow<?>> getObservers() {
        return ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER);
    }

    protected void notifyObservers(BigBang bb) {
        for (TypeFlow<?> observer : this.getObservers()) {
            observer.onObservedUpdate(bb);
        }
    }

    public void addObservee(TypeFlow<?> observee) {
        ConcurrentLightHashSet.addElement(this, OBSERVEES_UPDATER, observee);
    }

    public Collection<TypeFlow<?>> getObservees() {
        return ConcurrentLightHashSet.getElements(this, OBSERVEES_UPDATER);
    }

    public boolean removeObservee(TypeFlow<?> observee) {
        return ConcurrentLightHashSet.removeElement(this, OBSERVEES_UPDATER, observee);
    }

    public void addInput(TypeFlow<?> input) {
        ConcurrentLightHashSet.addElement(this, INPUTS_UPDATER, input);
    }

    public Collection<TypeFlow<?>> getInputs() {
        return ConcurrentLightHashSet.getElements(this, INPUTS_UPDATER);
    }

    public boolean removeInput(TypeFlow<?> input) {
        return ConcurrentLightHashSet.removeElement(this, INPUTS_UPDATER, input);
    }

    public TypeState filter(BigBang bb, TypeState newState) {
        return newState;
    }

    public TypeState declaredTypeFilter(BigBang bb, TypeState newState) {
        if (!bb.analysisPolicy().relaxTypeFlowConstraints()) {
            return newState;
        }
        if (this.declaredType == null) {
            return newState;
        }
        if (this.declaredType.equals(bb.getObjectType())) {
            return newState;
        }
        return TypeState.forIntersection(bb, newState, this.declaredType.getTypeFlow(bb, true).getState());
    }

    public void update(BigBang bb) {
        TypeState curState = this.getState();
        for (TypeFlow<?> use : this.getUses()) {
            if (use.isSaturated()) {
                this.removeUse(use);
                continue;
            }
            use.addState(bb, curState);
        }
        this.notifyObservers(bb);
    }

    public void onObservedUpdate(BigBang bb) {
    }

    boolean checkSaturated(BigBang bb, TypeState typeState) {
        if (!bb.analysisPolicy().removeSaturatedTypeFlows()) {
            return false;
        }
        if (!this.canSaturate()) {
            return false;
        }
        return typeState.typesCount() > bb.analysisPolicy().typeFlowSaturationCutoff();
    }

    protected void onSaturated(BigBang bb) {
        assert (bb.analysisPolicy().removeSaturatedTypeFlows()) : "The type flow saturation optimization is disabled.";
        assert (this.canSaturate()) : "This type flow cannot saturate.";
        assert (bb.analysisPolicy().aliasArrayTypeFlows()) : "Array type flows must be aliased.";
        if (this.isSaturated()) {
            return;
        }
        this.setSaturated();
        this.notifySaturated(bb);
    }

    private void notifySaturated(BigBang bb) {
        for (TypeFlow<?> use : this.getUses()) {
            use.onInputSaturated(bb, this);
            this.removeUse(use);
        }
        for (TypeFlow<?> observer : this.getObservers()) {
            observer.onObservedSaturated(bb, this);
            this.removeObserver(observer);
        }
    }

    protected void swapOut(BigBang bb, TypeFlow<?> newFlow) {
        for (TypeFlow<?> use : this.getUses()) {
            this.removeUse(use);
            newFlow.addUse(bb, use);
        }
        for (TypeFlow<?> observer : this.getObservers()) {
            this.removeObserver(observer);
            observer.replacedObservedWith(bb, newFlow);
        }
    }

    protected void onInputSaturated(BigBang bb, TypeFlow<?> input) {
        assert (bb.analysisPolicy().removeSaturatedTypeFlows()) : "The type flow saturation optimization is disabled.";
        if (!this.canSaturate()) {
            return;
        }
        this.onSaturated(bb);
    }

    public void onObservedSaturated(BigBang bb, TypeFlow<?> observed) {
    }

    public void replaceObservedWith(BigBang bb, AnalysisType newObservedType) {
        this.replacedObservedWith(bb, newObservedType.getTypeFlow(bb, false));
    }

    public void replacedObservedWith(BigBang bb, TypeFlow<?> newObservedFlow) {
        this.setObserved(newObservedFlow);
        newObservedFlow.addObserver(bb, this);
    }

    protected void setObserved(TypeFlow<?> newObservedFlow) {
    }

    private String formatFlow(boolean withState) {
        return this.getClass().getName() + '<' + this.source + (withState ? ": " + this.getState() : "") + '>';
    }

    public String toString() {
        return this.formatFlow(true);
    }

    public final boolean equals(Object other) {
        return other == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }
}

