/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.util.GuardedAnnotationAccess;

public class AnalysisMethod
implements WrappedJavaMethod,
GraphProvider,
OriginalMethodProvider {
    private final AnalysisUniverse universe;
    public final ResolvedJavaMethod wrapped;
    private final int id;
    private final boolean hasNeverInlineDirective;
    private final ExceptionHandler[] exceptionHandlers;
    private final LocalVariableTable localVariableTable;
    private final String qualifiedName;
    private MethodTypeFlow typeFlow;
    private final AnalysisType declaringClass;
    private boolean isRootMethod;
    private boolean isIntrinsicMethod;
    private Object entryPointData;
    private boolean isInvoked;
    private boolean isImplementationInvoked;
    private boolean isInlined;
    private final AtomicReference<Object> parsedGraphCacheState = new AtomicReference<Object>(GRAPH_CACHE_UNPARSED);
    private static final Object GRAPH_CACHE_UNPARSED = "unparsed";
    private static final Object GRAPH_CACHE_CLEARED = "cleared by cleanupAfterAnalysis";
    private StructuredGraph analyzedGraph;
    protected AnalysisMethod[] implementations;
    private ConcurrentMap<InvokeTypeFlow, Object> invokedBy;
    private ConcurrentMap<InvokeTypeFlow, Object> implementationInvokedBy;
    private final AtomicReference<InvokeTypeFlow> contextInsensitiveInvoke = new AtomicReference();

    public AnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.id = universe.nextMethodId.getAndIncrement();
        this.declaringClass = universe.lookup((JavaType)wrapped.getDeclaringClass());
        this.hasNeverInlineDirective = universe.hostVM().hasNeverInlineDirective(wrapped);
        if (((Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options())).booleanValue()) {
            this.startTrackInvocations();
        }
        ExceptionHandler[] original = wrapped.getExceptionHandlers();
        this.exceptionHandlers = new ExceptionHandler[original.length];
        for (int i = 0; i < original.length; ++i) {
            ExceptionHandler h = original[i];
            JavaType catchType = this.getCatchType(h);
            this.exceptionHandlers[i] = new ExceptionHandler(h.getStartBCI(), h.getEndBCI(), h.getHandlerBCI(), h.catchTypeCPI(), catchType);
        }
        LocalVariableTable newLocalVariableTable = null;
        if (wrapped.getLocalVariableTable() != null) {
            try {
                Local[] origLocals = wrapped.getLocalVariableTable().getLocals();
                Local[] newLocals = new Local[origLocals.length];
                ResolvedJavaType accessingClass = this.getDeclaringClass().getWrapped();
                for (int i = 0; i < newLocals.length; ++i) {
                    Local origLocal = origLocals[i];
                    ResolvedJavaType origLocalType = origLocal.getType() instanceof ResolvedJavaType ? (ResolvedJavaType)origLocal.getType() : origLocal.getType().resolve(accessingClass);
                    AnalysisType type = universe.lookup((JavaType)origLocalType);
                    newLocals[i] = new Local(origLocal.getName(), (JavaType)type, origLocal.getStartBCI(), origLocal.getEndBCI(), origLocal.getSlot());
                }
                newLocalVariableTable = new LocalVariableTable(newLocals);
            }
            catch (UnsupportedFeatureException | LinkageError | BytecodeParser.BytecodeParserError e) {
                newLocalVariableTable = null;
            }
        }
        this.localVariableTable = newLocalVariableTable;
        this.typeFlow = new MethodTypeFlow(universe.hostVM().options(), this);
        this.qualifiedName = this.format("%H.%n(%P)");
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private JavaType getCatchType(ExceptionHandler handler) {
        ResolvedJavaType resolvedCatchType;
        JavaType catchType = handler.getCatchType();
        if (catchType == null) {
            return null;
        }
        try {
            resolvedCatchType = catchType.resolve(this.wrapped.getDeclaringClass());
        }
        catch (LinkageError e) {
            return catchType;
        }
        return this.universe.lookup((JavaType)resolvedCatchType);
    }

    public void cleanupAfterAnalysis() {
        this.typeFlow = null;
        this.invokedBy = null;
        this.implementationInvokedBy = null;
        this.contextInsensitiveInvoke.set(null);
        if (this.parsedGraphCacheState.get() instanceof AnalysisParsedGraph) {
            this.parsedGraphCacheState.set(GRAPH_CACHE_CLEARED);
        }
    }

    public void startTrackInvocations() {
        if (this.invokedBy == null) {
            this.invokedBy = new ConcurrentHashMap<InvokeTypeFlow, Object>();
        }
        if (this.implementationInvokedBy == null) {
            this.implementationInvokedBy = new ConcurrentHashMap<InvokeTypeFlow, Object>();
        }
    }

    public int getId() {
        return this.id;
    }

    public MethodTypeFlow getTypeFlow() {
        return this.typeFlow;
    }

    public void registerAsIntrinsicMethod() {
        this.isIntrinsicMethod = true;
    }

    public void registerAsEntryPoint(Object newEntryPointData) {
        assert (newEntryPointData != null);
        if (this.entryPointData != null && !this.entryPointData.equals(newEntryPointData)) {
            throw new UnsupportedFeatureException("Method is registered as entry point with conflicting entry point data: " + this.entryPointData + ", " + newEntryPointData);
        }
        this.entryPointData = newEntryPointData;
        this.startTrackInvocations();
    }

    public void registerAsInvoked(InvokeTypeFlow invoke) {
        this.isInvoked = true;
        if (this.invokedBy != null && invoke != null) {
            this.invokedBy.put(invoke, Boolean.TRUE);
        }
    }

    public void registerAsImplementationInvoked(InvokeTypeFlow invoke) {
        assert (!Modifier.isAbstract(this.getModifiers()));
        this.isImplementationInvoked = true;
        if (this.implementationInvokedBy != null && invoke != null) {
            this.implementationInvokedBy.put(invoke, Boolean.TRUE);
        }
        this.getDeclaringClass().registerAsReachable();
    }

    public void registerAsInlined() {
        this.isInlined = true;
    }

    public Set<AnalysisMethod> getCallers() {
        return this.getInvokeLocations().stream().map(location -> (AnalysisMethod)location.getMethod()).collect(Collectors.toSet());
    }

    public List<BytecodePosition> getInvokeLocations() {
        ArrayList<BytecodePosition> locations = new ArrayList<BytecodePosition>();
        for (InvokeTypeFlow invoke : this.implementationInvokedBy.keySet()) {
            if (InvokeTypeFlow.isContextInsensitiveVirtualInvoke(invoke)) {
                locations.addAll(((AbstractVirtualInvokeTypeFlow)invoke).getInvokeLocations());
                continue;
            }
            locations.add((BytecodePosition)invoke.getSource());
        }
        return locations;
    }

    public boolean isEntryPoint() {
        return this.entryPointData != null;
    }

    public Object getEntryPointData() {
        return this.entryPointData;
    }

    public boolean isIntrinsicMethod() {
        return this.isIntrinsicMethod;
    }

    public void registerAsRootMethod() {
        this.isRootMethod = true;
        this.getDeclaringClass().registerAsReachable();
    }

    public boolean isRootMethod() {
        return this.isRootMethod;
    }

    public boolean isSimplyInvoked() {
        return this.isInvoked;
    }

    public boolean isSimplyImplementationInvoked() {
        return this.isImplementationInvoked;
    }

    public boolean isInvoked() {
        return this.isIntrinsicMethod || this.isRootMethod() || this.isInvoked;
    }

    public boolean isImplementationInvoked() {
        return !Modifier.isAbstract(this.getModifiers()) && (this.isIntrinsicMethod || this.isRootMethod() || this.isImplementationInvoked);
    }

    public boolean isReachable() {
        return this.isImplementationInvoked() || this.isInlined;
    }

    @Override
    public ResolvedJavaMethod getWrapped() {
        return this.wrapped;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public WrappedSignature getSignature() {
        return this.universe.lookup(this.wrapped.getSignature(), (WrappedJavaType)this.getDeclaringClass());
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (this.wrapped instanceof GraphProvider) {
            return ((GraphProvider)this.wrapped).buildGraph(debug, method, providers, purpose);
        }
        return null;
    }

    @Override
    public boolean allowRuntimeCompilation() {
        if (this.wrapped instanceof GraphProvider) {
            return ((GraphProvider)this.wrapped).allowRuntimeCompilation();
        }
        return true;
    }

    public byte[] getCode() {
        return this.wrapped.getCode();
    }

    public int getCodeSize() {
        return this.wrapped.getCodeSize();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public int getMaxLocals() {
        return this.wrapped.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.wrapped.getMaxStackSize();
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.wrapped.getParameters();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isVarArgs() {
        throw JVMCIError.unimplemented();
    }

    public boolean isBridge() {
        return this.wrapped.isBridge();
    }

    public boolean isClassInitializer() {
        return this.wrapped.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.wrapped.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        boolean result = this.wrapped.canBeStaticallyBound();
        assert (!this.isStatic() || result) : "static methods must always be statically bindable: " + this.format("%H.%n");
        return result;
    }

    public AnalysisMethod[] getImplementations() {
        assert (this.universe.analysisDataValid);
        if (this.implementations == null) {
            return new AnalysisMethod[0];
        }
        return this.implementations;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.wrapped.asStackTraceElement(bci);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return StaticAnalysisResults.NO_RESULTS;
    }

    public ConstantPool getConstantPool() {
        return this.universe.lookup(this.wrapped.getConstantPool(), (WrappedJavaType)this.getDeclaringClass());
    }

    public Annotation[] getAnnotations() {
        return GuardedAnnotationAccess.getAnnotations((AnnotatedElement)this.wrapped);
    }

    public Annotation[] getDeclaredAnnotations() {
        return GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)this.wrapped);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)this.wrapped, annotationClass);
    }

    public Annotation[][] getParameterAnnotations() {
        return this.wrapped.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.wrapped.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return !this.hasNeverInlineDirective();
    }

    public boolean hasNeverInlineDirective() {
        return this.hasNeverInlineDirective;
    }

    public boolean shouldBeInlined() {
        throw JVMCIError.unimplemented();
    }

    public LineNumberTable getLineNumberTable() {
        return this.wrapped.getLineNumberTable();
    }

    public String toString() {
        return "AnalysisMethod<" + this.format("%H.%n") + " -> " + this.wrapped.toString() + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void reprofile() {
        throw JVMCIError.unimplemented();
    }

    public Constant getEncoding() {
        throw JVMCIError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return false;
    }

    public boolean isDefault() {
        return this.wrapped.isDefault();
    }

    public SpeculationLog getSpeculationLog() {
        throw JVMCIError.shouldNotReachHere();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public Executable getJavaMethod() {
        return OriginalMethodProvider.getJavaMethod(this.universe.getOriginalSnippetReflection(), this.wrapped);
    }

    public InvokeTypeFlow initAndGetContextInsensitiveInvoke(BigBang bb, BytecodePosition originalLocation) {
        AbstractVirtualInvokeTypeFlow invoke;
        boolean set;
        if (this.contextInsensitiveInvoke.get() == null && (set = this.contextInsensitiveInvoke.compareAndSet(null, invoke = InvokeTypeFlow.createContextInsensitiveInvoke(bb, this, originalLocation)))) {
            InvokeTypeFlow.initContextInsensitiveInvoke(bb, this, invoke);
        }
        return this.contextInsensitiveInvoke.get();
    }

    public InvokeTypeFlow getContextInsensitiveInvoke() {
        InvokeTypeFlow invoke = this.contextInsensitiveInvoke.get();
        AnalysisError.guarantee(invoke != null);
        return invoke;
    }

    /*
     * Unable to fully structure code
     */
    public AnalysisParsedGraph ensureGraphParsed(BigBang bb) {
        while (true) lbl-1000:
        // 4 sources

        {
            if ((curState = this.parsedGraphCacheState.get()) == AnalysisMethod.GRAPH_CACHE_UNPARSED) {
                lock = new ReentrantLock();
                lock.lock();
                try {
                    if (!this.parsedGraphCacheState.compareAndSet(AnalysisMethod.GRAPH_CACHE_UNPARSED, lock)) ** GOTO lbl-1000
                    graph = bb.getHostVM().parseBytecode(bb, this);
                    result = this.parsedGraphCacheState.compareAndSet(lock, graph);
                    AnalysisError.guarantee(result, "State transition failed", new Object[0]);
                    var6_7 = graph;
                    return var6_7;
                }
                catch (Throwable ex) {
                    this.parsedGraphCacheState.set(ex);
                    throw ex;
                }
                finally {
                    lock.unlock();
                }
                continue;
            }
            if (!(curState instanceof ReentrantLock)) break;
            lock = (ReentrantLock)curState;
            AnalysisError.guarantee(lock.isHeldByCurrentThread() == false, "Recursive parsing request, would lead to endless waiting loop", new Object[0]);
            lock.lock();
            AnalysisError.guarantee(this.parsedGraphCacheState.get() != lock, "Parsing must have finished in the thread that installed the lock", new Object[0]);
            lock.unlock();
        }
        if (curState instanceof AnalysisParsedGraph) {
            return (AnalysisParsedGraph)curState;
        }
        if (curState instanceof Throwable) {
            throw AnalysisError.shouldNotReachHere("parsing had failed in another thread", (Throwable)curState);
        }
        if (curState == AnalysisMethod.GRAPH_CACHE_CLEARED) {
            return null;
        }
        throw AnalysisError.shouldNotReachHere("Unknown state: " + curState);
    }

    public StructuredGraph getAnalyzedGraph() {
        return this.analyzedGraph;
    }

    public void setAnalyzedGraph(StructuredGraph analyzedGraph) {
        this.analyzedGraph = analyzedGraph;
    }
}

