/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaConstant;

public final class AnalysisHeapHistogramPrinter
extends ObjectScanner {
    private final Map<AnalysisType, Integer> histogram = new HashMap<AnalysisType, Integer>();

    public static void print(BigBang bigbang, String path, String reportName) {
        ReportUtils.report("analysis heap histogram", path + File.separatorChar + "reports", "analysis_heap_histogram_" + reportName, "txt", writer -> AnalysisHeapHistogramPrinter.doPrint(writer, bigbang));
    }

    private static void doPrint(PrintWriter out, BigBang bigbang) {
        if (!((Boolean)PointstoOptions.ExhaustiveHeapScan.getValue(bigbang.getOptions())).booleanValue()) {
            String types = Arrays.stream(bigbang.skippedHeapTypes()).map(t -> t.toJavaName()).collect(Collectors.joining(", "));
            System.out.println("Exhaustive heap scanning is disabled. The analysis heap histogram will not contain all instances of types: " + types);
            System.out.println("Exhaustive heap scanning can be turned on using -H:+ExhaustiveHeapScan.");
        }
        AnalysisHeapHistogramPrinter printer = new AnalysisHeapHistogramPrinter(bigbang);
        printer.scanBootImageHeapRoots(ReportUtils.fieldComparator, ReportUtils.positionComparator);
        printer.printHistogram(out);
    }

    private void printHistogram(PrintWriter out) {
        out.println("Heap histogram");
        out.format("%8s %s %n", "Count", "Class");
        this.histogram.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> out.format("%8d %8s %n", entry.getValue(), ((AnalysisType)entry.getKey()).toJavaName()));
    }

    private AnalysisHeapHistogramPrinter(BigBang bigbang) {
        super(bigbang, null, new ObjectScanner.ReusableSet());
    }

    @Override
    protected void forScannedConstant(JavaConstant scannedValue, ObjectScanner.ScanReason reason) {
        AnalysisType type = AnalysisHeapHistogramPrinter.constantType(this.bb, scannedValue);
        int count = this.histogram.getOrDefault(type, 0);
        this.histogram.put(type, count + 1);
    }

    @Override
    public void forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
    }

    @Override
    public void forNullFieldValue(JavaConstant receiver, AnalysisField field) {
    }

    @Override
    public void forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
    }

    @Override
    public void forNullArrayElement(JavaConstant array, AnalysisType arrayType, int index) {
    }

    @Override
    public void forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int index) {
    }
}

