/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.results;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.TriState;

public abstract class AbstractAnalysisResultsBuilder {
    protected final BigBang bb;
    protected final Universe converter;
    private final JavaTypeProfile[] types0;
    private final JavaTypeProfile[] types1Null;
    private final JavaTypeProfile[] types1NonNull;
    private final Map<JavaTypeProfile, JavaTypeProfile> types;
    private final JavaMethodProfile[] methods0;
    private final JavaMethodProfile[] methods1;
    private final Map<JavaMethodProfile, JavaMethodProfile> methods;

    protected AbstractAnalysisResultsBuilder(BigBang bb, Universe converter) {
        this.bb = bb;
        this.converter = converter;
        this.types0 = new JavaTypeProfile[2];
        this.types1Null = new JavaTypeProfile[bb.getUniverse().getNextTypeId()];
        this.types1NonNull = new JavaTypeProfile[bb.getUniverse().getNextTypeId()];
        this.types = new HashMap<JavaTypeProfile, JavaTypeProfile>();
        this.methods0 = new JavaMethodProfile[1];
        this.methods1 = new JavaMethodProfile[bb.getUniverse().getNextMethodId()];
        this.methods = new HashMap<JavaMethodProfile, JavaMethodProfile>();
    }

    public BigBang getBigBang() {
        return this.bb;
    }

    public abstract StaticAnalysisResults makeOrApplyResults(AnalysisMethod var1);

    public abstract JavaTypeProfile makeTypeProfile(AnalysisField var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaTypeProfile makeTypeProfile(TypeState typeState) {
        if (typeState == null || (Integer)PointstoOptions.AnalysisSizeCutoff.getValue(this.bb.getOptions()) != -1 && typeState.typesCount() > (Integer)PointstoOptions.AnalysisSizeCutoff.getValue(this.bb.getOptions())) {
            return null;
        }
        if (typeState.isEmpty()) {
            JavaTypeProfile[] javaTypeProfileArray = this.types0;
            synchronized (this.types0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.cachedTypeProfile(this.types0, 0, typeState);
            }
        }
        if (typeState.isNull()) {
            JavaTypeProfile[] javaTypeProfileArray = this.types0;
            synchronized (this.types0) {
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return this.cachedTypeProfile(this.types0, 1, typeState);
            }
        }
        if (typeState.exactType() != null) {
            if (typeState.canBeNull()) {
                JavaTypeProfile[] javaTypeProfileArray = this.types1Null;
                synchronized (this.types1Null) {
                    // ** MonitorExit[var2_4] (shouldn't be in output)
                    return this.cachedTypeProfile(this.types1Null, typeState.exactType().getId(), typeState);
                }
            }
            JavaTypeProfile[] javaTypeProfileArray = this.types1NonNull;
            synchronized (this.types1NonNull) {
                // ** MonitorExit[var2_5] (shouldn't be in output)
                return this.cachedTypeProfile(this.types1NonNull, typeState.exactType().getId(), typeState);
            }
        }
        Map<JavaTypeProfile, JavaTypeProfile> map = this.types;
        synchronized (map) {
            JavaTypeProfile created = this.createTypeProfile(typeState);
            this.types.putIfAbsent(created, created);
            return created;
        }
    }

    private JavaTypeProfile cachedTypeProfile(JavaTypeProfile[] cache, int cacheIdx, TypeState typeState) {
        JavaTypeProfile result = cache[cacheIdx];
        if (result == null) {
            cache[cacheIdx] = result = this.createTypeProfile(typeState);
        }
        return result;
    }

    private JavaTypeProfile createTypeProfile(TypeState typeState) {
        double probability = 1.0 / (double)typeState.typesCount();
        JavaTypeProfile.ProfiledType[] pitems = (JavaTypeProfile.ProfiledType[])typeState.typesStream().map(analysisType -> this.converter == null ? analysisType : this.converter.lookup((JavaType)analysisType)).sorted().map(type -> new JavaTypeProfile.ProfiledType(type, probability)).toArray(JavaTypeProfile.ProfiledType[]::new);
        return new JavaTypeProfile(TriState.get((boolean)typeState.canBeNull()), 0.0, pitems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaMethodProfile makeMethodProfile(Collection<AnalysisMethod> callees) {
        if ((Integer)PointstoOptions.AnalysisSizeCutoff.getValue(this.bb.getOptions()) != -1 && callees.size() > (Integer)PointstoOptions.AnalysisSizeCutoff.getValue(this.bb.getOptions())) {
            return null;
        }
        if (callees.isEmpty()) {
            JavaMethodProfile[] javaMethodProfileArray = this.methods0;
            synchronized (this.methods0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.cachedMethodProfile(this.methods0, 0, callees);
            }
        }
        if (callees.size() == 1) {
            JavaMethodProfile[] javaMethodProfileArray = this.methods1;
            synchronized (this.methods1) {
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return this.cachedMethodProfile(this.methods1, callees.iterator().next().getId(), callees);
            }
        }
        Map<JavaMethodProfile, JavaMethodProfile> map = this.methods;
        synchronized (map) {
            JavaMethodProfile created = this.createMethodProfile(callees);
            this.methods.putIfAbsent(created, created);
            return created;
        }
    }

    private JavaMethodProfile cachedMethodProfile(JavaMethodProfile[] cache, int cacheIdx, Collection<AnalysisMethod> callees) {
        JavaMethodProfile result = cache[cacheIdx];
        if (result == null) {
            cache[cacheIdx] = result = this.createMethodProfile(callees);
        }
        return result;
    }

    private JavaMethodProfile createMethodProfile(Collection<AnalysisMethod> callees) {
        JavaMethodProfile.ProfiledMethod[] pitems = new JavaMethodProfile.ProfiledMethod[callees.size()];
        double probability = 1.0 / (double)pitems.length;
        int idx = 0;
        for (AnalysisMethod aMethod : callees) {
            AnalysisMethod convertedMethod = this.converter == null ? aMethod : this.converter.lookup((JavaMethod)aMethod);
            pitems[idx++] = new JavaMethodProfile.ProfiledMethod((ResolvedJavaMethod)convertedMethod, probability);
        }
        return new JavaMethodProfile(0.0, pitems);
    }
}

