/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.results;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.results.AbstractAnalysisResultsBuilder;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LimitedValueProxy;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public abstract class StrengthenGraphs
extends AbstractAnalysisResultsBuilder {
    public StrengthenGraphs(BigBang bb, Universe converter) {
        super(bb, converter);
    }

    @Override
    public StaticAnalysisResults makeOrApplyResults(AnalysisMethod method) {
        StructuredGraph graph = method.getAnalyzedGraph();
        if (graph != null) {
            DebugContext debug = new DebugContext.Builder(this.bb.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory(this.bb.getProviders().getSnippetReflection())).build();
            graph.resetDebug(debug);
            try (DebugContext.Scope s = debug.scope((Object)"StrengthenGraphs", (Object)graph);
                 DebugContext.Activation a = debug.activate();){
                CanonicalizerPhase.create().copyWithCustomSimplification((CanonicalizerPhase.CustomSimplification)new StrengthenSimplifier(method, graph)).apply(graph, (Object)this.bb.getProviders());
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
        }
        return StaticAnalysisResults.NO_RESULTS;
    }

    @Override
    public JavaTypeProfile makeTypeProfile(AnalysisField field) {
        return null;
    }

    protected abstract AnalysisType getSingleImplementorType(AnalysisType var1);

    protected abstract AnalysisType getStrengthenStampType(AnalysisType var1);

    protected abstract FixedNode createUnreachable(StructuredGraph var1, CoreProviders var2, Supplier<String> var3);

    protected abstract void setInvokeProfiles(Invoke var1, JavaTypeProfile var2, JavaMethodProfile var3);

    class StrengthenSimplifier
    implements CanonicalizerPhase.CustomSimplification {
        private final StructuredGraph graph;
        private final MethodTypeFlow methodFlow;
        private final MethodFlowsGraph originalFlows;
        private final NodeBitMap createdPiNodes;

        StrengthenSimplifier(AnalysisMethod method, StructuredGraph graph) {
            this.graph = graph;
            this.methodFlow = method.getTypeFlow();
            this.originalFlows = this.methodFlow.getOriginalMethodFlows();
            this.createdPiNodes = new NodeBitMap((Graph)graph);
        }

        public void simplify(Node n, SimplifierTool tool) {
            Stamp oldStamp;
            Stamp newStamp;
            ParameterNode node;
            if (n instanceof ValueNode && !(n instanceof LimitedValueProxy) && !(n instanceof PhiNode)) {
                node = (ValueNode)n;
                node.inferStamp();
                this.updateStampInPlace((ValueNode)node, this.strengthenStamp(node.stamp(NodeView.DEFAULT)), tool);
            }
            if (n instanceof ParameterNode) {
                node = (ParameterNode)n;
                StartNode anchorPoint = this.graph.start();
                Stamp newStamp2 = this.strengthenStampFromTypeFlow((ValueNode)node, this.originalFlows.getParameter(node.index()), (FixedWithNextNode)anchorPoint, tool);
                this.updateStampUsingPiNode((ValueNode)node, newStamp2, (FixedWithNextNode)anchorPoint, tool);
            } else if (n instanceof LoadFieldNode || n instanceof LoadIndexedNode) {
                node = (FixedWithNextNode)n;
                Stamp newStamp3 = this.strengthenStampFromTypeFlow((ValueNode)node, this.originalFlows.getNodeFlows().get(node), (FixedWithNextNode)node, tool);
                this.updateStampInPlace((ValueNode)node, newStamp3, tool);
            } else if (n instanceof Invoke) {
                Invoke invoke = (Invoke)n;
                if (invoke.callTarget() instanceof MethodCallTargetNode) {
                    this.handleInvoke(invoke, tool);
                }
            } else if (n instanceof IfNode) {
                node = (IfNode)n;
                boolean trueUnreachable = this.isUnreachable((Node)node.trueSuccessor());
                boolean falseUnreachable = this.isUnreachable((Node)node.falseSuccessor());
                if (trueUnreachable && falseUnreachable) {
                    this.makeUnreachable((FixedNode)node, (CoreProviders)tool, () -> this.lambda$simplify$0((IfNode)node));
                } else if (trueUnreachable || falseUnreachable) {
                    AbstractBeginNode killedBegin = node.successor(trueUnreachable);
                    AbstractBeginNode survivingBegin = node.successor(!trueUnreachable);
                    if (survivingBegin.hasUsages()) {
                        ValueAnchorNode anchor = (ValueAnchorNode)this.graph.add((Node)new ValueAnchorNode(null));
                        this.graph.addAfterFixed((FixedWithNextNode)survivingBegin, (FixedNode)anchor);
                        survivingBegin.replaceAtUsages((Node)anchor, new InputType[]{InputType.Guard, InputType.Anchor});
                    }
                    this.graph.removeSplit((ControlSplitNode)node, survivingBegin);
                    GraphUtil.killCFG((FixedNode)killedBegin);
                }
            } else if (n instanceof FixedGuardNode) {
                node = (FixedGuardNode)n;
                if (this.isUnreachable((Node)node)) {
                    node.setCondition((LogicNode)LogicConstantNode.tautology((Graph)this.graph), true);
                    tool.addToWorkList((Node)node);
                }
            } else if (n instanceof InstanceOfNode) {
                node = (InstanceOfNode)n;
                ObjectStamp oldStamp2 = node.getCheckedStamp();
                Stamp newStamp4 = this.strengthenStamp((Stamp)oldStamp2);
                if (newStamp4 != null) {
                    LogicNode replacement = (LogicNode)this.graph.addOrUniqueWithInputs((Node)InstanceOfNode.createHelper((ObjectStamp)((ObjectStamp)oldStamp2.improveWith(newStamp4)), (ValueNode)node.getValue(), (JavaTypeProfile)node.profile(), (AnchoringNode)node.getAnchor()));
                    node.replaceAndDelete((Node)replacement);
                    tool.addToWorkList((Node)replacement);
                }
            } else if (n instanceof PiNode && (newStamp = this.strengthenStamp(oldStamp = (node = (PiNode)n).piStamp())) != null) {
                node.strengthenPiStamp(oldStamp.improveWith(newStamp));
                tool.addToWorkList((Node)node);
            }
        }

        private void handleInvoke(Invoke invoke, SimplifierTool tool) {
            FixedNode node = invoke.asNode();
            MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
            InvokeTypeFlow invokeFlow = this.originalFlows.getInvokeFlow(invoke);
            Collection<AnalysisMethod> callees = invokeFlow.getCallees();
            if (callees.isEmpty()) {
                this.unreachableInvoke(invoke, tool);
                return;
            }
            FixedWithNextNode beforeInvoke = (FixedWithNextNode)invoke.predecessor();
            NodeInputList arguments = callTarget.arguments();
            for (int i = 0; i < arguments.size(); ++i) {
                PiNode pi;
                ValueNode argument = (ValueNode)arguments.get(i);
                Stamp newStamp = this.strengthenStampFromTypeFlow(argument, invokeFlow.getActualParameters()[i], beforeInvoke, tool);
                if (node.isDeleted()) {
                    return;
                }
                if (newStamp == null || (pi = this.insertPi(argument, newStamp, beforeInvoke)) == null) continue;
                callTarget.replaceAllInputs((Node)argument, (Node)pi);
            }
            if (callees.size() == 1) {
                AnalysisMethod singleCallee = callees.iterator().next();
                if (callTarget.invokeKind().isDirect()) {
                    assert (callTarget.targetMethod().equals(singleCallee)) : "Direct invoke target mismatch: " + callTarget.targetMethod() + " != " + singleCallee;
                } else {
                    this.devirtualizeInvoke(singleCallee, invoke);
                }
            } else {
                TypeState receiverTypeState = null;
                if (invokeFlow.getTargetMethod().hasReceiver() && !this.methodFlow.isSaturated(StrengthenGraphs.this.bb, invokeFlow.getReceiver())) {
                    receiverTypeState = this.methodFlow.foldTypeFlow(StrengthenGraphs.this.bb, invokeFlow.getReceiver());
                }
                JavaTypeProfile typeProfile = StrengthenGraphs.this.makeTypeProfile(receiverTypeState);
                JavaMethodProfile methodProfile = StrengthenGraphs.this.makeMethodProfile(callees);
                assert (typeProfile == null || typeProfile.getTypes().length > 1) : "Should devirtualize with typeProfile=" + typeProfile + " and methodProfile=" + methodProfile;
                assert (methodProfile == null || methodProfile.getMethods().length > 1) : "Should devirtualize with typeProfile=" + typeProfile + " and methodProfile=" + methodProfile;
                StrengthenGraphs.this.setInvokeProfiles(invoke, typeProfile, methodProfile);
            }
            this.optimizeReturnedParameter(callees, (NodeInputList<ValueNode>)arguments, node, tool);
            FixedWithNextNode anchorPointAfterInvoke = (FixedWithNextNode)(invoke instanceof InvokeWithExceptionNode ? invoke.next() : invoke);
            Stamp newStamp = this.strengthenStampFromTypeFlow((ValueNode)node, invokeFlow.getResult(), anchorPointAfterInvoke, tool);
            this.updateStampUsingPiNode((ValueNode)node, newStamp, anchorPointAfterInvoke, tool);
        }

        private void optimizeReturnedParameter(Collection<AnalysisMethod> callees, NodeInputList<ValueNode> arguments, FixedNode invoke, SimplifierTool tool) {
            int returnedParameterIndex = -1;
            for (AnalysisMethod callee : callees) {
                if (callee.hasNeverInlineDirective()) {
                    return;
                }
                ParameterNode returnedCalleeParameter = callee.getTypeFlow().getReturnedParameter();
                if (returnedCalleeParameter == null) {
                    return;
                }
                int returnedCalleeParameterIndex = returnedCalleeParameter.index();
                if (returnedParameterIndex == -1) {
                    returnedParameterIndex = returnedCalleeParameterIndex;
                    continue;
                }
                if (returnedParameterIndex == returnedCalleeParameterIndex) continue;
                return;
            }
            assert (returnedParameterIndex != -1);
            ValueNode returnedActualParameter = (ValueNode)arguments.get(returnedParameterIndex);
            tool.addToWorkList((Iterable)invoke.usages());
            invoke.replaceAtUsages((Node)returnedActualParameter);
        }

        private void unreachableInvoke(Invoke invoke, SimplifierTool tool) {
            if (invoke.getInvokeKind() != CallTargetNode.InvokeKind.Static) {
                InliningUtil.nonNullReceiver((Invoke)invoke);
            }
            this.makeUnreachable(invoke.asNode(), (CoreProviders)tool, () -> "method " + this.graph.method().format("%H.%n(%p)") + ", node " + invoke + ": empty list of callees for call to " + invoke.callTarget().targetMethod().format("%H.%n(%P)"));
        }

        private void devirtualizeInvoke(AnalysisMethod singleCallee, Invoke invoke) {
            ObjectStamp anchoredReceiverStamp = StampFactory.object((TypeReference)TypeReference.createWithoutAssumptions((ResolvedJavaType)singleCallee.getDeclaringClass()));
            PiNode piReceiver = this.insertPi(invoke.getReceiver(), (Stamp)anchoredReceiverStamp, (FixedWithNextNode)invoke.asNode().predecessor());
            if (piReceiver != null) {
                invoke.callTarget().replaceFirstInput((Node)invoke.getReceiver(), (Node)piReceiver);
            }
            assert (invoke.getInvokeKind().isIndirect());
            invoke.callTarget().setInvokeKind(CallTargetNode.InvokeKind.Special);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)singleCallee);
        }

        private boolean isUnreachable(Node branch) {
            TypeFlow<?> branchFlow = this.originalFlows.getNodeFlows().get(branch);
            return branchFlow != null && !this.methodFlow.isSaturated(StrengthenGraphs.this.bb, branchFlow) && this.methodFlow.foldTypeFlow(StrengthenGraphs.this.bb, branchFlow).isEmpty();
        }

        private void updateStampInPlace(ValueNode node, Stamp newStamp, SimplifierTool tool) {
            Stamp computedStamp;
            Stamp oldStamp;
            if (newStamp != null && !(oldStamp = node.stamp(NodeView.DEFAULT)).equals(computedStamp = oldStamp.improveWith(newStamp))) {
                node.setStamp(newStamp);
                tool.addToWorkList((Iterable)node.usages());
            }
        }

        private void updateStampUsingPiNode(ValueNode node, Stamp newStamp, FixedWithNextNode anchorPoint, SimplifierTool tool) {
            PiNode pi;
            if (newStamp != null && node.hasUsages() && !this.createdPiNodes.isMarked((Node)node) && (pi = this.insertPi(node, newStamp, anchorPoint)) != null) {
                this.createdPiNodes.mark((Node)node);
                FrameState anchorState = node instanceof StateSplit ? ((StateSplit)node).stateAfter() : this.graph.start().stateAfter();
                node.replaceAtUsages((Node)pi, usage -> usage != pi && usage != anchorState);
                tool.addToWorkList((Iterable)pi.usages());
            }
        }

        private PiNode insertPi(ValueNode input, Stamp piStamp, FixedWithNextNode anchorPoint) {
            Stamp computedStamp;
            Stamp oldStamp = input.stamp(NodeView.DEFAULT);
            if (oldStamp.equals(computedStamp = oldStamp.improveWith(piStamp))) {
                return null;
            }
            ValueAnchorNode anchor = (ValueAnchorNode)this.graph.add((Node)new ValueAnchorNode(null));
            this.graph.addAfterFixed(anchorPoint, (FixedNode)anchor);
            return (PiNode)this.graph.unique((Node)new PiNode(input, piStamp, (ValueNode)anchor));
        }

        private Stamp strengthenStampFromTypeFlow(ValueNode node, TypeFlow<?> nodeFlow, FixedWithNextNode anchorPoint, SimplifierTool tool) {
            if (node.getStackKind() != JavaKind.Object) {
                return null;
            }
            if (node.usages().filter(n -> !(n instanceof FrameState)).isEmpty()) {
                return null;
            }
            if (this.methodFlow.isSaturated(StrengthenGraphs.this.bb, nodeFlow)) {
                return null;
            }
            TypeState nodeTypeState = this.methodFlow.foldTypeFlow(StrengthenGraphs.this.bb, nodeFlow);
            node.inferStamp();
            ObjectStamp oldStamp = (ObjectStamp)node.stamp(NodeView.DEFAULT);
            AnalysisType oldType = (AnalysisType)oldStamp.type();
            boolean nonNull = oldStamp.nonNull() || !nodeTypeState.canBeNull();
            ArrayList<AnalysisType> typeStateTypes = new ArrayList<AnalysisType>(nodeTypeState.typesCount());
            for (AnalysisType typeStateType2 : nodeTypeState.types()) {
                if (oldType != null && !(oldStamp.isExactType() ? oldType.equals(typeStateType2) : oldType.isAssignableFrom(typeStateType2))) continue;
                typeStateTypes.add(typeStateType2);
            }
            if (typeStateTypes.size() == 0) {
                if (nonNull) {
                    this.makeUnreachable(anchorPoint.next(), (CoreProviders)tool, () -> "method " + this.graph.method().format("%H.%n(%p)") + ", node " + node + ": empty stamp when strengthening oldStamp " + oldStamp);
                    return null;
                }
                return StampFactory.alwaysNull();
            }
            if (typeStateTypes.size() == 1) {
                ResolvedJavaType targetType;
                AnalysisType exactType = (AnalysisType)typeStateTypes.get(0);
                assert (StrengthenGraphs.this.getSingleImplementorType(exactType) == null || exactType.equals(StrengthenGraphs.this.getSingleImplementorType(exactType))) : "exactType=" + exactType + ", singleImplementor=" + StrengthenGraphs.this.getSingleImplementorType(exactType);
                assert (exactType.equals(StrengthenGraphs.this.getStrengthenStampType(exactType)));
                if (!(oldStamp.isExactType() && exactType.equals(oldType) || (targetType = this.toTarget(exactType)) == null)) {
                    TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                    return StampFactory.object((TypeReference)typeRef, (boolean)nonNull);
                }
            } else if (!oldStamp.isExactType()) {
                ResolvedJavaType targetType;
                assert (typeStateTypes.size() > 1);
                AnalysisType baseType = (AnalysisType)typeStateTypes.get(0);
                for (int i = 1; i < typeStateTypes.size(); ++i) {
                    baseType = baseType.findLeastCommonAncestor((ResolvedJavaType)typeStateTypes.get(i));
                }
                if (oldType != null && !oldType.isAssignableFrom(baseType)) {
                    baseType = oldType;
                }
                assert (StrengthenGraphs.this.getSingleImplementorType(baseType) == null || baseType.equals(StrengthenGraphs.this.getSingleImplementorType(baseType))) : "baseType=" + baseType + ", singleImplementor=" + StrengthenGraphs.this.getSingleImplementorType(baseType);
                AnalysisType newType = StrengthenGraphs.this.getStrengthenStampType(baseType);
                assert (typeStateTypes.stream().map(typeStateType -> newType.isAssignableFrom((ResolvedJavaType)typeStateType)).reduce(Boolean::logicalAnd).get().booleanValue());
                if (!(newType.equals(oldType) || oldType == null && newType.isJavaLangObject() || (targetType = this.toTarget(newType)) == null)) {
                    TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType);
                    return StampFactory.object((TypeReference)typeRef, (boolean)nonNull);
                }
            }
            if (nonNull != oldStamp.nonNull()) {
                assert (nonNull);
                return oldStamp.asNonNull();
            }
            return null;
        }

        private void makeUnreachable(FixedNode node, CoreProviders providers, Supplier<String> message) {
            FixedNode unreachableNode = StrengthenGraphs.this.createUnreachable(this.graph, providers, message);
            ((FixedWithNextNode)node.predecessor()).setNext(unreachableNode);
            GraphUtil.killCFG((FixedNode)node);
        }

        protected ResolvedJavaType toTarget(AnalysisType type) {
            return type;
        }

        private Stamp strengthenStamp(Stamp s) {
            Stamp newStamp;
            ResolvedJavaType targetType;
            if (!(s instanceof AbstractObjectStamp)) {
                return null;
            }
            AbstractObjectStamp stamp = (AbstractObjectStamp)s;
            AnalysisType originalType = (AnalysisType)stamp.type();
            if (originalType == null) {
                return null;
            }
            AnalysisType singleImplementorType = StrengthenGraphs.this.getSingleImplementorType(originalType);
            if (!(singleImplementorType == null || stamp.isExactType() && singleImplementorType.equals(originalType) || (targetType = this.toTarget(singleImplementorType)) == null)) {
                TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                return StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
            }
            AnalysisType strengthenType = StrengthenGraphs.this.getStrengthenStampType(originalType);
            if (originalType.equals(strengthenType)) {
                return null;
            }
            if (strengthenType == null) {
                newStamp = stamp.nonNull() ? StampFactory.empty((JavaKind)JavaKind.Object) : StampFactory.alwaysNull();
            } else if (stamp.isExactType()) {
                newStamp = StampFactory.empty((JavaKind)JavaKind.Object);
            } else {
                ResolvedJavaType targetType2 = this.toTarget(strengthenType);
                if (targetType2 == null) {
                    return null;
                }
                TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType2);
                newStamp = StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
            }
            return newStamp;
        }

        private /* synthetic */ String lambda$simplify$0(IfNode node) {
            return "method " + this.graph.method().format("%H.%n(%p)") + ", node " + node + ": both successors of IfNode are unreachable";
        }
    }
}

