/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.EmptyTypeState;
import com.oracle.graal.pointsto.typestate.MultiTypeState;
import com.oracle.graal.pointsto.typestate.NullTypeState;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeStateUtils;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.JavaConstant;

public abstract class TypeState {
    private int id = -1;
    protected final int properties;
    private static ThreadLocal<UnsafeArrayListClosable<AnalysisObject>> doUnion2TL = new ThreadLocal();
    private static ThreadLocal<UnsafeArrayListClosable<AnalysisObject>> doUnion2ObjectsTL = new ThreadLocal();
    private static ThreadLocal<UnsafeArrayListClosable<AnalysisObject>> intersectionArrayListTL = new ThreadLocal();

    public TypeState(int properties) {
        this.properties = properties;
    }

    public int getProperties() {
        return this.properties;
    }

    public abstract boolean hasExactTypes(BitSet var1);

    public abstract int typesCount();

    public abstract AnalysisType exactType();

    protected abstract Iterator<AnalysisType> typesIterator();

    public Iterable<AnalysisType> types() {
        return this::typesIterator;
    }

    public Stream<AnalysisType> typesStream() {
        return StreamSupport.stream(this.types().spliterator(), false);
    }

    public abstract boolean containsType(AnalysisType var1);

    public abstract int objectsCount();

    public abstract AnalysisObject[] objects();

    public abstract AnalysisObject[] objectsArray(AnalysisType var1);

    protected abstract Iterator<AnalysisObject> objectsIterator(AnalysisType var1);

    public Iterable<AnalysisObject> objects(AnalysisType type) {
        return () -> this.objectsIterator(type);
    }

    public Stream<AnalysisObject> objectsStream() {
        return Arrays.stream(this.objects());
    }

    public boolean containsObject(AnalysisObject object) {
        return this.containsType(object.type()) && Arrays.binarySearch(this.objects(), object) >= 0;
    }

    public TypesObjectsIterator getTypesObjectsIterator() {
        return new TypesObjectsIterator(this);
    }

    public boolean isAllocation() {
        return this.objects().length == 1 && this.objects()[0].isAllocationContextSensitiveObject();
    }

    public boolean isConstant() {
        return this.objects().length == 1 && this.objects()[0].isConstantContextSensitiveObject();
    }

    public boolean isEmpty() {
        return this == EmptyTypeState.SINGLETON;
    }

    public boolean isSingleTypeState() {
        return this.typesCount() == 1;
    }

    public boolean isMultiTypeState() {
        return this instanceof MultiTypeState;
    }

    public boolean isNull() {
        return this == NullTypeState.SINGLETON;
    }

    public abstract boolean canBeNull();

    public void noteMerge(BigBang bb) {
    }

    public abstract TypeState exactTypeState(BigBang var1, AnalysisType var2);

    public boolean verifyDeclaredType(AnalysisType declaredType) {
        if (declaredType != null) {
            for (AnalysisType e : this.types()) {
                if (declaredType.isAssignableFrom(e)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean closeToAllInstantiated(BigBang bb) {
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract boolean equals(Object var1);

    public int getId(BigBang bb) {
        assert (bb.reportAnalysisStatistics()) : "TypeState id should only be used for statistics.";
        return this.id;
    }

    public void setId(BigBang bb, int id) {
        assert (bb.reportAnalysisStatistics()) : "TypeState id should only be used for statistics.";
        this.id = id;
    }

    public static TypeState forEmpty() {
        return EmptyTypeState.SINGLETON;
    }

    public static TypeState forNull() {
        return NullTypeState.SINGLETON;
    }

    public static TypeState forNonNullObject(BigBang bb, AnalysisObject object) {
        return new SingleTypeState(bb, false, bb.analysisPolicy().makePoperties(bb, object), object);
    }

    public static TypeState forConstant(BigBang bb, JavaConstant constant, AnalysisType exactType) {
        assert (!constant.isNull());
        assert (exactType.isArray() || exactType.isInstanceClass() && !Modifier.isAbstract(exactType.getModifiers())) : exactType;
        AnalysisObject constantObject = bb.analysisPolicy().createConstantObject(bb, constant, exactType);
        return TypeState.forNonNullObject(bb, constantObject);
    }

    public static TypeState forAllocation(BigBang bb, BytecodeLocation allocationLabel, AnalysisType exactType) {
        return TypeState.forAllocation(bb, allocationLabel, exactType, bb.contextPolicy().emptyContext());
    }

    public static TypeState forAllocation(BigBang bb, BytecodeLocation allocationSite, AnalysisType objectType, AnalysisContext allocationContext) {
        assert (objectType.isArray() || objectType.isInstanceClass() && !Modifier.isAbstract(objectType.getModifiers())) : objectType;
        AnalysisObject allocationObject = bb.analysisPolicy().createHeapObject(bb, objectType, allocationSite, allocationContext);
        return TypeState.forNonNullObject(bb, allocationObject);
    }

    public static TypeState forClone(BigBang bb, BytecodeLocation cloneSite, AnalysisType type, AnalysisContext allocationContext) {
        return TypeState.forAllocation(bb, cloneSite, type, allocationContext);
    }

    public static TypeState forExactType(BigBang bb, AnalysisType exactType, boolean canBeNull) {
        return TypeState.forExactType(bb, exactType.getContextInsensitiveAnalysisObject(), canBeNull);
    }

    public static TypeState forExactType(BigBang bb, AnalysisObject object, boolean canBeNull) {
        assert (object.type().isArray() || object.type().isInstanceClass() && !Modifier.isAbstract(object.type().getModifiers())) : object.type();
        return new SingleTypeState(bb, canBeNull, bb.analysisPolicy().makePoperties(bb, object), object);
    }

    public static TypeState forExactTypes(BigBang bb, BitSet exactTypes, boolean canBeNull) {
        int numTypes = exactTypes.cardinality();
        if (numTypes == 0) {
            return TypeState.forEmpty().forCanBeNull(bb, canBeNull);
        }
        if (numTypes == 1) {
            AnalysisType type = bb.getUniverse().getType(exactTypes.nextSetBit(0));
            AnalysisObject analysisObject = type.getContextInsensitiveAnalysisObject();
            return new SingleTypeState(bb, canBeNull, bb.analysisPolicy().makePoperties(bb, analysisObject), analysisObject);
        }
        AnalysisObject[] objectsArray = new AnalysisObject[numTypes];
        int idx = 0;
        int id = exactTypes.nextSetBit(0);
        while (id >= 0) {
            objectsArray[idx] = bb.getUniverse().getType(id).getContextInsensitiveAnalysisObject();
            ++idx;
            id = exactTypes.nextSetBit(id + 1);
        }
        assert (idx == objectsArray.length);
        BitSet typesBitSet = (BitSet)exactTypes.clone();
        int properties = bb.analysisPolicy().makePoperties(bb, objectsArray);
        return new MultiTypeState(bb, canBeNull, properties, typesBitSet, objectsArray);
    }

    public static TypeState forContextInsensitiveTypeState(BigBang bb, TypeState state) {
        if (!((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(bb.getOptions())).booleanValue() || state.isEmpty() || state.isNull()) {
            return state;
        }
        if (state.isSingleTypeState()) {
            AnalysisType type = state.exactType();
            AnalysisObject analysisObject = type.getContextInsensitiveAnalysisObject();
            return new SingleTypeState(bb, state.canBeNull(), bb.analysisPolicy().makePoperties(bb, analysisObject), analysisObject);
        }
        MultiTypeState multiState = (MultiTypeState)state;
        AnalysisObject[] objectsArray = new AnalysisObject[multiState.typesCount()];
        int i = 0;
        for (AnalysisType type : multiState.types()) {
            objectsArray[i++] = type.getContextInsensitiveAnalysisObject();
        }
        BitSet typesBitSet = multiState.typesBitSet;
        int properties = bb.analysisPolicy().makePoperties(bb, objectsArray);
        return new MultiTypeState(bb, multiState.canBeNull(), properties, typesBitSet, objectsArray);
    }

    public final TypeState forNonNull(BigBang bb) {
        return this.forCanBeNull(bb, false);
    }

    protected abstract TypeState forCanBeNull(BigBang var1, boolean var2);

    public static TypeState forUnion(BigBang bb, TypeState s1, TypeState s2) {
        if (s1.isEmpty()) {
            return s2;
        }
        if (s1.isNull()) {
            return s2.forCanBeNull(bb, true);
        }
        if (s2.isEmpty()) {
            return s1;
        }
        if (s2.isNull()) {
            return s1.forCanBeNull(bb, true);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof SingleTypeState) {
            return TypeState.doUnion(bb, (SingleTypeState)s1, (SingleTypeState)s2);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof MultiTypeState) {
            return TypeState.doUnion(bb, (MultiTypeState)s2, (SingleTypeState)s1);
        }
        if (s1 instanceof MultiTypeState && s2 instanceof SingleTypeState) {
            return TypeState.doUnion(bb, (MultiTypeState)s1, (SingleTypeState)s2);
        }
        assert (s1 instanceof MultiTypeState && s2 instanceof MultiTypeState);
        if (s1.objectsCount() >= s2.objectsCount()) {
            return TypeState.doUnion(bb, (MultiTypeState)s1, (MultiTypeState)s2);
        }
        return TypeState.doUnion(bb, (MultiTypeState)s2, (MultiTypeState)s1);
    }

    public static TypeState forIntersection(BigBang bb, TypeState s1, TypeState s2) {
        if (s1.isEmpty()) {
            return s1;
        }
        if (s1.isNull()) {
            return s1.forCanBeNull(bb, s2.canBeNull());
        }
        if (s2.isEmpty()) {
            return s2;
        }
        if (s2.isNull()) {
            return s2.forCanBeNull(bb, s1.canBeNull());
        }
        if (s1 instanceof SingleTypeState && s2 instanceof SingleTypeState) {
            return TypeState.doIntersection(bb, (SingleTypeState)s1, (SingleTypeState)s2);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof MultiTypeState) {
            return TypeState.doIntersection(bb, (SingleTypeState)s1, (MultiTypeState)s2);
        }
        if (s1 instanceof MultiTypeState && s2 instanceof SingleTypeState) {
            return TypeState.doIntersection(bb, (MultiTypeState)s1, (SingleTypeState)s2);
        }
        assert (s1 instanceof MultiTypeState && s2 instanceof MultiTypeState);
        return TypeState.doIntersection(bb, (MultiTypeState)s1, (MultiTypeState)s2);
    }

    public static TypeState forSubtraction(BigBang bb, TypeState s1, TypeState s2) {
        if (s1.isEmpty()) {
            return s1;
        }
        if (s1.isNull()) {
            return s1.forCanBeNull(bb, !s2.canBeNull());
        }
        if (s2.isEmpty()) {
            return s1;
        }
        if (s2.isNull()) {
            return s1.forCanBeNull(bb, false);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof SingleTypeState) {
            return TypeState.doSubtraction(bb, (SingleTypeState)s1, (SingleTypeState)s2);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof MultiTypeState) {
            return TypeState.doSubtraction(bb, (SingleTypeState)s1, (MultiTypeState)s2);
        }
        if (s1 instanceof MultiTypeState && s2 instanceof SingleTypeState) {
            return TypeState.doSubtraction(bb, (MultiTypeState)s1, (SingleTypeState)s2);
        }
        assert (s1 instanceof MultiTypeState && s2 instanceof MultiTypeState);
        return TypeState.doSubtraction(bb, (MultiTypeState)s1, (MultiTypeState)s2);
    }

    private static TypeState doUnion(BigBang bb, SingleTypeState s1, SingleTypeState s2) {
        boolean resultCanBeNull;
        if (s1.equals(s2)) {
            return s1;
        }
        boolean bl = resultCanBeNull = s1.canBeNull() || s2.canBeNull();
        if (s1.exactType().equals(s2.exactType())) {
            Object[] resultObjects = TypeStateUtils.union(bb, s1.objects, s2.objects);
            if (resultObjects == s1.objects) {
                return s1.forCanBeNull(bb, resultCanBeNull);
            }
            if (resultObjects == s2.objects) {
                return s2.forCanBeNull(bb, resultCanBeNull);
            }
            assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || !Arrays.equals(resultObjects, s1.objects) && !Arrays.equals(resultObjects, s2.objects));
            SingleTypeState result = new SingleTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePopertiesForUnion(s1, s2), (AnalysisObject[])resultObjects);
            assert (!s1.equals(result) && !s2.equals(result));
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            return result;
        }
        AnalysisObject[] resultObjects = s1.exactType().getId() < s2.exactType().getId() ? TypeStateUtils.concat(s1.objects, s2.objects) : TypeStateUtils.concat(s2.objects, s1.objects);
        BitSet typesBitSet = new BitSet();
        typesBitSet.set(s1.exactType().getId());
        typesBitSet.set(s2.exactType().getId());
        int properties = bb.analysisPolicy().makePopertiesForUnion(s1, s2);
        MultiTypeState result = new MultiTypeState(bb, resultCanBeNull, properties, typesBitSet, resultObjects);
        PointsToStats.registerUnionOperation(bb, s1, s2, result);
        return result;
    }

    private static TypeState doUnion(BigBang bb, MultiTypeState s1, SingleTypeState s2) {
        AnalysisObject[] resultObjects;
        boolean resultCanBeNull = s1.canBeNull() || s2.canBeNull();
        AnalysisObject[] so1 = s1.objects;
        AnalysisObject[] so2 = s2.objects;
        if (so2.length == 1 && s1.containsObject(so2[0])) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        if (s1.containsType(s2.exactType())) {
            MultiTypeState.Range typeRange = s1.findTypeRange(s2.exactType());
            Object[] s1ObjectsSlice = s1.objectsArray(typeRange);
            Object[] unionObjects = TypeStateUtils.union(bb, (AnalysisObject[])s1ObjectsSlice, so2);
            if (unionObjects == s1ObjectsSlice) {
                return s1.forCanBeNull(bb, resultCanBeNull);
            }
            assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || !Arrays.equals(unionObjects, s1ObjectsSlice));
            int resultSize = so1.length + unionObjects.length - s1ObjectsSlice.length;
            AnalysisObject[] resultObjects2 = new AnalysisObject[resultSize];
            System.arraycopy(so1, 0, resultObjects2, 0, typeRange.left);
            System.arraycopy(unionObjects, 0, resultObjects2, typeRange.left, unionObjects.length);
            System.arraycopy(so1, typeRange.right, resultObjects2, typeRange.left + unionObjects.length, so1.length - typeRange.right);
            int properties = bb.analysisPolicy().makePopertiesForUnion(s1, s2);
            MultiTypeState result = new MultiTypeState(bb, resultCanBeNull, properties, s1.typesBitSet, resultObjects2);
            assert (!result.equals(s1));
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            return result;
        }
        if (s2.exactType().getId() < s1.firstType().getId()) {
            resultObjects = TypeStateUtils.concat(so2, so1);
        } else if (s2.exactType().getId() > s1.lastType().getId()) {
            resultObjects = TypeStateUtils.concat(so1, so2);
        } else {
            int idx1;
            for (idx1 = 0; idx1 < so1.length && so1[idx1].getTypeId() < s2.exactType().getId(); ++idx1) {
            }
            resultObjects = new AnalysisObject[so1.length + so2.length];
            System.arraycopy(so1, 0, resultObjects, 0, idx1);
            System.arraycopy(so2, 0, resultObjects, idx1, so2.length);
            System.arraycopy(so1, idx1, resultObjects, idx1 + so2.length, so1.length - idx1);
        }
        BitSet typesBitSet = TypeStateUtils.set(s1.typesBitSet, s2.exactType().getId());
        int properties = bb.analysisPolicy().makePopertiesForUnion(s1, s2);
        MultiTypeState result = new MultiTypeState(bb, resultCanBeNull, properties, typesBitSet, resultObjects);
        PointsToStats.registerUnionOperation(bb, s1, s2, result);
        return result;
    }

    private static TypeState doUnion(BigBang bb, MultiTypeState s1, MultiTypeState s2) {
        boolean resultCanBeNull;
        assert (s1.objectsCount() >= s2.objectsCount()) : "Union is commutative, must call it with s1 being the bigger state";
        boolean bl = resultCanBeNull = s1.canBeNull() || s2.canBeNull();
        if (s1.objects == s2.objects) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.doUnion0(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doUnion0(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull) {
        if (s1.lastType().getId() < s2.firstType().getId()) {
            AnalysisObject[] resultObjects = TypeStateUtils.concat(s1.objects, s2.objects);
            BitSet resultTypesBitSet = TypeStateUtils.or(s1.typesBitSet, s2.typesBitSet);
            int properties = bb.analysisPolicy().makePopertiesForUnion(s1, s2);
            MultiTypeState result = new MultiTypeState(bb, resultCanBeNull, properties, resultTypesBitSet, resultObjects);
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            return result;
        }
        if (s2.lastType().getId() < s1.firstType().getId()) {
            AnalysisObject[] resultObjects = TypeStateUtils.concat(s2.objects, s1.objects);
            BitSet resultTypesBitSet = TypeStateUtils.or(s1.typesBitSet, s2.typesBitSet);
            int properties = bb.analysisPolicy().makePopertiesForUnion(s1, s2);
            MultiTypeState result = new MultiTypeState(bb, resultCanBeNull, properties, resultTypesBitSet, resultObjects);
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            return result;
        }
        return TypeState.doUnion1(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doUnion1(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull) {
        if (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(bb.getOptions())).booleanValue()) {
            return TypeState.allocationSensitiveSpeculativeUnion1(bb, s1, s2, resultCanBeNull);
        }
        return TypeState.allocationInsensitiveSpeculativeUnion1(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState allocationInsensitiveSpeculativeUnion1(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull) {
        if (s1.typesBitSet.length() >= s2.typesBitSet.length()) {
            long[] bits1 = TypeStateUtils.extractBitSetField(s1.typesBitSet);
            long[] bits2 = TypeStateUtils.extractBitSetField(s2.typesBitSet);
            assert (s2.typesBitSet.cardinality() == s2.objects.length) : "Cardinality and length of objects must match.";
            boolean speculate = true;
            int numberOfWords = Math.min(bits1.length, bits2.length);
            for (int i = 0; i < numberOfWords; ++i) {
                if ((bits1[i] & bits2[i]) == bits2[i]) continue;
                speculate = false;
                break;
            }
            if (speculate) {
                return s1.forCanBeNull(bb, resultCanBeNull);
            }
        }
        return TypeState.doUnion2(bb, s1, s2, resultCanBeNull, 0, 0);
    }

    private static TypeState allocationSensitiveSpeculativeUnion1(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull) {
        int idx1 = 0;
        int idx2 = 0;
        AnalysisPolicy analysisPolicy = bb.analysisPolicy();
        AnalysisObject[] so1 = s1.objects;
        AnalysisObject[] so2 = s2.objects;
        while (idx1 < so1.length && idx2 < so2.length) {
            AnalysisObject o1 = so1[idx1];
            AnalysisObject o2 = so2[idx2];
            if (analysisPolicy.isSummaryObject(o1) && o1.getTypeId() == o2.getTypeId()) {
                ++idx1;
                while (idx2 < s2.objectsCount() && so2[idx2].getTypeId() == o1.getTypeId()) {
                    analysisPolicy.noteMerge(bb, so2[idx2]);
                    ++idx2;
                }
            } else if (o1.getId() < o2.getId()) {
                ++idx1;
            } else {
                if (o1.getId() != o2.getId()) break;
                ++idx1;
                ++idx2;
            }
            if (idx2 != so2.length) continue;
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.doUnion2(bb, s1, s2, resultCanBeNull, idx1, idx2);
    }

    private static TypeState doUnion2(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull, int startId1, int startId2) {
        try (UnsafeArrayListClosable<AnalysisObject> resultObjectsClosable = TypeState.getTLArrayList(doUnion2TL, s1.objects.length + s2.objects.length);){
            TypeState typeState;
            UnsafeArrayList resultObjects = ((UnsafeArrayListClosable)resultObjectsClosable).list;
            AnalysisObject[] objects = s1.objects;
            resultObjects.addAll(objects, 0, startId1);
            int idx1 = startId1;
            int idx2 = startId2;
            try (UnsafeArrayListClosable<AnalysisObject> tlUnionObjectsClosable = TypeState.getTLArrayList(doUnion2ObjectsTL, s1.objects.length + s2.objects.length);){
                UnsafeArrayList unionObjects = ((UnsafeArrayListClosable)tlUnionObjectsClosable).list;
                AnalysisObject[] so1 = s1.objects;
                AnalysisObject[] so2 = s2.objects;
                AnalysisPolicy analysisPolicy = bb.analysisPolicy();
                while (idx1 < so1.length && idx2 < so2.length) {
                    AnalysisObject o1 = so1[idx1];
                    AnalysisObject o2 = so2[idx2];
                    int t1 = o1.getTypeId();
                    int t2 = o2.getTypeId();
                    if (analysisPolicy.isSummaryObject(o1) && t1 == t2) {
                        unionObjects.add(o1);
                        while (idx2 < so2.length && t1 == so2[idx2].getTypeId()) {
                            analysisPolicy.noteMerge(bb, so2[idx2]);
                            ++idx2;
                        }
                        ++idx1;
                        continue;
                    }
                    if (analysisPolicy.isSummaryObject(o2) && t1 == t2) {
                        unionObjects.add(o2);
                        while (idx1 < so1.length && so1[idx1].getTypeId() == t2) {
                            analysisPolicy.noteMerge(bb, so1[idx1]);
                            ++idx1;
                        }
                        ++idx2;
                        continue;
                    }
                    if (o1.getId() < o2.getId()) {
                        unionObjects.add(o1);
                        ++idx1;
                        continue;
                    }
                    if (o1.getId() > o2.getId()) {
                        unionObjects.add(o2);
                        ++idx2;
                        continue;
                    }
                    assert (o1.equals(o2));
                    unionObjects.add(o1);
                    ++idx1;
                    ++idx2;
                }
                if (((Boolean)PointstoOptions.LimitObjectArrayLength.getValue(bb.getOptions())).booleanValue() && unionObjects.size() > (Integer)PointstoOptions.MaxObjectSetSize.getValue(bb.getOptions())) {
                    int idxStart = 0;
                    int idxEnd = 0;
                    while (idxEnd < unionObjects.size()) {
                        AnalysisObject oStart = (AnalysisObject)unionObjects.get(idxStart);
                        while (idxEnd < unionObjects.size() && oStart.equals(unionObjects.get(idxEnd))) {
                            ++idxEnd;
                        }
                        int size = idxEnd - idxStart;
                        if (size > (Integer)PointstoOptions.MaxObjectSetSize.getValue(bb.getOptions())) {
                            for (int i = idxStart; i < idxEnd; ++i) {
                                bb.analysisPolicy().noteMerge(bb, (AnalysisObject)unionObjects.get(i));
                            }
                            resultObjects.add(oStart.type().getContextInsensitiveAnalysisObject());
                        } else {
                            resultObjects.addAll(unionObjects.elementData, idxStart, idxEnd);
                        }
                        idxStart = idxEnd;
                    }
                } else {
                    resultObjects.addAll(unionObjects.elementData, 0, unionObjects.size);
                }
            }
            if (idx1 < s1.objects.length) {
                resultObjects.addAll(s1.objects, idx1, s1.objects.length);
            } else if (idx2 < s2.objects.length) {
                resultObjects.addAll(s2.objects, idx2, s2.objects.length);
            }
            assert (resultObjects.size() > 1) : "The result state of a (Multi U Multi) operation must have at least 2 objects";
            BitSet resultTypesBitSet = TypeStateUtils.or(s1.typesBitSet, s2.typesBitSet);
            int properties = bb.analysisPolicy().makePopertiesForUnion(s1, s2);
            MultiTypeState result = new MultiTypeState(bb, resultCanBeNull, properties, resultTypesBitSet, resultObjects.copyToArray(new AnalysisObject[resultObjects.size()]));
            assert (!result.equals(s1)) : "speculation code should prevent this case";
            if (s1.typesCount() == s2.typesCount() && result.equals(s2)) {
                typeState = s2.forCanBeNull(bb, resultCanBeNull);
                return typeState;
            }
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            typeState = result;
            return typeState;
        }
    }

    private static TypeState doIntersection(BigBang bb, SingleTypeState s1, SingleTypeState s2) {
        boolean resultCanBeNull;
        assert (s2.objects.length == 1 && s2.objects[0].isContextInsensitiveObject()) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && s2.canBeNull();
        if (s1.exactType().equals(s2.exactType())) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        TypeState result = TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        return result;
    }

    private static TypeState doIntersection(BigBang bb, SingleTypeState s1, MultiTypeState s2) {
        boolean resultCanBeNull;
        assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || TypeStateUtils.isContextInsensitiveTypeState(s2)) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && s2.canBeNull();
        if (s2.containsType(s1.exactType())) {
            AnalysisObject[] s2Objects = s2.objectsArray(s1.exactType());
            assert (s2Objects.length == 1 && s2Objects[0].isContextInsensitiveObject()) : "Current implementation limitation.";
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
    }

    private static TypeState doIntersection(BigBang bb, MultiTypeState s1, SingleTypeState s2) {
        boolean resultCanBeNull;
        assert (s2.objects.length == 1 && s2.objects[0].isContextInsensitiveObject()) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && s2.canBeNull();
        if (s1.containsType(s2.exactType())) {
            AnalysisObject[] resultObjects = s1.objectsArray(s2.exactType());
            assert (TypeStateUtils.holdsSingleTypeState(resultObjects));
            return new SingleTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePoperties(bb, resultObjects), resultObjects);
        }
        return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
    }

    private static TypeState doIntersection(BigBang bb, MultiTypeState s1, MultiTypeState s2) {
        boolean resultCanBeNull;
        assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || TypeStateUtils.isContextInsensitiveTypeState(s2)) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && s2.canBeNull();
        if (s1.objects == s2.objects) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.doIntersection0(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doIntersection0(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull) {
        if (s1.typesBitSet.equals(s2.typesBitSet)) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        if (!s1.typesBitSet.intersects(s2.typesBitSet)) {
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.doIntersection1(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doIntersection1(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull) {
        int idx1 = 0;
        int idx2 = 0;
        AnalysisObject[] so1 = s1.objects;
        AnalysisObject[] so2 = s2.objects;
        while (idx2 < so2.length) {
            AnalysisObject o1 = so1[idx1];
            AnalysisObject o2 = so2[idx2];
            assert (o2.isContextInsensitiveObject()) : "Current implementation limitation.";
            if (o1.getTypeId() > o2.getTypeId()) {
                ++idx2;
            } else {
                if (o1.getTypeId() != o2.getTypeId()) break;
                while (idx1 < so1.length && so1[idx1].getTypeId() == o2.getTypeId()) {
                    ++idx1;
                }
                ++idx2;
            }
            if (idx1 != so1.length) continue;
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.doIntersection2(bb, s1, s2, resultCanBeNull, idx1, idx2);
    }

    private static TypeState doIntersection2(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull, int idx1Param, int idx2Param) {
        try (UnsafeArrayListClosable<AnalysisObject> tlArrayClosable = TypeState.getTLArrayList(intersectionArrayListTL, 256);){
            UnsafeArrayList resultObjects = ((UnsafeArrayListClosable)tlArrayClosable).list;
            AnalysisObject[] so1 = s1.objects;
            AnalysisObject[] so2 = s2.objects;
            int[] types1 = s1.getObjectTypeIds();
            int[] types2 = s2.getObjectTypeIds();
            int idx1 = idx1Param;
            int idx2 = idx2Param;
            int l1 = so1.length;
            int l2 = so2.length;
            int t1 = types1[idx1];
            int t2 = types2[idx2];
            while (idx1 < l1 && idx2 < l2) {
                assert (so2[idx2].isContextInsensitiveObject()) : "Current implementation limitation.";
                if (t1 == t2) {
                    assert (so1[idx1].type().equals(so2[idx2].type()));
                    resultObjects.add(so1[idx1]);
                    t1 = types1[++idx1];
                    continue;
                }
                if (t1 < t2) {
                    t1 = types1[++idx1];
                    continue;
                }
                if (t1 <= t2) continue;
                t2 = types2[++idx2];
            }
            int totalLength = idx1Param + resultObjects.size();
            if (totalLength == 0) {
                TypeState typeState = TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
                return typeState;
            }
            AnalysisObject[] objects = new AnalysisObject[totalLength];
            resultObjects.copyToArray(objects, idx1Param);
            System.arraycopy(s1.objects, 0, objects, 0, idx1Param);
            if (TypeStateUtils.holdsSingleTypeState(objects, objects.length)) {
                SingleTypeState singleTypeState = new SingleTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePoperties(bb, objects), objects);
                return singleTypeState;
            }
            BitSet resultTypesBitSet = TypeStateUtils.and(s1.typesBitSet, s2.typesBitSet);
            MultiTypeState result = new MultiTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePoperties(bb, objects), resultTypesBitSet, objects);
            if (s1.typesCount() == s2.typesCount() && result.equals(s1)) {
                TypeState typeState = s1.forCanBeNull(bb, resultCanBeNull);
                return typeState;
            }
            MultiTypeState multiTypeState = result;
            return multiTypeState;
        }
    }

    private static UnsafeArrayListClosable<AnalysisObject> getTLArrayList(ThreadLocal<UnsafeArrayListClosable<AnalysisObject>> tl, int initialCapacity) {
        UnsafeArrayListClosable<AnalysisObject> result = tl.get();
        if (result == null) {
            result = new UnsafeArrayListClosable(new UnsafeArrayList<AnalysisObject>(new AnalysisObject[initialCapacity]));
            tl.set(result);
        }
        if (((UnsafeArrayListClosable)result).closed) {
            ((UnsafeArrayListClosable)result).closed = false;
            return result;
        }
        return new UnsafeArrayListClosable<AnalysisObject>(new UnsafeArrayList<AnalysisObject>(new AnalysisObject[initialCapacity]));
    }

    private static TypeState doSubtraction(BigBang bb, SingleTypeState s1, SingleTypeState s2) {
        boolean resultCanBeNull;
        boolean bl = resultCanBeNull = s1.canBeNull() && !s2.canBeNull();
        if (s1.exactType().equals(s2.exactType())) {
            assert (s2.objects.length == 1 && s2.objects[0].isContextInsensitiveObject()) : "Current implementation limitation.";
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        return s1.forCanBeNull(bb, resultCanBeNull);
    }

    private static TypeState doSubtraction(BigBang bb, SingleTypeState s1, MultiTypeState s2) {
        boolean resultCanBeNull;
        boolean bl = resultCanBeNull = s1.canBeNull() && !s2.canBeNull();
        if (s2.containsType(s1.exactType())) {
            AnalysisObject[] array = s2.objectsArray(s1.exactType());
            assert (array.length == 1 && array[0].isContextInsensitiveObject()) : "Current implementation limitation.";
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        return s1.forCanBeNull(bb, resultCanBeNull);
    }

    private static TypeState doSubtraction(BigBang bb, MultiTypeState s1, SingleTypeState s2) {
        boolean resultCanBeNull;
        boolean bl = resultCanBeNull = s1.canBeNull() && !s2.canBeNull();
        if (s1.containsType(s2.exactType())) {
            assert (s2.objects.length == 1 && s2.objects[0].isContextInsensitiveObject()) : "Current implementation limitation.";
            MultiTypeState.Range typeRange = s1.findTypeRange(s2.exactType());
            int newLength = s1.objects.length - (typeRange.right - typeRange.left);
            AnalysisObject[] resultObjects = new AnalysisObject[newLength];
            System.arraycopy(s1.objects, 0, resultObjects, 0, typeRange.left);
            System.arraycopy(s1.objects, typeRange.right, resultObjects, typeRange.left, s1.objects.length - typeRange.right);
            if (resultObjects.length == 1) {
                return new SingleTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePoperties(bb, resultObjects[0]), resultObjects[0]);
            }
            if (TypeStateUtils.holdsSingleTypeState(resultObjects)) {
                return new SingleTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePoperties(bb, resultObjects), resultObjects);
            }
            BitSet resultTypesBitSet = TypeStateUtils.clear(s1.typesBitSet, s2.exactType().getId());
            return new MultiTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePoperties(bb, resultObjects), resultTypesBitSet, resultObjects);
        }
        return s1.forCanBeNull(bb, resultCanBeNull);
    }

    private static TypeState doSubtraction(BigBang bb, MultiTypeState s1, MultiTypeState s2) {
        boolean resultCanBeNull;
        boolean bl = resultCanBeNull = s1.canBeNull() && !s2.canBeNull();
        if (s1.objects == s2.objects) {
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.doSubtraction0(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doSubtraction0(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull) {
        if (s1.typesBitSet.equals(s2.typesBitSet)) {
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        if (!s1.typesBitSet.intersects(s2.typesBitSet)) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.doSubtraction1(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doSubtraction1(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull) {
        int idx2;
        int idx1;
        block3: {
            idx1 = 0;
            idx2 = 0;
            AnalysisObject[] so1 = s1.objects;
            AnalysisObject[] so2 = s2.objects;
            while (true) {
                AnalysisObject o1 = so1[idx1];
                AnalysisObject o2 = so2[idx2];
                assert (o2.isContextInsensitiveObject()) : "Current implementation limitation.";
                if (o1.getTypeId() < o2.getTypeId()) {
                    if (++idx1 != so1.length) continue;
                    return s1.forCanBeNull(bb, resultCanBeNull);
                }
                if (o1.getTypeId() <= o2.getTypeId()) break block3;
                if (++idx2 == so2.length) break;
            }
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.doSubtraction2(bb, s1, s2, resultCanBeNull, idx1, idx2);
    }

    private static TypeState doSubtraction2(BigBang bb, MultiTypeState s1, MultiTypeState s2, boolean resultCanBeNull, int idx1Param, int idx2Param) {
        try (UnsafeArrayListClosable<AnalysisObject> tlArrayClosable = TypeState.getTLArrayList(intersectionArrayListTL, 256);){
            UnsafeArrayList resultObjects = ((UnsafeArrayListClosable)tlArrayClosable).list;
            AnalysisObject[] so1 = s1.objects;
            AnalysisObject[] so2 = s2.objects;
            int[] types1 = s1.getObjectTypeIds();
            int[] types2 = s2.getObjectTypeIds();
            int idx1 = idx1Param;
            int idx2 = idx2Param;
            int l1 = so1.length;
            int l2 = so2.length;
            int t1 = types1[idx1];
            int t2 = types2[idx2];
            while (idx1 < l1 && idx2 < l2) {
                assert (so2[idx2].isContextInsensitiveObject()) : "Current implementation limitation.";
                if (t1 < t2) {
                    resultObjects.add(so1[idx1]);
                    t1 = types1[++idx1];
                    continue;
                }
                if (t1 > t2) {
                    t2 = types2[++idx2];
                    continue;
                }
                if (t1 != t2) continue;
                assert (so1[idx1].type().equals(so2[idx2].type()));
                t1 = types1[++idx1];
            }
            int remainder = s1.objects.length - idx1;
            int totalLength = idx1Param + resultObjects.size + remainder;
            if (totalLength == 0) {
                TypeState typeState = TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
                return typeState;
            }
            AnalysisObject[] objects = new AnalysisObject[totalLength];
            resultObjects.copyToArray(objects, idx1Param);
            System.arraycopy(s1.objects, 0, objects, 0, idx1Param);
            System.arraycopy(s1.objects, idx1, objects, totalLength - remainder, remainder);
            if (TypeStateUtils.holdsSingleTypeState(objects, totalLength)) {
                SingleTypeState singleTypeState = new SingleTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePoperties(bb, objects), objects);
                return singleTypeState;
            }
            BitSet resultTypesBitSet = TypeStateUtils.andNot(s1.typesBitSet, s2.typesBitSet);
            MultiTypeState multiTypeState = new MultiTypeState(bb, resultCanBeNull, bb.analysisPolicy().makePoperties(bb, objects), resultTypesBitSet, objects);
            return multiTypeState;
        }
    }

    private static final class UnsafeArrayListClosable<E>
    implements AutoCloseable {
        private UnsafeArrayList<E> list;
        private boolean closed = true;

        private UnsafeArrayListClosable(UnsafeArrayList<E> list) {
            this.list = list;
        }

        @Override
        public void close() {
            this.list.clear();
            this.closed = true;
        }
    }

    private static class UnsafeArrayList<E> {
        static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
        E[] elementData;
        int size;

        UnsafeArrayList(E[] initial) {
            this.elementData = initial;
        }

        <T> T[] copyToArray(T[] a) {
            System.arraycopy(this.elementData, 0, a, 0, this.size);
            return a;
        }

        <T> T[] copyToArray(T[] a, int dstPos) {
            System.arraycopy(this.elementData, 0, a, dstPos, this.size);
            return a;
        }

        public <E1 extends E> void addAll(E1[] c, int startIndex, int endIndex) {
            assert (startIndex <= endIndex) : "start index can't be smaller than the end index.";
            int newElements = endIndex - startIndex;
            this.ensureCapacity(this.size() + newElements);
            System.arraycopy(c, startIndex, this.elementData, this.size, newElements);
            this.size += newElements;
        }

        private int size() {
            return this.size;
        }

        public void add(E e) {
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size] = e;
            ++this.size;
        }

        public void clear() {
            for (int i = 0; i < this.size; ++i) {
                this.elementData[i] = null;
            }
            this.size = 0;
        }

        public E get(int i) {
            assert (i < this.size && i >= 0);
            return this.elementData[i];
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity - this.elementData.length > 0) {
                this.grow(minCapacity);
            }
        }

        private void grow(int minCapacity) {
            int oldCapacity = this.elementData.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                if (minCapacity < 0) {
                    throw new OutOfMemoryError();
                }
                newCapacity = minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
            }
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        }
    }

    public static class TypesObjectsIterator {
        private final TypeState state;
        private int typeIdx = 0;
        private int objectIdx = 0;

        public TypesObjectsIterator(TypeState state) {
            this.state = state;
        }

        public boolean hasNextType() {
            return this.typeIdx < this.state.typesCount();
        }

        public boolean hasNextObject(AnalysisType type) {
            return this.objectIdx < this.state.objects().length && this.state.objects()[this.objectIdx].getTypeId() == type.getId();
        }

        public AnalysisType nextType() {
            assert (this.hasNextType());
            ++this.typeIdx;
            return this.state.objects()[this.objectIdx].type();
        }

        public AnalysisObject nextObject(AnalysisType type) {
            assert (this.hasNextObject(type));
            return this.state.objects()[this.objectIdx++];
        }
    }
}

