/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.code.BytecodePosition;

abstract class DirectInvokeTypeFlow
extends InvokeTypeFlow {
    public MethodTypeFlow callee;
    protected AnalysisContext callerContext;

    protected DirectInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, AnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
        this.callerContext = null;
    }

    protected DirectInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, DirectInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.callerContext = methodFlows.context();
    }

    @Override
    public final boolean isDirectInvoke() {
        return true;
    }

    @Override
    public Collection<AnalysisMethod> getCallees() {
        if (this.callee != null && this.callee.getMethod().isImplementationInvoked()) {
            return Collections.singletonList(this.callee.getMethod());
        }
        return Collections.emptyList();
    }
}

