/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.DirectInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;

final class StaticInvokeTypeFlow
extends DirectInvokeTypeFlow {
    private AnalysisContext calleeContext;

    protected StaticInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, AnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
        this.calleeContext = null;
    }

    protected StaticInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, StaticInvokeTypeFlow original) {
        super(bb, methodFlows, original);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new StaticInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    public void update(PointsToAnalysis bb) {
        assert (this.isClone());
        JVMCIError.guarantee((this.callee == null ? 1 : 0) != 0, (String)"static invoke updated multiple times!", (Object[])new Object[0]);
        if (!this.targetMethod.getWrapped().getDeclaringClass().isLinked()) {
            return;
        }
        ((DirectInvokeTypeFlow)this.originalInvoke).callee = this.callee = this.targetMethod.getTypeFlow();
        this.calleeContext = bb.contextPolicy().staticCalleeContext(bb, this.location, this.callerContext, this.callee);
        MethodFlowsGraph calleeFlows = this.callee.addContext(bb, this.calleeContext, this);
        this.linkCallee(bb, true, calleeFlows);
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
        if (this.callee == null || this.calleeContext == null) {
            return Collections.emptyList();
        }
        assert (this.calleeContext != null);
        MethodFlowsGraph methodFlows = this.callee.getFlows(this.calleeContext);
        return Collections.singletonList(methodFlows);
    }

    @Override
    public String toString() {
        return "StaticInvoke<" + this.targetMethod.format("%h.%n") + ">:" + this.getState();
    }
}

