/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.AnalysisReportsOptions;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.function.Consumer;

public final class StatisticsPrinter {
    private final BigBang bb;
    static final String INDENT = "   ";

    public static void print(BigBang bb, String reportsPath, String reportName) {
        StatisticsPrinter printer = new StatisticsPrinter(bb);
        Consumer<PrintWriter> consumer = printer::printStats;
        String description = "analysis results stats";
        if (AnalysisReportsOptions.AnalysisStatisticsFile.hasBeenSet(bb.getOptions())) {
            File file = new File((String)AnalysisReportsOptions.AnalysisStatisticsFile.getValue(bb.getOptions())).getAbsoluteFile();
            ReportUtils.report(description, file.toPath(), consumer);
        } else {
            ReportUtils.report(description, reportsPath, "analysis_stats_" + reportName, "json", consumer);
        }
    }

    public StatisticsPrinter(BigBang bb) {
        this.bb = bb;
    }

    private void printStats(PrintWriter out) {
        int[] reachableTypes = StatisticsPrinter.getNumReachableTypes(this.bb);
        int[] reachableMethods = StatisticsPrinter.getNumReachableMethods(this.bb);
        int[] reachableFields = StatisticsPrinter.getNumReachableFields(this.bb);
        long[] typeChecksStats = StatisticsPrinter.getTypeCheckStats(this.bb);
        StatisticsPrinter.beginObject(out);
        StatisticsPrinter.print(out, "total_reachable_types", reachableTypes[0]);
        StatisticsPrinter.print(out, "app_reachable_types", reachableTypes[1]);
        StatisticsPrinter.print(out, "total_reachable_methods", reachableMethods[0]);
        StatisticsPrinter.print(out, "app_reachable_methods", reachableMethods[1]);
        StatisticsPrinter.print(out, "total_reachable_fields", reachableFields[0]);
        StatisticsPrinter.print(out, "app_reachable_fields", reachableFields[1]);
        StatisticsPrinter.print(out, "total_type_checks", typeChecksStats[0]);
        StatisticsPrinter.print(out, "total_removable_type_checks", typeChecksStats[1]);
        StatisticsPrinter.print(out, "app_type_checks", typeChecksStats[2]);
        StatisticsPrinter.print(out, "app_removable_type_checks", typeChecksStats[3]);
        this.bb.printTimerStatistics(out);
        StatisticsPrinter.endObject(out);
    }

    private static PrintWriter endObject(PrintWriter out) {
        return out.format("}%n", new Object[0]);
    }

    private static PrintWriter beginObject(PrintWriter out) {
        return out.format("{%n", new Object[0]);
    }

    public static void print(PrintWriter out, String key, long value) {
        out.format("%s\"%s\": %d,%n", INDENT, key, value);
    }

    public static void print(PrintWriter out, String key, double value) {
        out.format("%s\"%s\": %.2f,%n", INDENT, key, value);
    }

    public static void printLast(PrintWriter out, String key, long value) {
        out.format("%s\"%s\": %d%n", INDENT, key, value);
    }

    private static int[] getNumReachableTypes(BigBang bb) {
        int reachable = 0;
        int appReachable = 0;
        for (AnalysisType type : bb.getUniverse().getTypes()) {
            if (!type.isInstantiated()) continue;
            ++reachable;
            if (StatisticsPrinter.isRuntimeLibraryType(type)) continue;
            ++appReachable;
        }
        return new int[]{reachable, appReachable};
    }

    private static int[] getNumReachableMethods(BigBang bb) {
        int reachable = 0;
        int appReachable = 0;
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            if (!method.isReachable()) continue;
            ++reachable;
            if (StatisticsPrinter.isRuntimeLibraryType(method.getDeclaringClass())) continue;
            ++appReachable;
        }
        return new int[]{reachable, appReachable};
    }

    private static int[] getNumReachableFields(BigBang bb) {
        int reachable = 0;
        int appReachable = 0;
        for (AnalysisField field : bb.getUniverse().getFields()) {
            if (!field.isAccessed()) continue;
            ++reachable;
            if (StatisticsPrinter.isRuntimeLibraryType(field.getDeclaringClass())) continue;
            ++appReachable;
        }
        return new int[]{reachable, appReachable};
    }

    private static long[] getTypeCheckStats(BigBang bb) {
        if (!(bb instanceof PointsToAnalysis)) {
            return new long[4];
        }
        PointsToAnalysis pointsToAnalysis = (PointsToAnalysis)bb;
        long totalFilters = 0L;
        long totalRemovableFilters = 0L;
        long appTotalFilters = 0L;
        long appTotalRemovableFilters = 0L;
        for (AnalysisMethod method : pointsToAnalysis.getUniverse().getMethods()) {
            boolean runtimeMethod = StatisticsPrinter.isRuntimeLibraryType(method.getDeclaringClass());
            MethodTypeFlow methodFlow = method.getTypeFlow();
            MethodFlowsGraph originalFlows = methodFlow.getOriginalMethodFlows();
            for (Map.Entry<Object, InstanceOfTypeFlow> entry : originalFlows.getInstanceOfFlows()) {
                if (!BytecodeLocation.isValidBci(entry.getKey())) continue;
                ++totalFilters;
                InstanceOfTypeFlow originalInstanceOf = entry.getValue();
                boolean isSaturated = methodFlow.isSaturated(pointsToAnalysis, originalInstanceOf);
                TypeState instanceOfTypeState = methodFlow.foldTypeFlow(pointsToAnalysis, originalInstanceOf);
                if (!isSaturated && instanceOfTypeState.typesCount() < 2) {
                    ++totalRemovableFilters;
                }
                if (runtimeMethod) continue;
                ++appTotalFilters;
                if (isSaturated || instanceOfTypeState.typesCount() >= 2) continue;
                ++appTotalRemovableFilters;
            }
        }
        return new long[]{totalFilters, totalRemovableFilters, appTotalFilters, appTotalRemovableFilters};
    }

    public static boolean isRuntimeLibraryType(AnalysisType type) {
        String name = type.getName();
        return name.startsWith("Ljava/") || name.startsWith("Ljavax/") || name.startsWith("Lsun/") || name.startsWith("Lcom/sun/") || name.startsWith("Lcom/oracle/") || name.startsWith("Lorg/graalvm/") || name.startsWith("Ljdk/");
    }
}

