/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ConstantContextSensitiveObject;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.util.GuardedAnnotationAccess;

public class AnalysisType
implements WrappedJavaType,
OriginalClassProvider,
Comparable<AnalysisType> {
    private static final AtomicReferenceFieldUpdater<AnalysisType, ConcurrentHashMap> UNSAFE_ACCESS_FIELDS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, ConcurrentHashMap.class, "unsafeAccessedFields");
    private static final AtomicReferenceFieldUpdater<AnalysisType, ConstantContextSensitiveObject> UNIQUE_CONSTANT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, ConstantContextSensitiveObject.class, "uniqueConstant");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "interceptors");
    protected final AnalysisUniverse universe;
    private final ResolvedJavaType wrapped;
    private final AtomicBoolean isInHeap = new AtomicBoolean();
    private final AtomicBoolean isAllocated = new AtomicBoolean();
    private final AtomicBoolean isReachable = new AtomicBoolean();
    private boolean reachabilityListenerNotified;
    private boolean unsafeFieldsRecomputed;
    private boolean unsafeAccessedFieldsRegistered;
    private volatile ConcurrentHashMap<UnsafePartitionKind, Collection<AnalysisField>> unsafeAccessedFields;
    private final Set<AnalysisType> subTypes;
    AnalysisType superClass;
    private final int id;
    private final JavaKind storageKind;
    private AnalysisObject contextInsensitiveAnalysisObject;
    private ConcurrentMap<Constant, ConstantContextSensitiveObject> constantObjectsCache;
    private volatile ConstantContextSensitiveObject uniqueConstant;
    private final ConcurrentHashMap<ResolvedJavaMethod, Object> resolvedMethods = new ConcurrentHashMap();
    private static final Object NULL_METHOD = new Object();
    private final AnalysisType componentType;
    private final AnalysisType elementalType;
    private final AnalysisType[] interfaces;
    private final boolean isArray;
    private final int dimension;
    private volatile Object interceptors;
    private final AnalysisFuture<Void> initializationTask;
    public TypeState assignableTypesState = TypeState.forNull();
    public TypeState assignableTypesNonNullState = TypeState.forEmpty();
    public AllInstantiatedTypeFlow instantiatedTypes = new AllInstantiatedTypeFlow(this, true);
    public AllInstantiatedTypeFlow instantiatedTypesNonNull = new AllInstantiatedTypeFlow(this, false);
    private volatile AnalysisType arrayClass = null;
    private volatile AnalysisField[] instanceFieldsWithSuper;
    private volatile AnalysisField[] instanceFieldsWithoutSuper;
    private static final int ANNOTATION = 8192;

    AnalysisType(AnalysisUniverse universe, ResolvedJavaType javaType, JavaKind storageKind, AnalysisType objectType) {
        this.universe = universe;
        this.wrapped = javaType;
        this.isArray = this.wrapped.isArray();
        this.storageKind = storageKind;
        if (universe.analysisPolicy().needsConstantCache()) {
            this.constantObjectsCache = new ConcurrentHashMap<Constant, ConstantContextSensitiveObject>();
        }
        try {
            this.link();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.superClass = universe.lookup((JavaType)this.wrapped.getSuperclass());
        this.interfaces = this.convertTypes(this.wrapped.getInterfaces());
        this.subTypes = ConcurrentHashMap.newKeySet();
        this.addSubType(this);
        if (this.superClass != null) {
            this.superClass.addSubType(this);
        }
        if (this.isInterface() && this.interfaces.length == 0) {
            objectType.addSubType(this);
        }
        for (AnalysisType interf : this.interfaces) {
            interf.addSubType(this);
        }
        if (this.isArray()) {
            this.componentType = universe.lookup((JavaType)this.wrapped.getComponentType());
            int dim = 0;
            AnalysisType elemType = this;
            while (elemType.isArray()) {
                elemType = elemType.getComponentType();
                ++dim;
            }
            if (elemType.getSuperclass() != null) {
                elemType.getSuperclass().getArrayClass(dim);
            }
            this.elementalType = elemType;
            if (dim >= 2) {
                objectType.getArrayClass(dim - 1);
            }
            for (AnalysisType interf : elemType.getInterfaces()) {
                interf.getArrayClass(dim);
            }
            this.dimension = dim;
        } else {
            this.componentType = null;
            this.elementalType = this;
            this.dimension = 0;
        }
        this.id = universe.nextTypeId.getAndIncrement();
        this.contextInsensitiveAnalysisObject = new AnalysisObject(universe, this);
        assert (this.getSuperclass() == null || this.getId() > this.getSuperclass().getId());
        this.initializationTask = new AnalysisFuture<Object>(() -> universe.hostVM.initializeType(this), null);
    }

    private AnalysisType[] convertTypes(ResolvedJavaType[] originalTypes) {
        ArrayList<AnalysisType> result = new ArrayList<AnalysisType>(originalTypes.length);
        for (ResolvedJavaType originalType : originalTypes) {
            if (this.universe.hostVM.skipInterface(this.universe, originalType, this.wrapped)) continue;
            result.add(this.universe.lookup((JavaType)originalType));
        }
        return result.toArray(new AnalysisType[result.size()]);
    }

    public AnalysisType getArrayClass(int dim) {
        AnalysisType result = this;
        for (int i = 0; i < dim; ++i) {
            result = result.getArrayClass();
        }
        return result;
    }

    public void cleanupAfterAnalysis() {
        this.instantiatedTypes = null;
        this.instantiatedTypesNonNull = null;
        this.assignableTypesState = null;
        this.assignableTypesNonNullState = null;
        this.contextInsensitiveAnalysisObject = null;
        this.constantObjectsCache = null;
        this.uniqueConstant = null;
        this.unsafeAccessedFields = null;
    }

    public int getId() {
        return this.id;
    }

    public AnalysisObject getContextInsensitiveAnalysisObject() {
        return this.contextInsensitiveAnalysisObject;
    }

    public AnalysisObject getUniqueConstantObject() {
        return this.uniqueConstant;
    }

    public AnalysisObject getCachedConstantObject(PointsToAnalysis bb, JavaConstant constant) {
        assert (bb.analysisPolicy().needsConstantCache()) : "The analysis policy doesn't specify the need for a constants cache.";
        assert (bb.trackConcreteAnalysisObjects(this));
        assert (!(constant instanceof PrimitiveConstant)) : "The analysis should not model PrimitiveConstant.";
        if (this.uniqueConstant != null) {
            return this.uniqueConstant;
        }
        if (this.constantObjectsCache.size() >= (Integer)PointstoOptions.MaxConstantObjectsPerType.getValue(bb.getOptions())) {
            this.mergeConstantObjects(bb);
            return this.uniqueConstant;
        }
        AnalysisObject result = (AnalysisObject)this.constantObjectsCache.get(constant);
        if (result == null) {
            ConstantContextSensitiveObject newValue = new ConstantContextSensitiveObject(bb, this, constant);
            ConstantContextSensitiveObject oldValue = this.constantObjectsCache.putIfAbsent((Constant)constant, newValue);
            AnalysisObject analysisObject = result = oldValue != null ? oldValue : newValue;
            if (((Boolean)PointstoOptions.ProfileConstantObjects.getValue(bb.getOptions())).booleanValue()) {
                PointsToAnalysis.ConstantObjectsProfiler.registerConstant(this);
                PointsToAnalysis.ConstantObjectsProfiler.maybeDumpConstantHistogram();
            }
        }
        return result;
    }

    private void mergeConstantObjects(PointsToAnalysis bb) {
        ConstantContextSensitiveObject uConstant = new ConstantContextSensitiveObject(bb, this, null);
        if (UNIQUE_CONSTANT_UPDATER.compareAndSet(this, null, uConstant)) {
            this.constantObjectsCache.values().stream().forEach(constantObject -> {
                constantObject.setMergedWithUniqueConstantObject();
                constantObject.mergeInstanceFieldsFlows(bb, this.uniqueConstant);
            });
        }
    }

    public AllInstantiatedTypeFlow getTypeFlow(BigBang bb, boolean includeNull) {
        if (includeNull) {
            return this.instantiatedTypes;
        }
        return this.instantiatedTypesNonNull;
    }

    public TypeState getAssignableTypes(boolean includeNull) {
        if (includeNull) {
            return this.assignableTypesState;
        }
        return this.assignableTypesNonNullState;
    }

    public static boolean verifyAssignableTypes(BigBang bb) {
        List<AnalysisType> allTypes = bb.getUniverse().getTypes();
        ConcurrentHashMap.KeySetView mismatchedAssignableResults = ConcurrentHashMap.newKeySet();
        allTypes.parallelStream().filter(t -> t.instantiatedTypes != null).forEach(t1 -> {
            for (AnalysisType t2 : allTypes) {
                boolean expected = t2.isInstantiated() ? t1.isAssignableFrom(t2) : false;
                boolean actual = t1.instantiatedTypes.getState().containsType(t2);
                if (actual == expected) continue;
                mismatchedAssignableResults.add("assignableTypes mismatch: " + t1.toJavaName(true) + " (instantiated: " + t1.isInstantiated() + ") - " + t2.toJavaName(true) + " (instantiated: " + t2.isInstantiated() + "): expected=" + expected + ", actual=" + actual);
            }
        });
        if (!mismatchedAssignableResults.isEmpty()) {
            mismatchedAssignableResults.forEach(System.err::println);
            throw new AssertionError((Object)"Verification of all-instantiated type flows failed");
        }
        return true;
    }

    public boolean registerAsInHeap() {
        this.registerAsReachable();
        if (AtomicUtils.atomicMark(this.isInHeap)) {
            this.registerAsInstantiated(UsageKind.InHeap);
            return true;
        }
        return false;
    }

    public boolean registerAsAllocated(Node node) {
        this.registerAsReachable();
        if (AtomicUtils.atomicMark(this.isAllocated)) {
            this.registerAsInstantiated(UsageKind.Allocated);
            return true;
        }
        return false;
    }

    private void registerAsInstantiated(UsageKind usageKind) {
        assert (this.isAllocated.get() || this.isInHeap.get());
        assert (this.isArray() || this.isInstanceClass() && !Modifier.isAbstract(this.getModifiers())) : this;
        this.universe.hostVM.checkForbidden(this, usageKind);
        PointsToAnalysis bb = (PointsToAnalysis)this.universe.getBigbang();
        TypeState typeState = TypeState.forExactType(bb, this, true);
        TypeState typeStateNonNull = TypeState.forExactType(bb, this, false);
        this.forAllSuperTypes(t -> {
            t.instantiatedTypes.addState(bb, typeState);
            t.instantiatedTypesNonNull.addState(bb, typeStateNonNull);
        });
    }

    public void registerAsAssignable(BigBang bb) {
        TypeState typeState = TypeState.forType((PointsToAnalysis)bb, this, true);
        this.forAllSuperTypes(t -> t.addAssignableType(bb, typeState), false);
        this.addAssignableType(bb, typeState);
    }

    public boolean registerAsReachable() {
        if (!this.isReachable.get()) {
            this.forAllSuperTypes(AnalysisType::markReachable);
            return true;
        }
        return false;
    }

    private void markReachable() {
        if (AtomicUtils.atomicMark(this.isReachable)) {
            this.universe.hostVM.checkForbidden(this, UsageKind.Reachable);
            if (this.isArray()) {
                this.registerAsAllocated(null);
            }
            this.universe.hostVM.executor().execute(this.initializationTask);
        }
    }

    private void forAllSuperTypes(Consumer<AnalysisType> superTypeConsumer) {
        this.forAllSuperTypes(superTypeConsumer, true);
    }

    private void forAllSuperTypes(Consumer<AnalysisType> superTypeConsumer, boolean includeThisType) {
        AnalysisType.forAllSuperTypes(this.elementalType, this.dimension, includeThisType, superTypeConsumer);
        for (int i = 0; i < this.dimension; ++i) {
            AnalysisType.forAllSuperTypes(this, i, false, superTypeConsumer);
        }
        if (this.dimension > 0 && !this.elementalType.isPrimitive() && !this.elementalType.isJavaLangObject()) {
            AnalysisType.forAllSuperTypes(this.universe.objectType(), this.dimension, true, superTypeConsumer);
        }
    }

    private static void forAllSuperTypes(AnalysisType elementType, int arrayDimension, boolean processType, Consumer<AnalysisType> superTypeConsumer) {
        if (elementType == null) {
            return;
        }
        if (processType) {
            superTypeConsumer.accept(elementType.getArrayClass(arrayDimension));
        }
        for (AnalysisType interf : elementType.getInterfaces()) {
            AnalysisType.forAllSuperTypes(interf, arrayDimension, true, superTypeConsumer);
        }
        AnalysisType.forAllSuperTypes(elementType.getSuperclass(), arrayDimension, true, superTypeConsumer);
    }

    private synchronized void addAssignableType(BigBang bb, TypeState typeState) {
        this.assignableTypesState = TypeState.forUnion((PointsToAnalysis)bb, this.assignableTypesState, typeState);
        this.assignableTypesNonNullState = this.assignableTypesState.forNonNull((PointsToAnalysis)bb);
    }

    public void ensureInitialized() {
        this.initializationTask.ensureDone();
    }

    public boolean getReachabilityListenerNotified() {
        return this.reachabilityListenerNotified;
    }

    public void setReachabilityListenerNotified(boolean reachabilityListenerNotified) {
        this.reachabilityListenerNotified = reachabilityListenerNotified;
    }

    public void registerUnsafeFieldsRecomputed() {
        this.unsafeFieldsRecomputed = true;
    }

    public void registerUnsafeAccessedField(AnalysisField field, UnsafePartitionKind partitionKind) {
        Collection<AnalysisField> unsafePartition;
        this.unsafeAccessedFieldsRegistered = true;
        if (this.unsafeAccessedFields == null) {
            UNSAFE_ACCESS_FIELDS_UPDATER.compareAndSet(this, null, new ConcurrentHashMap());
        }
        if ((unsafePartition = this.unsafeAccessedFields.get(partitionKind)) == null) {
            ConcurrentLinkedQueue<AnalysisField> newPartition = new ConcurrentLinkedQueue<AnalysisField>();
            ConcurrentLinkedQueue<AnalysisField> oldPartition = this.unsafeAccessedFields.putIfAbsent(partitionKind, newPartition);
            Collection<AnalysisField> collection = unsafePartition = oldPartition != null ? oldPartition : newPartition;
        }
        assert (!unsafePartition.contains(field)) : "Field " + field + " already registered as unsafe accessed with " + this;
        unsafePartition.add(field);
    }

    private boolean hasUnsafeAccessedFields() {
        return this.unsafeAccessedFieldsRegistered || this.getSuperclass() != null && this.getSuperclass().hasUnsafeAccessedFields();
    }

    public List<AnalysisField> unsafeAccessedFields() {
        return this.unsafeAccessedFields(DefaultUnsafePartition.get());
    }

    public List<AnalysisField> unsafeAccessedFields(UnsafePartitionKind partitionKind) {
        if (!this.hasUnsafeAccessedFields()) {
            return Collections.emptyList();
        }
        return this.allUnsafeAccessedFields(partitionKind);
    }

    private List<AnalysisField> allUnsafeAccessedFields(UnsafePartitionKind partitionKind) {
        ArrayList<AnalysisField> unsafePartition = new ArrayList<AnalysisField>();
        unsafePartition.addAll(this.unsafeAccessedFields != null && this.unsafeAccessedFields.containsKey(partitionKind) ? this.unsafeAccessedFields.get(partitionKind) : Collections.emptyList());
        if (this.getSuperclass() != null) {
            List<AnalysisField> superFileds = this.getSuperclass().allUnsafeAccessedFields(partitionKind);
            unsafePartition.addAll(superFileds);
        }
        return unsafePartition;
    }

    public boolean isInstantiated() {
        boolean instantiated;
        boolean bl = instantiated = this.isInHeap.get() || this.isAllocated.get();
        assert (!instantiated || this.isReachable.get());
        return instantiated;
    }

    public boolean unsafeFieldsRecomputed() {
        return this.unsafeFieldsRecomputed;
    }

    public boolean isReachable() {
        return this.isReachable.get();
    }

    public final JavaKind getStorageKind() {
        return this.storageKind;
    }

    public boolean isWordType() {
        return this.getJavaKind() != this.getStorageKind();
    }

    @Override
    public ResolvedJavaType getWrapped() {
        return this.universe.substitutions.resolve(this.wrapped);
    }

    public ResolvedJavaType getWrappedWithoutResolve() {
        return this.wrapped;
    }

    @Override
    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass(this.universe.getOriginalSnippetReflection(), this.wrapped);
    }

    public final String getName() {
        return this.wrapped.getName();
    }

    public final JavaKind getJavaKind() {
        return this.wrapped.getJavaKind();
    }

    public final AnalysisType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public final boolean hasFinalizer() {
        return false;
    }

    public final Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public final boolean isInitialized() {
        return this.universe.hostVM.isInitialized(this);
    }

    public void initialize() {
        if (!this.wrapped.isInitialized()) {
            throw GraalError.shouldNotReachHere((String)("Classes can only be initialized using methods in ClassInitializationFeature: " + this.toClassName()));
        }
    }

    public final AnalysisType getArrayClass() {
        if (this.arrayClass == null) {
            this.arrayClass = this.universe.lookup((JavaType)this.wrapped.getArrayClass());
        }
        return this.arrayClass;
    }

    public boolean isInterface() {
        return this.wrapped.isInterface();
    }

    public boolean isEnum() {
        return this.wrapped.isEnum();
    }

    public boolean isInstanceClass() {
        return this.wrapped.isInstanceClass();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isPrimitive() {
        return this.wrapped.isPrimitive();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        ResolvedJavaType subst = this.universe.substitutions.resolve(((AnalysisType)other).wrapped);
        return this.wrapped.isAssignableFrom(subst);
    }

    public boolean isInstance(JavaConstant obj) {
        return this.wrapped.isInstance(this.universe.toHosted(obj));
    }

    public AnalysisType getSuperclass() {
        return this.superClass;
    }

    public AnalysisType[] getInterfaces() {
        return this.interfaces;
    }

    public ResolvedJavaType getSingleImplementor() {
        return this;
    }

    public Set<AnalysisType> getSubTypes() {
        return this.subTypes;
    }

    private void addSubType(AnalysisType subType) {
        this.subTypes.add(subType);
    }

    public AnalysisType findLeastCommonAncestor(ResolvedJavaType otherType) {
        ResolvedJavaType subst = this.universe.substitutions.resolve(((AnalysisType)otherType).wrapped);
        return this.universe.lookup((JavaType)this.wrapped.findLeastCommonAncestor(subst));
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        Assumptions.AssumptionResult wrappedResult = this.wrapped.findLeafConcreteSubtype();
        if (wrappedResult != null && wrappedResult.isAssumptionFree()) {
            return new Assumptions.AssumptionResult((Object)this.universe.lookup((JavaType)wrappedResult.getResult()));
        }
        return null;
    }

    public AnalysisType getComponentType() {
        return this.componentType;
    }

    public ResolvedJavaType getElementalType() {
        return this.elementalType;
    }

    public boolean hasSubTypes() {
        return this.subTypes.size() > 1;
    }

    public AnalysisMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        throw GraalError.unimplemented();
    }

    public AnalysisMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        Object resolvedMethod = this.resolvedMethods.get(method);
        if (resolvedMethod == null) {
            Object oldResolvedMethod;
            ResolvedJavaType substCallerType;
            ResolvedJavaMethod substMethod = this.universe.substitutions.resolve(((AnalysisMethod)method).wrapped);
            Object newResolvedMethod = this.universe.lookup((JavaMethod)this.wrapped.resolveConcreteMethod(substMethod, substCallerType = substMethod.getDeclaringClass()));
            if (newResolvedMethod == null) {
                newResolvedMethod = NULL_METHOD;
            }
            resolvedMethod = (oldResolvedMethod = this.resolvedMethods.putIfAbsent(method, newResolvedMethod)) != null ? oldResolvedMethod : newResolvedMethod;
        }
        return resolvedMethod == NULL_METHOD ? null : (AnalysisMethod)resolvedMethod;
    }

    public AnalysisMethod resolveConcreteMethod(ResolvedJavaMethod method) {
        return this.resolveConcreteMethod(method, null);
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return null;
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return this.universe.lookup((JavaField)this.wrapped.findInstanceFieldWithOffset(offset, expectedKind));
    }

    public void clearInstanceFieldsCache() {
        this.instanceFieldsWithSuper = null;
        this.instanceFieldsWithoutSuper = null;
    }

    public AnalysisField[] getInstanceFields(boolean includeSuperclasses) {
        AnalysisField[] result;
        AnalysisField[] analysisFieldArray = result = includeSuperclasses ? this.instanceFieldsWithSuper : this.instanceFieldsWithoutSuper;
        if (result != null) {
            return result;
        }
        return this.initializeInstanceFields(includeSuperclasses);
    }

    private AnalysisField[] initializeInstanceFields(boolean includeSuperclasses) {
        ArrayList<AnalysisField> list = new ArrayList<AnalysisField>();
        if (includeSuperclasses && this.getSuperclass() != null) {
            list.addAll(Arrays.asList(this.getSuperclass().getInstanceFields(true)));
        }
        AnalysisField[] result = this.convertFields(this.interceptInstanceFields(this.wrapped.getInstanceFields(false)), list, includeSuperclasses);
        if (includeSuperclasses) {
            this.instanceFieldsWithSuper = result;
        } else {
            this.instanceFieldsWithoutSuper = result;
        }
        return result;
    }

    private AnalysisField[] convertFields(ResolvedJavaField[] original, List<AnalysisField> list, boolean listIncludesSuperClassesFields) {
        for (int i = 0; i < original.length; ++i) {
            if (original[i].isInternal()) continue;
            try {
                AnalysisField aField = this.universe.lookup((JavaField)original[i]);
                if (aField == null) continue;
                if (listIncludesSuperClassesFields) {
                    aField.setPosition(list.size());
                }
                list.add(aField);
                continue;
            }
            catch (UnsupportedFeatureException unsupportedFeatureException) {
                // empty catch block
            }
        }
        return list.toArray(new AnalysisField[list.size()]);
    }

    public AnalysisField[] getStaticFields() {
        this.registerAsReachable();
        return this.convertFields(this.wrapped.getStaticFields(), new ArrayList<AnalysisField>(), false);
    }

    public Annotation[] getAnnotations() {
        return GuardedAnnotationAccess.getAnnotations((AnnotatedElement)this.wrapped);
    }

    public Annotation[] getDeclaredAnnotations() {
        return GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)this.wrapped);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)this.wrapped, annotationClass);
    }

    public String getSourceFileName() {
        return this.wrapped.isPrimitive() ? null : this.wrapped.getSourceFileName();
    }

    public String toString() {
        return "AnalysisType<" + this.toJavaName(true) + ", allocated: " + this.isAllocated + ", inHeap: " + this.isInHeap + ", reachable: " + this.isReachable + ">";
    }

    public boolean isLocal() {
        try {
            return this.wrapped.isLocal();
        }
        catch (InternalError e) {
            this.universe.hostVM().warn("unknown locality of class " + this.wrapped.getName() + ", assuming class is not local. To remove the warning report an issue to the library or language author. The issue is caused by " + this.wrapped.getName() + " which is not following the naming convention.");
            return false;
        }
    }

    public boolean isMember() {
        return this.wrapped.isMember();
    }

    public AnalysisType getEnclosingType() {
        ResolvedJavaType wrappedEnclosingType;
        try {
            wrappedEnclosingType = this.wrapped.getEnclosingType();
        }
        catch (LinkageError e) {
            return null;
        }
        return this.universe.lookup((JavaType)wrappedEnclosingType);
    }

    public AnalysisMethod[] getDeclaredConstructors() {
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredConstructors());
    }

    public AnalysisMethod[] getDeclaredMethods() {
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredMethods());
    }

    public AnalysisMethod findMethod(String name, Signature signature) {
        for (AnalysisMethod method : this.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !method.getSignature().equals(signature)) continue;
            return method;
        }
        return null;
    }

    public AnalysisMethod getClassInitializer() {
        return this.universe.lookup((JavaMethod)this.wrapped.getClassInitializer());
    }

    public boolean isLinked() {
        return this.wrapped.isLinked();
    }

    public void link() {
        this.wrapped.link();
    }

    public boolean hasDefaultMethods() {
        return this.wrapped.hasDefaultMethods();
    }

    public boolean declaresDefaultMethods() {
        return this.wrapped.declaresDefaultMethods();
    }

    public boolean isCloneableWithAllocation() {
        throw JVMCIError.unimplemented();
    }

    public ResolvedJavaType getHostClass() {
        return this.universe.lookup((JavaType)this.wrapped.getHostClass());
    }

    @Override
    public int compareTo(AnalysisType other) {
        return Integer.compare(this.id, other.id);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public void addInstanceFieldsInterceptor(InstanceFieldsInterceptor interceptor) {
        ConcurrentLightHashSet.addElement(this, INTERCEPTORS_UPDATER, interceptor);
    }

    private ResolvedJavaField[] interceptInstanceFields(ResolvedJavaField[] fields) {
        ResolvedJavaField[] result = fields;
        for (Object interceptor : ConcurrentLightHashSet.getElements(this, INTERCEPTORS_UPDATER)) {
            result = ((InstanceFieldsInterceptor)interceptor).interceptInstanceFields(this.universe, result, this);
        }
        return result;
    }

    public static interface InstanceFieldsInterceptor {
        public ResolvedJavaField[] interceptInstanceFields(AnalysisUniverse var1, ResolvedJavaField[] var2, AnalysisType var3);
    }

    public static enum UsageKind {
        InHeap,
        Allocated,
        Reachable;

    }
}

