/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.phases;

import java.util.ArrayList;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.replacements.IntrinsicGraphBuilder;

public class SubstrateIntrinsicGraphBuilder
extends IntrinsicGraphBuilder {
    private int bci;

    public SubstrateIntrinsicGraphBuilder(OptionValues options, DebugContext debug, CoreProviders providers, Bytecode code) {
        super(options, debug, providers, code, -1, StructuredGraph.AllowAssumptions.NO);
        this.setStateAfter((StateSplit)this.getGraph().start());
    }

    public void setStateAfter(StateSplit sideEffect) {
        FrameState stateAfter = this.getFrameState(this.returnValue);
        sideEffect.setStateAfter(stateAfter);
    }

    private FrameState getFrameState(ValueNode returnVal) {
        ArrayList<ValueNode> values = new ArrayList<ValueNode>(Arrays.asList(this.arguments));
        int stackSize = 0;
        if (returnVal != null) {
            values.add(returnVal);
            ++stackSize;
            if (this.method.getSignature().getReturnKind().needsTwoSlots()) {
                values.add(null);
                ++stackSize;
            }
        }
        FrameState stateAfter = (FrameState)this.getGraph().add((Node)new FrameState(null, this.code, this.bci, values, this.arguments.length, stackSize, false, false, null, null));
        ++this.bci;
        return stateAfter;
    }

    public FrameState getIntrinsicReturnState(JavaKind returnKind, ValueNode retVal) {
        return this.getFrameState(retVal);
    }

    protected void setExceptionState(StateSplit exceptionObject) {
        ArrayList<ValueNode> values = new ArrayList<ValueNode>(Arrays.asList(this.arguments));
        values.add((ValueNode)exceptionObject.asNode());
        int stackSize = 1;
        FrameState stateAfter = (FrameState)this.getGraph().add((Node)new FrameState(null, this.code, this.bci, values, this.arguments.length, stackSize, true, false, null, null));
        exceptionObject.setStateAfter(stateAfter);
        ++this.bci;
    }

    protected void mergeUnwinds() {
        ArrayList<UnwindNode> unwinds = new ArrayList<UnwindNode>();
        for (Node node : this.getGraph().getNodes()) {
            if (!(node instanceof UnwindNode)) continue;
            unwinds.add((UnwindNode)node);
        }
        if (unwinds.size() > 1) {
            MergeNode unwindMergeNode = (MergeNode)this.getGraph().add((Node)new MergeNode());
            ValueNode exceptionValue = InliningUtil.mergeUnwindExceptions((AbstractMergeNode)unwindMergeNode, unwinds);
            UnwindNode unwindReplacement = (UnwindNode)this.getGraph().add((Node)new UnwindNode(exceptionValue));
            unwindMergeNode.setNext((FixedNode)unwindReplacement);
            ArrayList<ValueNode> values = new ArrayList<ValueNode>(Arrays.asList(this.arguments));
            values.add(exceptionValue);
            int stackSize = 1;
            FrameState stateAfter = (FrameState)this.getGraph().add((Node)new FrameState(null, this.code, this.bci, values, this.arguments.length, stackSize, true, false, null, null));
            unwindMergeNode.setStateAfter(stateAfter);
            ++this.bci;
        }
    }

    public int bci() {
        return this.bci;
    }

    public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
        return plugin.isGeneratedFromFoldOrNodeIntrinsic();
    }

    public boolean needsExplicitException() {
        return true;
    }
}

