/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.ContextInsensitiveFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.object.AllocationContextSensitiveObject;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import com.oracle.graal.pointsto.typestore.SplitArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.SplitFieldTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedFieldTypeStore;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.options.OptionValues;

public class BytecodeSensitiveAnalysisPolicy
extends AnalysisPolicy {
    private BytecodeAnalysisContextPolicy contextPolicy = new BytecodeAnalysisContextPolicy();

    public BytecodeSensitiveAnalysisPolicy(OptionValues options) {
        super(options);
    }

    public BytecodeAnalysisContextPolicy contextPolicy() {
        return this.contextPolicy;
    }

    @Override
    public boolean needsConstantCache() {
        return true;
    }

    @Override
    public boolean isSummaryObject(AnalysisObject object) {
        return object.isContextInsensitiveObject();
    }

    @Override
    public boolean isMergingEnabled() {
        return true;
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, TypeState t) {
        t.noteMerge(bb);
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, AnalysisObject ... a) {
        for (AnalysisObject o : a) {
            o.noteMerge(bb);
        }
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, AnalysisObject o) {
        o.noteMerge(bb);
    }

    @Override
    public boolean isContextSensitiveAllocation(PointsToAnalysis bb, AnalysisType type, AnalysisContext allocationContext) {
        return bb.trackConcreteAnalysisObjects(type);
    }

    @Override
    public AnalysisObject createHeapObject(PointsToAnalysis bb, AnalysisType type, BytecodeLocation allocationSite, AnalysisContext allocationContext) {
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(this.options)).booleanValue());
        if (this.isContextSensitiveAllocation(bb, type, allocationContext)) {
            return new AllocationContextSensitiveObject(bb, type, allocationSite, allocationContext);
        }
        return type.getContextInsensitiveAnalysisObject();
    }

    @Override
    public AnalysisObject createConstantObject(PointsToAnalysis bb, JavaConstant constant, AnalysisType exactType) {
        if (bb.trackConcreteAnalysisObjects(exactType)) {
            return exactType.getCachedConstantObject(bb, constant);
        }
        return exactType.getContextInsensitiveAnalysisObject();
    }

    @Override
    public TypeState dynamicNewInstanceState(PointsToAnalysis bb, TypeState currentState, TypeState newState, BytecodeLocation allocationSite, AnalysisContext allocationContext) {
        TypeState resultState = TypeState.forEmpty();
        for (AnalysisType type : newState.types(bb)) {
            if (currentState.containsType(type)) continue;
            TypeState typeState = TypeState.forAllocation(bb, allocationSite, type, allocationContext);
            resultState = TypeState.forUnion(bb, resultState, typeState);
        }
        assert (!resultState.canBeNull());
        return resultState;
    }

    @Override
    public TypeState cloneState(PointsToAnalysis bb, TypeState currentState, TypeState inputState, BytecodeLocation cloneSite, AnalysisContext allocationContext) {
        TypeState resultState;
        if (inputState.isEmpty() || inputState.isNull()) {
            resultState = inputState.forNonNull(bb);
        } else {
            resultState = TypeState.forEmpty();
            for (AnalysisType type : inputState.types(bb)) {
                if (currentState.containsType(type)) continue;
                TypeState typeState = TypeState.forClone(bb, cloneSite, type, allocationContext);
                resultState = TypeState.forUnion(bb, resultState, typeState);
            }
        }
        assert (!resultState.canBeNull());
        return resultState;
    }

    @Override
    public void linkClonedObjects(PointsToAnalysis bb, TypeFlow<?> inputFlow, CloneTypeFlow cloneFlow, BytecodePosition source) {
        TypeState inputState = inputFlow.getState();
        TypeState cloneState = cloneFlow.getState();
        for (AnalysisType type : inputState.types(bb)) {
            if (type.isArray()) {
                if (bb.analysisPolicy().aliasArrayTypeFlows()) continue;
                for (AnalysisObject originalObject : inputState.objects(type)) {
                    if (originalObject.isPrimitiveArray() || originalObject.isEmptyObjectArrayConstant(bb)) continue;
                    ArrayElementsTypeFlow originalObjectElementsFlow = originalObject.getArrayElementsFlow(bb, false);
                    for (AnalysisObject cloneObject : cloneState.objects(type)) {
                        if (cloneObject.isPrimitiveArray() || cloneObject.isEmptyObjectArrayConstant(bb)) continue;
                        ArrayElementsTypeFlow cloneObjectElementsFlow = cloneObject.getArrayElementsFlow(bb, true);
                        originalObjectElementsFlow.addUse(bb, cloneObjectElementsFlow);
                    }
                }
                continue;
            }
            for (AnalysisObject originalObject : inputState.objects(type)) {
                for (AnalysisField field : type.getInstanceFields(true)) {
                    FieldTypeFlow originalObjectFieldFlow = originalObject.getInstanceFieldFlow(bb, inputFlow, source, field, false);
                    for (AnalysisObject cloneObject : cloneState.objects(type)) {
                        FieldTypeFlow cloneObjectFieldFlow = cloneObject.getInstanceFieldFlow(bb, cloneFlow, source, field, true);
                        originalObjectFieldFlow.addUse(bb, cloneObjectFieldFlow);
                    }
                }
            }
        }
    }

    @Override
    public BytecodeLocation createAllocationSite(PointsToAnalysis bb, int bci, AnalysisMethod method) {
        return BytecodeLocation.create(bci, method);
    }

    @Override
    public FieldTypeStore createFieldTypeStore(AnalysisObject object, AnalysisField field, AnalysisUniverse universe) {
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(this.options)).booleanValue());
        if (object.isContextInsensitiveObject()) {
            FieldTypeFlow writeFlow = new FieldTypeFlow(field, field.getType(), object);
            ContextInsensitiveFieldTypeFlow readFlow = new ContextInsensitiveFieldTypeFlow(field, field.getType(), object);
            return new SplitFieldTypeStore(field, object, writeFlow, readFlow);
        }
        return new UnifiedFieldTypeStore(field, object);
    }

    @Override
    public ArrayElementsTypeStore createArrayElementsTypeStore(AnalysisObject object, AnalysisUniverse universe) {
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(this.options)).booleanValue());
        if (object.type().isArray()) {
            if (this.aliasArrayTypeFlows) {
                if (object.type().getElementalType().isJavaLangObject() && object.isContextInsensitiveObject()) {
                    return new UnifiedArrayElementsTypeStore(object);
                }
                return universe.objectType().getArrayClass().getContextInsensitiveAnalysisObject().getArrayElementsTypeStore();
            }
            return BytecodeSensitiveAnalysisPolicy.getArrayElementsTypeStore(object);
        }
        return null;
    }

    private static ArrayElementsTypeStore getArrayElementsTypeStore(AnalysisObject object) {
        if (object.isContextInsensitiveObject()) {
            return new SplitArrayElementsTypeStore(object);
        }
        return new UnifiedArrayElementsTypeStore(object);
    }

    @Override
    public AbstractVirtualInvokeTypeFlow createVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        return new BytecodeSensitiveVirtualInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
    }

    @Override
    public AbstractSpecialInvokeTypeFlow createSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        return new BytecodeSensitiveSpecialInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
    }

    private static final class BytecodeSensitiveSpecialInvokeTypeFlow
    extends AbstractSpecialInvokeTypeFlow {
        private ConcurrentMap<MethodFlowsGraph, Object> calleesFlows;

        BytecodeSensitiveSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
            super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
        }

        private BytecodeSensitiveSpecialInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, BytecodeSensitiveSpecialInvokeTypeFlow original) {
            super(bb, methodFlows, original);
            this.calleesFlows = new ConcurrentHashMap<MethodFlowsGraph, Object>(4, 0.75f, 1);
        }

        @Override
        public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new BytecodeSensitiveSpecialInvokeTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone() || this.isContextInsensitive());
            this.initCallee();
            TypeState invokeState = this.filterReceiverState(bb, this.getReceiver().getState());
            for (AnalysisObject receiverObject : invokeState.objects()) {
                AnalysisContext calleeContext = bb.contextPolicy().calleeContext(bb, receiverObject, this.callerContext, this.callee);
                MethodFlowsGraph calleeFlows = this.callee.addContext(bb, calleeContext, this);
                if (this.calleesFlows.putIfAbsent(calleeFlows, Boolean.TRUE) == null) {
                    this.linkCallee(bb, false, calleeFlows);
                }
                this.updateReceiver(bb, calleeFlows, receiverObject);
            }
        }

        @Override
        public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
            return new ArrayList<MethodFlowsGraph>(this.calleesFlows.keySet());
        }
    }

    private static class BytecodeSensitiveVirtualInvokeTypeFlow
    extends AbstractVirtualInvokeTypeFlow {
        private final ConcurrentMap<MethodFlowsGraph, Object> calleesFlows;
        private final AnalysisContext callerContext;

        protected BytecodeSensitiveVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
            super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
            this.calleesFlows = null;
            this.callerContext = null;
        }

        protected BytecodeSensitiveVirtualInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, BytecodeSensitiveVirtualInvokeTypeFlow original) {
            super(bb, methodFlows, original);
            this.calleesFlows = new ConcurrentHashMap<MethodFlowsGraph, Object>(4, 0.75f, 1);
            this.callerContext = methodFlows.context();
        }

        @Override
        public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new BytecodeSensitiveVirtualInvokeTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone());
            TypeState receiverState = this.getReceiver().getState();
            receiverState = this.filterReceiverState(bb, receiverState);
            TypeState.TypesObjectsIterator toi = receiverState.getTypesObjectsIterator();
            while (toi.hasNextType()) {
                AnalysisType type = toi.nextType();
                AnalysisMethod method = type.resolveConcreteMethod(this.getTargetMethod());
                if (method == null || Modifier.isAbstract(method.getModifiers())) {
                    while (toi.hasNextObject(type)) {
                        toi.nextObject(type);
                    }
                    continue;
                }
                assert (!Modifier.isAbstract(method.getModifiers()));
                MethodTypeFlow callee = PointsToAnalysis.assertPointsToAnalysisMethod(method).getTypeFlow();
                while (toi.hasNextObject(type)) {
                    AnalysisObject actualReceiverObject = toi.nextObject(type);
                    AnalysisContext calleeContext = bb.contextPolicy().calleeContext(bb, actualReceiverObject, this.callerContext, callee);
                    MethodFlowsGraph calleeFlows = callee.addContext(bb, calleeContext, this);
                    if (this.calleesFlows.put(calleeFlows, Boolean.TRUE) == null) {
                        this.addCallee(calleeFlows.getMethod());
                        this.linkCallee(bb, false, calleeFlows);
                    }
                    this.updateReceiver(bb, calleeFlows, actualReceiverObject);
                }
            }
        }

        @Override
        public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
            assert (this.isClone());
            this.replaceObservedWith(bb, this.receiverType);
        }

        @Override
        public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
            return new ArrayList<MethodFlowsGraph>(this.calleesFlows.keySet());
        }
    }
}

