/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.HeapScanningPolicy;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.AnalysisContextPolicy;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.reports.StatisticsPrinter;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.ImageGeneratorThreadMarker;
import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.Function;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public abstract class PointsToAnalysis
implements BigBang {
    private final OptionValues options;
    private final List<DebugHandlersFactory> debugHandlerFactories;
    private final DebugContext debug;
    private final HostedProviders providers;
    private final Replacements replacements;
    private final HeapScanningPolicy heapScanningPolicy;
    private final AnalysisType objectType;
    private TypeFlow<?> allSynchronizedTypeFlow;
    protected final AnalysisUniverse universe;
    protected final AnalysisMetaAccess metaAccess;
    protected final HostVM hostVM;
    private final UnsupportedFeatures unsupportedFeatures;
    protected final boolean trackTypeFlowInputs;
    protected final boolean reportAnalysisStatistics;
    protected final boolean extendedAsserts;
    private final CompletionExecutor executor;
    private final Runnable heartbeatCallback;
    private ConcurrentMap<OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow, Boolean> unsafeLoads;
    private ConcurrentMap<OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow, Boolean> unsafeStores;
    public final AtomicLong numParsedGraphs = new AtomicLong();
    private final CompletionExecutor.Timing timing;
    public final Timer typeFlowTimer;
    public final Timer verifyHeapTimer;
    public final Timer processFeaturesTimer;
    public final Timer analysisTimer;
    private final boolean strengthenGraalGraphs;

    public PointsToAnalysis(OptionValues options, AnalysisUniverse universe, HostedProviders providers, HostVM hostVM, ForkJoinPool executorService, Runnable heartbeatCallback, UnsupportedFeatures unsupportedFeatures, TimerCollection timerCollection, boolean strengthenGraalGraphs) {
        this.options = options;
        this.debugHandlerFactories = Collections.singletonList(new GraalDebugHandlersFactory(providers.getSnippetReflection()));
        this.debug = new DebugContext.Builder(options, this.debugHandlerFactories).build();
        this.hostVM = hostVM;
        String imageName = hostVM.getImageName();
        this.typeFlowTimer = timerCollection.createTimer(imageName, "(typeflow)", false);
        this.verifyHeapTimer = timerCollection.get(TimerCollection.Registry.VERIFY_HEAP);
        this.processFeaturesTimer = timerCollection.get(TimerCollection.Registry.FEATURES);
        this.analysisTimer = timerCollection.get(TimerCollection.Registry.ANALYSIS);
        this.universe = universe;
        this.metaAccess = (AnalysisMetaAccess)providers.getMetaAccess();
        this.replacements = providers.getReplacements();
        this.unsupportedFeatures = unsupportedFeatures;
        this.providers = providers;
        this.strengthenGraalGraphs = strengthenGraalGraphs;
        this.objectType = this.metaAccess.lookupJavaType((Class)Object.class);
        this.objectType.getTypeFlow(this, true);
        this.allSynchronizedTypeFlow = new AllSynchronizedTypeFlow();
        this.trackTypeFlowInputs = (Boolean)PointstoOptions.TrackInputFlows.getValue(options);
        this.reportAnalysisStatistics = (Boolean)PointstoOptions.PrintPointsToStatistics.getValue(options);
        if (this.reportAnalysisStatistics) {
            PointsToStats.init(this);
        }
        this.extendedAsserts = (Boolean)PointstoOptions.ExtendedAsserts.getValue(options);
        this.unsafeLoads = new ConcurrentHashMap<OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow, Boolean>();
        this.unsafeStores = new ConcurrentHashMap<OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow, Boolean>();
        this.timing = (Boolean)PointstoOptions.ProfileAnalysisOperations.getValue(options) != false ? new AnalysisTiming() : null;
        this.executor = new CompletionExecutor(this, executorService, heartbeatCallback);
        this.executor.init(this.timing);
        this.heartbeatCallback = heartbeatCallback;
        this.heapScanningPolicy = (Boolean)PointstoOptions.ExhaustiveHeapScan.getValue(options) != false ? HeapScanningPolicy.scanAll() : HeapScanningPolicy.skipTypes(this.skippedHeapTypes());
    }

    @Override
    public void printTimers() {
        this.typeFlowTimer.print();
        this.verifyHeapTimer.print();
        this.processFeaturesTimer.print();
    }

    @Override
    public void printTimerStatistics(PrintWriter out) {
        StatisticsPrinter.print(out, "typeflow_time_ms", this.typeFlowTimer.getTotalTime());
        StatisticsPrinter.print(out, "verify_time_ms", this.verifyHeapTimer.getTotalTime());
        StatisticsPrinter.print(out, "features_time_ms", this.processFeaturesTimer.getTotalTime());
        StatisticsPrinter.print(out, "total_analysis_time_ms", this.analysisTimer.getTotalTime());
        StatisticsPrinter.printLast(out, "total_memory_bytes", this.analysisTimer.getTotalMemory());
    }

    public boolean strengthenGraalGraphs() {
        return this.strengthenGraalGraphs;
    }

    @Override
    public AnalysisType[] skippedHeapTypes() {
        return new AnalysisType[]{this.metaAccess.lookupJavaType((Class)String.class)};
    }

    @Override
    public Runnable getHeartbeatCallback() {
        return this.heartbeatCallback;
    }

    public boolean trackTypeFlowInputs() {
        return this.trackTypeFlowInputs;
    }

    public boolean reportAnalysisStatistics() {
        return this.reportAnalysisStatistics;
    }

    @Override
    public boolean extendedAsserts() {
        return this.extendedAsserts;
    }

    @Override
    public OptionValues getOptions() {
        return this.options;
    }

    @Override
    public List<DebugHandlersFactory> getDebugHandlerFactories() {
        return this.debugHandlerFactories;
    }

    @Override
    public DebugContext getDebug() {
        return this.debug;
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, MethodTypeFlow methodFlow) {
        return new MethodTypeFlowBuilder(bb, methodFlow);
    }

    public void registerUnsafeLoad(OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow unsafeLoad) {
        this.unsafeLoads.putIfAbsent(unsafeLoad, true);
    }

    public void registerUnsafeStore(OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow unsafeStore) {
        this.unsafeStores.putIfAbsent(unsafeStore, true);
    }

    @Override
    public void forceUnsafeUpdate(AnalysisField field) {
        for (OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow unsafeLoad : this.unsafeLoads.keySet()) {
            unsafeLoad.initClone(this);
            this.postFlow(unsafeLoad.receiver());
        }
        for (OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow unsafeStore : this.unsafeStores.keySet()) {
            unsafeStore.initClone(this);
            this.postFlow(unsafeStore.receiver());
        }
    }

    @Override
    public void registerAsJNIAccessed(AnalysisField field, boolean writable) {
        AllInstantiatedTypeFlow declaredTypeFlow = field.getType().getTypeFlow(this, true);
        if (field.isStatic()) {
            declaredTypeFlow.addUse(this, field.getStaticFieldFlow());
        } else {
            FieldTypeFlow instanceFieldFlow = field.getDeclaringClass().getContextInsensitiveAnalysisObject().getInstanceFieldFlow(this, field, writable);
            declaredTypeFlow.addUse(this, instanceFieldFlow);
        }
    }

    public boolean trackConcreteAnalysisObjects(AnalysisType type) {
        return true;
    }

    @Override
    public void cleanupAfterAnalysis() {
        this.allSynchronizedTypeFlow = null;
        this.unsafeLoads = null;
        this.unsafeStores = null;
        ConstantObjectsProfiler.constantTypes.clear();
        this.universe.getTypes().forEach(AnalysisType::cleanupAfterAnalysis);
        this.universe.getFields().forEach(AnalysisField::cleanupAfterAnalysis);
        this.universe.getMethods().forEach(AnalysisMethod::cleanupAfterAnalysis);
        this.universe.getHeapScanner().cleanupAfterAnalysis();
        this.universe.getHeapVerifier().cleanupAfterAnalysis();
    }

    @Override
    public AnalysisPolicy analysisPolicy() {
        return this.universe.analysisPolicy();
    }

    public AnalysisContextPolicy<AnalysisContext> contextPolicy() {
        return this.universe.analysisPolicy().getContextPolicy();
    }

    @Override
    public AnalysisUniverse getUniverse() {
        return this.universe;
    }

    @Override
    public HostedProviders getProviders() {
        return this.providers;
    }

    @Override
    public AnalysisMetaAccess getMetaAccess() {
        return this.metaAccess;
    }

    public Replacements getReplacements() {
        return this.replacements;
    }

    @Override
    public UnsupportedFeatures getUnsupportedFeatures() {
        return this.unsupportedFeatures;
    }

    public AnalysisType lookup(JavaType type) {
        return this.universe.lookup(type);
    }

    public AnalysisType getObjectType() {
        return this.metaAccess.lookupJavaType((Class)Object.class);
    }

    public AnalysisType getObjectArrayType() {
        return this.metaAccess.lookupJavaType((Class)Object[].class);
    }

    public AnalysisType getGraalNodeType() {
        return this.metaAccess.lookupJavaType((Class)Node.class);
    }

    public AnalysisType getGraalNodeListType() {
        return this.metaAccess.lookupJavaType((Class)NodeList.class);
    }

    public AnalysisType getThrowableType() {
        return this.metaAccess.lookupJavaType((Class)Throwable.class);
    }

    public AnalysisType getThreadType() {
        return this.metaAccess.lookupJavaType((Class)Thread.class);
    }

    public TypeFlow<?> getAllInstantiatedTypeFlow() {
        return this.objectType.getTypeFlow(this, true);
    }

    public TypeState getAllInstantiatedTypes() {
        return this.getAllInstantiatedTypeFlow().getState();
    }

    public TypeFlow<?> getAllSynchronizedTypeFlow() {
        return this.allSynchronizedTypeFlow;
    }

    @Override
    public TypeState getAllSynchronizedTypeState() {
        if (this.allSynchronizedTypeFlow.isSaturated()) {
            return this.getAllInstantiatedTypes();
        }
        return this.allSynchronizedTypeFlow.getState();
    }

    public boolean executorIsStarted() {
        return this.executor.isStarted();
    }

    @Override
    public AnalysisMethod addRootMethod(Executable method, boolean invokeSpecial) {
        return this.addRootMethod(this.metaAccess.lookupJavaMethod(method), invokeSpecial);
    }

    @Override
    public AnalysisMethod addRootMethod(AnalysisMethod aMethod, boolean invokeSpecial) {
        assert (!this.universe.sealed()) : "Cannot register root methods after analysis universe is sealed.";
        try (Indent indent = this.debug.logAndIndent("add root method %s", (Object)aMethod.getName());){
            AnalysisType declaringClass = aMethod.getDeclaringClass();
            boolean isStatic = aMethod.isStatic();
            int paramCount = aMethod.getSignature().getParameterCount(!isStatic);
            PointsToAnalysisMethod pointsToMethod = PointsToAnalysis.assertPointsToAnalysisMethod(aMethod);
            MethodTypeFlow methodFlow = pointsToMethod.getTypeFlow();
            int offset = 0;
            if (!isStatic) {
                methodFlow.setInitialReceiverFlow(this, aMethod.getDeclaringClass());
                offset = 1;
            }
            for (int idx = offset; idx < paramCount; ++idx) {
                AnalysisType declaredParamType = (AnalysisType)aMethod.getSignature().getParameterType(idx - offset, declaringClass);
                if (declaredParamType.getJavaKind() != JavaKind.Object) continue;
                methodFlow.setInitialParameterFlow(this, declaredParamType, idx);
            }
            if (isStatic) {
                this.postTask(() -> {
                    pointsToMethod.registerAsDirectRootMethod();
                    pointsToMethod.registerAsImplementationInvoked(null);
                    methodFlow.addContext(this, this.contextPolicy().emptyContext());
                });
            } else {
                if (invokeSpecial && pointsToMethod.isAbstract()) {
                    throw AnalysisError.userError("Abstract methods cannot be registered as special invoke entry point.");
                }
                this.postTask(() -> {
                    BytecodePosition location = new BytecodePosition(null, (ResolvedJavaMethod)pointsToMethod, 0);
                    if (invokeSpecial) {
                        pointsToMethod.registerAsDirectRootMethod();
                    } else {
                        pointsToMethod.registerAsVirtualRootMethod();
                    }
                    pointsToMethod.initAndGetContextInsensitiveInvoke(this, location, invokeSpecial);
                });
            }
        }
        return aMethod;
    }

    public static PointsToAnalysisMethod assertPointsToAnalysisMethod(AnalysisMethod aMethod) {
        assert (aMethod instanceof PointsToAnalysisMethod) : "Only points-to analysis methods are supported";
        return (PointsToAnalysisMethod)aMethod;
    }

    @Override
    public AnalysisType addRootClass(Class<?> clazz, boolean addFields, boolean addArrayClass) {
        ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)clazz);
        type.registerAsReachable();
        return this.addRootClass((AnalysisType)type, addFields, addArrayClass);
    }

    private AnalysisType addRootClass(AnalysisType type, boolean addFields, boolean addArrayClass) {
        try (Indent indent = this.debug.logAndIndent("add root class %s", (Object)type.getName());){
            for (AnalysisField field : type.getInstanceFields(false)) {
                if (addFields) {
                    field.registerAsAccessed();
                }
                AllInstantiatedTypeFlow fieldDeclaredTypeFlow = field.getType().getTypeFlow(this, true);
                fieldDeclaredTypeFlow.addUse(this, type.getContextInsensitiveAnalysisObject().getInstanceFieldFlow(this, field, true));
            }
            if (type.getSuperclass() != null) {
                this.addRootClass(type.getSuperclass(), addFields, addArrayClass);
            }
            if (addArrayClass) {
                this.addRootClass(type.getArrayClass(), false, false);
            }
        }
        return type;
    }

    @Override
    public AnalysisType addRootField(Class<?> clazz, String fieldName) {
        AnalysisType type = this.addRootClass(clazz, false, false);
        for (AnalysisField field : type.getInstanceFields(true)) {
            if (!field.getName().equals(fieldName)) continue;
            try (Indent indent = this.debug.logAndIndent("add root field %s in class %s", (Object)fieldName, (Object)clazz.getName());){
                field.registerAsAccessed();
                AllInstantiatedTypeFlow fieldDeclaredTypeFlow = field.getType().getTypeFlow(this, true);
                fieldDeclaredTypeFlow.addUse(this, type.getContextInsensitiveAnalysisObject().getInstanceFieldFlow(this, field, true));
            }
            return field.getType();
        }
        throw JVMCIError.shouldNotReachHere((String)("field not found: " + fieldName));
    }

    public AnalysisType addRootStaticField(Class<?> clazz, String fieldName) {
        AnalysisType analysisType;
        block8: {
            this.addRootClass(clazz, false, false);
            Indent indent = this.debug.logAndIndent("add system static field %s in class %s", (Object)fieldName, (Object)clazz.getName());
            try {
                Field reflectField = clazz.getField(fieldName);
                AnalysisField field = this.metaAccess.lookupJavaField(reflectField);
                field.registerAsAccessed();
                AllInstantiatedTypeFlow fieldFlow = field.getType().getTypeFlow(this, true);
                fieldFlow.addUse(this, field.getStaticFieldFlow());
                analysisType = field.getType();
                if (indent == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (indent != null) {
                        try {
                            indent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFieldException e) {
                    throw JVMCIError.shouldNotReachHere((String)("field not found: " + fieldName));
                }
            }
            indent.close();
        }
        return analysisType;
    }

    @Override
    public final SnippetReflectionProvider getSnippetReflectionProvider() {
        return this.providers.getSnippetReflection();
    }

    @Override
    public final ConstantReflectionProvider getConstantReflectionProvider() {
        return this.providers.getConstantReflection();
    }

    public ConstantFieldProvider getConstantFieldProvider() {
        return this.providers.getConstantFieldProvider();
    }

    @Override
    public void checkUserLimitations() {
    }

    public void postFlow(final TypeFlow<?> operation) {
        if (operation.inQueue) {
            return;
        }
        operation.inQueue = true;
        this.executor.execute(new TypeFlowRunnable(){

            @Override
            public void run(DebugContext ignored) {
                PointsToStats.registerTypeFlowQueuedUpdate(PointsToAnalysis.this, operation);
                operation.inQueue = false;
                operation.update(PointsToAnalysis.this);
            }

            public String toString() {
                return "Operation: " + operation.toString();
            }

            @Override
            public TypeFlow<?> getTypeFlow() {
                return operation;
            }
        });
    }

    public void postTask(CompletionExecutor.DebugContextRunnable task) {
        this.executor.execute(task);
    }

    public void postTask(final Runnable task) {
        this.executor.execute(new CompletionExecutor.DebugContextRunnable(){

            @Override
            public void run(DebugContext ignore) {
                task.run();
            }

            @Override
            public DebugContext getDebug(OptionValues opts, List<DebugHandlersFactory> factories) {
                assert (opts == PointsToAnalysis.this.getOptions());
                return DebugContext.disabled((OptionValues)opts);
            }
        });
    }

    @Override
    public boolean finish() throws InterruptedException {
        try (Indent indent = this.debug.logAndIndent("starting analysis in BigBang.finish");){
            this.universe.setAnalysisDataValid(false);
            boolean didSomeWork = this.doTypeflow();
            assert (this.executor.getPostedOperations() == 0L);
            this.universe.setAnalysisDataValid(true);
            boolean bl = didSomeWork;
            return bl;
        }
    }

    public boolean doTypeflow() throws InterruptedException {
        boolean didSomeWork;
        try (Timer.StopTimer ignored = this.typeFlowTimer.start();){
            this.executor.start();
            this.executor.complete();
            didSomeWork = this.executor.getPostedOperations() > 0L;
            this.executor.shutdown();
        }
        this.executor.init(this.timing);
        return didSomeWork;
    }

    @Override
    public HeapScanningPolicy scanningPolicy() {
        return this.heapScanningPolicy;
    }

    @Override
    public HostVM getHostVM() {
        return this.hostVM;
    }

    @Override
    public void runAnalysis(DebugContext debugContext, Function<AnalysisUniverse, Boolean> analysisEndCondition) throws InterruptedException {
        int numIterations = 0;
        while (true) {
            Indent indent2 = debugContext.logAndIndent("new analysis iteration");
            try {
                boolean pendingOperations;
                boolean analysisChanged = this.finish();
                if (++numIterations > 1000) {
                    throw AnalysisError.shouldNotReachHere(String.format("Static analysis did not reach a fix point after %d iterations because a Feature keeps requesting new analysis iterations. The analysis itself %s find a change in type states in the last iteration.", numIterations, analysisChanged ? "DID" : "DID NOT"));
                }
                int numTypes = this.universe.getTypes().size();
                int numMethods = this.universe.getMethods().size();
                int numFields = this.universe.getFields().size();
                if (!analysisEndCondition.apply(this.universe).booleanValue()) continue;
                if (numTypes != this.universe.getTypes().size() || numMethods != this.universe.getMethods().size() || numFields != this.universe.getFields().size()) {
                    throw AnalysisError.shouldNotReachHere("When a feature makes more types, methods, or fields reachable, it must require another analysis iteration via DuringAnalysisAccess.requireAnalysisIteration()");
                }
                boolean bl = pendingOperations = this.executor.getPostedOperations() > 0L;
                if (pendingOperations) {
                    System.out.println("Found pending operations, continuing analysis.");
                    continue;
                }
                if (this.analysisModified()) continue;
                return;
            }
            finally {
                if (indent2 == null) continue;
                indent2.close();
                continue;
            }
            break;
        }
    }

    private boolean analysisModified() throws InterruptedException {
        boolean analysisModified;
        try (Timer.StopTimer ignored = this.verifyHeapTimer.start();){
            analysisModified = this.universe.getHeapVerifier().requireAnalysisIteration(this.executor);
        }
        this.executor.init(this.timing);
        return analysisModified;
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="ForkJoinPool does support null for the exception handler.")
    public static ForkJoinPool createExecutor(DebugContext debug, int numberOfThreads) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = PointsToAnalysis.debugThreadFactory((DebugContext)(debug.areScopesEnabled() || debug.areMetricsEnabled() ? debug : null));
        return new ForkJoinPool(numberOfThreads, factory, null, false);
    }

    private static ForkJoinPool.ForkJoinWorkerThreadFactory debugThreadFactory(DebugContext debug) {
        return pool -> new SubstrateWorkerThread(pool, debug);
    }

    @Override
    public void onTypeInstantiated(AnalysisType type, AnalysisType.UsageKind usageKind) {
        assert (type.isAllocated() || type.isInHeap());
        AnalysisError.guarantee(type.isArray() || type.isInstanceClass() && !type.isAbstract());
        this.universe.hostVM().checkForbidden(type, usageKind);
        TypeState typeState = TypeState.forExactType(this, type, true);
        TypeState typeStateNonNull = TypeState.forExactType(this, type, false);
        type.forAllSuperTypes(t -> {
            t.instantiatedTypes.addState(this, typeState);
            t.instantiatedTypesNonNull.addState(this, typeStateNonNull);
        });
    }

    private static class SubstrateWorkerThread
    extends ForkJoinWorkerThread
    implements ImageGeneratorThreadMarker {
        private final DebugContext debug;

        SubstrateWorkerThread(ForkJoinPool pool, DebugContext debug) {
            super(pool);
            this.debug = debug;
        }

        @Override
        protected void onTermination(Throwable exception) {
            if (this.debug != null) {
                this.debug.closeDumpHandlers(true);
            }
        }
    }

    protected class AnalysisTiming
    extends BucketTiming {
        protected AnalysisTiming() {
        }

        @Override
        public void printHeader() {
            System.out.format("%5s %5s %5s  |", "graphs", "types", "nid");
            super.printHeader();
            System.out.println();
        }

        @Override
        public void print() {
            System.out.format("%5d %5d %5d  |", PointsToAnalysis.this.numParsedGraphs.get(), PointsToAnalysis.this.getAllInstantiatedTypes().typesCount(), PointsToAnalysis.this.universe.getNextTypeId());
            super.print();
            System.out.println();
        }
    }

    protected static abstract class BucketTiming
    implements CompletionExecutor.Timing {
        private static final int NUM_BUCKETS = 10;
        private final AtomicLong numOperations = new AtomicLong();
        private final AtomicLong numAdded = new AtomicLong();
        private final AtomicLong numDone = new AtomicLong();
        private final AtomicLong numInQueue = new AtomicLong();
        private final AtomicLong totalTime = new AtomicLong();
        private final AtomicLongArray timeBuckets = new AtomicLongArray(10);

        protected BucketTiming() {
        }

        @Override
        public long getPrintIntervalNanos() {
            return 1000000000L;
        }

        @Override
        public void addScheduled(CompletionExecutor.DebugContextRunnable r) {
            this.numOperations.incrementAndGet();
            this.numInQueue.incrementAndGet();
            this.numAdded.incrementAndGet();
        }

        @Override
        public void addCompleted(CompletionExecutor.DebugContextRunnable r, long nanos) {
            this.numInQueue.decrementAndGet();
            this.numDone.incrementAndGet();
            this.totalTime.addAndGet(nanos);
            int bucket = 0;
            for (long bucketTime = nanos / 1000L; bucketTime != 0L && bucket < 9; bucketTime /= 10L, ++bucket) {
            }
            this.timeBuckets.incrementAndGet(bucket);
            if (nanos > 500000000L && r instanceof TypeFlowRunnable) {
                TypeFlow<?> tf = ((TypeFlowRunnable)r).getTypeFlow();
                String source = String.valueOf(tf.getSource());
                System.out.format("LONG RUNNING  %.2f  %s %x %s  state %s %x  uses %d observers %d%n", (double)nanos / 1.0E9, ClassUtil.getUnqualifiedName(tf.getClass()), System.identityHashCode(tf), source, PointsToStats.asString(tf.getState()), System.identityHashCode(tf.getState()), tf.getUses().size(), tf.getObservers().size());
            }
        }

        @Override
        public void printHeader() {
            System.out.format("%9s %6s %6s %6s %10s %8s  %5s %5s %5s %5s %5s %5s %5s %5s %5s %5s  |", "total", "qlen", "added", "done", "total us", "avg us", "<1us", ">1us", "10", "100", ">1ms", "10", "100", ">1s", "10", "100");
        }

        @Override
        public void print() {
            int i;
            long operations = this.numOperations.get();
            long queued = this.numInQueue.get();
            long scheduled = this.numAdded.getAndSet(0L);
            long completed = this.numDone.getAndSet(0L);
            long time = this.totalTime.getAndSet(0L);
            long[] buckets = new long[10];
            for (i = 0; i < 10; ++i) {
                buckets[i] = this.timeBuckets.getAndSet(i, 0L);
            }
            System.out.format("%9d %6d %6d %6d %10d %8d  ", operations, queued, scheduled, completed, time / 1000L, completed != 0L ? time / 1000L / completed : 0L);
            for (i = 0; i < 10; ++i) {
                System.out.format("%5d ", buckets[i]);
            }
            System.out.print(" |");
        }
    }

    public static class ConstantObjectsProfiler {
        static final ConcurrentHashMap<AnalysisType, MyInteger> constantTypes = new ConcurrentHashMap(2000);
        static final int PROCESSED_CONSTANTS_DUMP_THRESHOLD = 100000;
        static final int CONSTANT_COUNTER_DUMP_THRESHOLD = 1000;
        static int processedConstants;
        static final ConstantCounterEntryComparator CONSTANT_COUNTER_COMPARATOR;

        public static void registerConstant(AnalysisType type) {
            ++processedConstants;
            MyInteger counter = constantTypes.get(type);
            if (counter == null) {
                MyInteger newValue = new MyInteger();
                MyInteger oldValue = constantTypes.putIfAbsent(type, newValue);
                counter = oldValue != null ? oldValue : newValue;
            }
            counter.increment();
        }

        public static void maybeDumpConstantHistogram() {
            if (processedConstants > 100000) {
                processedConstants = 0;
                ArrayList<ConstantCounterEntry> constantCounters = new ArrayList<ConstantCounterEntry>();
                for (Map.Entry<AnalysisType, MyInteger> entry : constantTypes.entrySet()) {
                    AnalysisType type = entry.getKey();
                    Integer counter = entry.getValue().value();
                    if (counter <= 1000) continue;
                    constantCounters.add(new ConstantCounterEntry(type, counter));
                }
                Collections.sort(constantCounters, CONSTANT_COUNTER_COMPARATOR);
                System.out.println(" - - - - - - - - - - - - - - - - - - - - - - - -  ");
                System.out.println("              CONSTANT HISTOGRAM                  ");
                for (ConstantCounterEntry constantCounter : constantCounters) {
                    System.out.format("%d : %s %n", constantCounter.counter, constantCounter.type.getName());
                }
                System.out.println(" - - - - - - - - - - - - - - - - - - - - - - - -  ");
            }
        }

        static {
            CONSTANT_COUNTER_COMPARATOR = new ConstantCounterEntryComparator();
        }

        static class ConstantCounterEntryComparator
        implements Comparator<ConstantCounterEntry> {
            ConstantCounterEntryComparator() {
            }

            @Override
            public int compare(ConstantCounterEntry o1, ConstantCounterEntry o2) {
                return Integer.compare(o2.counter, o1.counter);
            }
        }

        static class MyInteger {
            int myInt = 0;

            MyInteger() {
            }

            protected void increment() {
                ++this.myInt;
            }

            protected int value() {
                return this.myInt;
            }

            public String toString() {
                return "" + this.myInt;
            }
        }

        static class ConstantCounterEntry {
            protected AnalysisType type;
            protected int counter;

            ConstantCounterEntry(AnalysisType type, int counter) {
                this.type = type;
                this.counter = counter;
            }
        }
    }

    public static interface TypeFlowRunnable
    extends CompletionExecutor.DebugContextRunnable {
        public TypeFlow<?> getTypeFlow();
    }
}

