/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.SourceTypeFlowBase;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.code.BytecodePosition;

public class NewInstanceTypeFlow
extends SourceTypeFlowBase {
    private static final AtomicReferenceFieldUpdater<NewInstanceTypeFlow, ConcurrentMap> HEAP_OBJECTS_CACHE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(NewInstanceTypeFlow.class, ConcurrentMap.class, "heapObjectsCache");
    protected volatile ConcurrentMap<AnalysisContext, AnalysisObject> heapObjectsCache;
    protected final AnalysisType type;

    public NewInstanceTypeFlow(BytecodePosition position, AnalysisType type) {
        this(position, type, TypeState.forNull());
    }

    protected NewInstanceTypeFlow(BytecodePosition position, AnalysisType type, TypeState typeState) {
        super(position, type, typeState);
        this.type = type;
    }

    protected NewInstanceTypeFlow(PointsToAnalysis bb, NewInstanceTypeFlow original, MethodFlowsGraph methodFlows) {
        super(bb, original, methodFlows, original.cloneSourceState(bb, methodFlows));
        this.type = original.type;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new NewInstanceTypeFlow(bb, this, methodFlows);
    }

    protected TypeState cloneSourceState(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        AnalysisContext allocationContext = bb.analysisPolicy().allocationContext(bb, methodFlows);
        if (bb.analysisPolicy().isContextSensitiveAllocation(bb, this.type, allocationContext)) {
            AnalysisObject newHeapObject = this.createHeapObject(bb, allocationContext);
            return TypeState.forNonNullObject(bb, newHeapObject);
        }
        return TypeState.forExactType(bb, this.type, false);
    }

    private AnalysisObject createHeapObject(PointsToAnalysis bb, AnalysisContext objContext) {
        AnalysisObject result;
        if (this.heapObjectsCache == null) {
            HEAP_OBJECTS_CACHE_UPDATER.compareAndSet(this, null, new ConcurrentHashMap());
        }
        if ((result = (AnalysisObject)this.heapObjectsCache.get(objContext)) == null) {
            AnalysisObject newValue = bb.analysisPolicy().createHeapObject(bb, this.type, (BytecodePosition)this.source, objContext);
            AnalysisObject oldValue = this.heapObjectsCache.putIfAbsent(objContext, newValue);
            result = oldValue != null ? oldValue : newValue;
        }
        return result;
    }

    public AnalysisType type() {
        return this.type;
    }

    @Override
    public String toString() {
        return "NewInstanceFlow<" + this.getState() + ">";
    }
}

