/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import jdk.vm.ci.code.BytecodePosition;

public abstract class SourceTypeFlowBase
extends TypeFlow<BytecodePosition> {
    protected TypeState sourceState;

    public SourceTypeFlowBase(BytecodePosition position, TypeState state) {
        this(position, state.exactType(), state);
    }

    public SourceTypeFlowBase(BytecodePosition position, AnalysisType declaredType, TypeState state) {
        super(position, declaredType);
        this.sourceState = state;
        assert (this.source != null);
    }

    public SourceTypeFlowBase(PointsToAnalysis bb, SourceTypeFlowBase original, MethodFlowsGraph methodFlows) {
        this(bb, original, methodFlows, original.sourceState);
    }

    public SourceTypeFlowBase(PointsToAnalysis bb, SourceTypeFlowBase original, MethodFlowsGraph methodFlows, TypeState state) {
        super(original, methodFlows);
        this.sourceState = state;
    }

    public void setSourceState(TypeState sourceState) {
        this.sourceState = sourceState;
    }

    @Override
    public void initFlow(PointsToAnalysis bb) {
        if (this.sourceState.isNull() || this.sourceState.isEmpty() || bb.getAllInstantiatedTypeFlow().getState().containsType(this.sourceState.exactType())) {
            this.addState(bb, this.sourceState);
        } else {
            this.addState(bb, this.sourceState.canBeNull() ? TypeState.forNull() : TypeState.forEmpty());
            bb.getAllInstantiatedTypeFlow().addObserver(bb, this);
        }
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        if (bb.getAllInstantiatedTypeFlow().getState().containsType(this.sourceState.exactType())) {
            bb.getAllInstantiatedTypeFlow().removeObserver(this);
            this.addState(bb, this.sourceState);
        }
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    protected void onSaturated(PointsToAnalysis bb) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    public boolean canSaturate() {
        return false;
    }
}

