/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import java.lang.reflect.Executable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class AnalysisElement {
    private static final AtomicReferenceFieldUpdater<AnalysisElement, Object> reachableNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisElement.class, Object.class, "elementReachableNotifications");
    private volatile Object elementReachableNotifications;

    public void registerReachabilityNotification(ElementReachableNotification notification) {
        ConcurrentLightHashSet.addElement(this, reachableNotificationsUpdater, notification);
    }

    public void notifyReachabilityCallback(AnalysisUniverse universe, ElementReachableNotification notification) {
        notification.notifyCallback(universe, this);
        ConcurrentLightHashSet.removeElement(this, reachableNotificationsUpdater, notification);
    }

    protected void notifyReachabilityCallbacks(AnalysisUniverse universe) {
        ConcurrentLightHashSet.forEach(this, reachableNotificationsUpdater, c -> c.notifyCallback(universe, this));
        ConcurrentLightHashSet.removeElementIf(this, reachableNotificationsUpdater, ElementReachableNotification::isNotified);
    }

    public abstract boolean isReachable();

    protected abstract void onReachable();

    public boolean isTriggered() {
        return this.isReachable();
    }

    private static void execute(AnalysisUniverse universe, Runnable task) {
        ((PointsToAnalysis)universe.getBigbang()).postTask(task);
    }

    public static final class MethodOverrideReachableNotification {
        private final BiConsumer<Feature.DuringAnalysisAccess, Executable> callback;
        private final Set<AnalysisMethod> seenOverride = ConcurrentHashMap.newKeySet();

        public MethodOverrideReachableNotification(BiConsumer<Feature.DuringAnalysisAccess, Executable> callback) {
            this.callback = callback;
        }

        public void notifyCallback(AnalysisUniverse universe, AnalysisMethod reachableOverride) {
            assert (reachableOverride.isReachable());
            if (this.seenOverride.add(reachableOverride)) {
                AnalysisElement.execute(universe, () -> this.callback.accept(universe.getConcurrentAnalysisAccess(), reachableOverride.getJavaMethod()));
            }
        }
    }

    public static final class SubtypeReachableNotification {
        private final BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback;
        private final Set<AnalysisType> seenSubtypes = ConcurrentHashMap.newKeySet();

        public SubtypeReachableNotification(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback) {
            this.callback = callback;
        }

        public void notifyCallback(AnalysisUniverse universe, AnalysisType reachableSubtype) {
            assert (reachableSubtype.isReachable());
            if (this.seenSubtypes.add(reachableSubtype)) {
                AnalysisElement.execute(universe, () -> this.callback.accept(universe.getConcurrentAnalysisAccess(), reachableSubtype.getJavaClass()));
            }
        }
    }

    public static final class ElementReachableNotification {
        private final Consumer<Feature.DuringAnalysisAccess> callback;
        private final AtomicBoolean notified = new AtomicBoolean();

        public ElementReachableNotification(Consumer<Feature.DuringAnalysisAccess> callback) {
            this.callback = callback;
        }

        public boolean isNotified() {
            return this.notified.get();
        }

        private void notifyCallback(AnalysisUniverse universe, AnalysisElement triggeredElement) {
            assert (triggeredElement.isTriggered());
            if (!this.notified.getAndSet(true)) {
                AnalysisElement.execute(universe, () -> this.callback.accept(universe.getConcurrentAnalysisAccess()));
            }
        }
    }
}

