/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Optional;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;

public class AnalysisMetaAccess
extends UniverseMetaAccess {
    public AnalysisMetaAccess(AnalysisUniverse analysisUniverse, MetaAccessProvider originalMetaAccess) {
        super(analysisUniverse, originalMetaAccess);
        this.lookupJavaType((Class)Object.class);
        this.lookupJavaType((Class)Cloneable.class);
    }

    @Override
    public AnalysisType lookupJavaType(Class<?> clazz) {
        return (AnalysisType)super.lookupJavaType(clazz);
    }

    public Optional<AnalysisType> optionalLookupJavaType(Class<?> clazz) {
        AnalysisType result = (AnalysisType)this.getTypeCacheEntry(clazz);
        if (result != null) {
            return Optional.of(result);
        }
        result = this.getUniverse().optionalLookup(this.getWrapped().lookupJavaType(clazz));
        return Optional.ofNullable(result);
    }

    @Override
    public AnalysisType lookupJavaType(JavaConstant constant) {
        return (AnalysisType)super.lookupJavaType(constant);
    }

    @Override
    public AnalysisMethod lookupJavaMethod(Executable reflectionMethod) {
        return (AnalysisMethod)super.lookupJavaMethod(reflectionMethod);
    }

    @Override
    public AnalysisField lookupJavaField(Field reflectionField) {
        return (AnalysisField)super.lookupJavaField(reflectionField);
    }

    @Override
    public int getArrayIndexScale(JavaKind elementKind) {
        throw AnalysisError.shouldNotReachHere();
    }

    @Override
    public int getArrayBaseOffset(JavaKind elementKind) {
        throw AnalysisError.shouldNotReachHere();
    }

    @Override
    public AnalysisUniverse getUniverse() {
        return (AnalysisUniverse)this.universe;
    }
}

