/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.AbstractStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.MultiTypeState;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestate.TypeStateUtils;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import java.util.BitSet;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.options.OptionValues;

public abstract class AnalysisPolicy {
    protected final OptionValues options;
    protected final boolean aliasArrayTypeFlows;
    protected final boolean relaxTypeFlowConstraints;
    protected final boolean removeSaturatedTypeFlows;
    protected final int typeFlowSaturationCutoff;

    public AnalysisPolicy(OptionValues options) {
        this.options = options;
        this.aliasArrayTypeFlows = (Boolean)PointstoOptions.AliasArrayTypeFlows.getValue(options);
        this.relaxTypeFlowConstraints = (Boolean)PointstoOptions.RelaxTypeFlowStateConstraints.getValue(options);
        this.removeSaturatedTypeFlows = (Boolean)PointstoOptions.RemoveSaturatedTypeFlows.getValue(options);
        this.typeFlowSaturationCutoff = (Integer)PointstoOptions.TypeFlowSaturationCutoff.getValue(options);
    }

    public abstract boolean isContextSensitiveAnalysis();

    public boolean aliasArrayTypeFlows() {
        return this.aliasArrayTypeFlows;
    }

    public boolean relaxTypeFlowConstraints() {
        return this.relaxTypeFlowConstraints;
    }

    public boolean removeSaturatedTypeFlows() {
        return this.removeSaturatedTypeFlows;
    }

    public int typeFlowSaturationCutoff() {
        return this.typeFlowSaturationCutoff;
    }

    public abstract MethodTypeFlow createMethodTypeFlow(PointsToAnalysisMethod var1);

    public abstract boolean needsConstantCache();

    public abstract boolean isSummaryObject(AnalysisObject var1);

    public abstract boolean isMergingEnabled();

    public abstract void noteMerge(PointsToAnalysis var1, TypeState var2);

    public abstract void noteMerge(PointsToAnalysis var1, AnalysisObject ... var2);

    public abstract void noteMerge(PointsToAnalysis var1, AnalysisObject var2);

    public abstract boolean isContextSensitiveAllocation(PointsToAnalysis var1, AnalysisType var2, AnalysisContext var3);

    public abstract AnalysisObject createHeapObject(PointsToAnalysis var1, AnalysisType var2, BytecodePosition var3, AnalysisContext var4);

    public abstract AnalysisObject createConstantObject(PointsToAnalysis var1, JavaConstant var2, AnalysisType var3);

    public abstract TypeState dynamicNewInstanceState(PointsToAnalysis var1, TypeState var2, TypeState var3, BytecodePosition var4, AnalysisContext var5);

    public abstract TypeState cloneState(PointsToAnalysis var1, TypeState var2, TypeState var3, BytecodePosition var4, AnalysisContext var5);

    public abstract void linkClonedObjects(PointsToAnalysis var1, TypeFlow<?> var2, CloneTypeFlow var3, BytecodePosition var4);

    public abstract FieldTypeStore createFieldTypeStore(AnalysisObject var1, AnalysisField var2, AnalysisUniverse var3);

    public abstract ArrayElementsTypeStore createArrayElementsTypeStore(AnalysisObject var1, AnalysisUniverse var2);

    public abstract AbstractVirtualInvokeTypeFlow createVirtualInvokeTypeFlow(BytecodePosition var1, AnalysisType var2, PointsToAnalysisMethod var3, TypeFlow<?>[] var4, ActualReturnTypeFlow var5);

    public abstract AbstractSpecialInvokeTypeFlow createSpecialInvokeTypeFlow(BytecodePosition var1, AnalysisType var2, PointsToAnalysisMethod var3, TypeFlow<?>[] var4, ActualReturnTypeFlow var5);

    public abstract AbstractStaticInvokeTypeFlow createStaticInvokeTypeFlow(BytecodePosition var1, AnalysisType var2, PointsToAnalysisMethod var3, TypeFlow<?>[] var4, ActualReturnTypeFlow var5);

    public abstract MethodFlowsGraph staticRootMethodGraph(PointsToAnalysis var1, PointsToAnalysisMethod var2);

    public abstract AnalysisContext allocationContext(PointsToAnalysis var1, MethodFlowsGraph var2);

    public abstract TypeFlow<?> proxy(BytecodePosition var1, TypeFlow<?> var2);

    public abstract boolean addOriginalUse(PointsToAnalysis var1, TypeFlow<?> var2, TypeFlow<?> var3);

    public abstract boolean addOriginalObserver(PointsToAnalysis var1, TypeFlow<?> var2, TypeFlow<?> var3);

    public abstract void linkActualReturn(PointsToAnalysis var1, boolean var2, InvokeTypeFlow var3);

    public abstract void registerAsImplementationInvoked(InvokeTypeFlow var1, MethodFlowsGraph var2);

    public int makeProperties(BigBang bb, AnalysisObject ... objects) {
        return 0;
    }

    public int makePropertiesForUnion(TypeState s1, TypeState s2) {
        return 0;
    }

    public abstract TypeState forContextInsensitiveTypeState(PointsToAnalysis var1, TypeState var2);

    public abstract SingleTypeState singleTypeState(PointsToAnalysis var1, boolean var2, int var3, AnalysisType var4, AnalysisObject ... var5);

    public abstract MultiTypeState multiTypeState(PointsToAnalysis var1, boolean var2, int var3, BitSet var4, AnalysisObject ... var5);

    public abstract TypeState doUnion(PointsToAnalysis var1, SingleTypeState var2, SingleTypeState var3);

    public abstract TypeState doUnion(PointsToAnalysis var1, MultiTypeState var2, SingleTypeState var3);

    public abstract TypeState doUnion(PointsToAnalysis var1, MultiTypeState var2, MultiTypeState var3);

    public final TypeState doIntersection(PointsToAnalysis bb, SingleTypeState s1, SingleTypeState s2) {
        boolean resultCanBeNull;
        assert (!bb.extendedAsserts() || TypeStateUtils.isContextInsensitiveTypeState(bb, s2)) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && s2.canBeNull();
        if (s1.exactType().equals(s2.exactType())) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
    }

    public final TypeState doIntersection(PointsToAnalysis bb, SingleTypeState s1, MultiTypeState s2) {
        boolean resultCanBeNull;
        assert (!bb.extendedAsserts() || TypeStateUtils.isContextInsensitiveTypeState(bb, s2)) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && s2.canBeNull();
        if (s2.containsType(s1.exactType())) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
    }

    public abstract TypeState doIntersection(PointsToAnalysis var1, MultiTypeState var2, SingleTypeState var3);

    public abstract TypeState doIntersection(PointsToAnalysis var1, MultiTypeState var2, MultiTypeState var3);

    public final TypeState doSubtraction(PointsToAnalysis bb, SingleTypeState s1, SingleTypeState s2) {
        boolean resultCanBeNull;
        assert (!bb.extendedAsserts() || TypeStateUtils.isContextInsensitiveTypeState(bb, s2)) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && !s2.canBeNull();
        if (s1.exactType().equals(s2.exactType())) {
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        return s1.forCanBeNull(bb, resultCanBeNull);
    }

    public final TypeState doSubtraction(PointsToAnalysis bb, SingleTypeState s1, MultiTypeState s2) {
        boolean resultCanBeNull;
        assert (!bb.extendedAsserts() || TypeStateUtils.isContextInsensitiveTypeState(bb, s2)) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && !s2.canBeNull();
        if (s2.containsType(s1.exactType())) {
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        return s1.forCanBeNull(bb, resultCanBeNull);
    }

    public abstract TypeState doSubtraction(PointsToAnalysis var1, MultiTypeState var2, SingleTypeState var3);

    public abstract TypeState doSubtraction(PointsToAnalysis var1, MultiTypeState var2, MultiTypeState var3);
}

