/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class MethodFlowsGraphClone
extends MethodFlowsGraph {
    private final AnalysisContext context;
    private final MethodFlowsGraph originalFlowsGraph;

    public MethodFlowsGraphClone(PointsToAnalysisMethod method, AnalysisContext context) {
        super(method);
        this.context = context;
        this.originalFlowsGraph = method.getTypeFlow().getMethodFlowsGraph();
        assert (this.originalFlowsGraph.isLinearized());
    }

    public AnalysisContext context() {
        return this.context;
    }

    public void cloneOriginalFlows(PointsToAnalysis bb) {
        assert (this.context != null);
        assert (this.originalFlowsGraph != null && this.originalFlowsGraph.isLinearized()) : " Method " + this + " is not linearized";
        this.linearizedGraph = new TypeFlow[this.originalFlowsGraph.linearizedGraph.length];
        this.parameters = new FormalParamTypeFlow[this.originalFlowsGraph.parameters.length];
        for (int i = 0; i < this.originalFlowsGraph.parameters.length; ++i) {
            if (this.originalFlowsGraph.getParameter(i) == null) continue;
            this.parameters[i] = this.lookupCloneOf(bb, this.originalFlowsGraph.getParameter(i));
        }
        this.nodeFlows = this.lookupClonesOf(bb, this.originalFlowsGraph.nodeFlows);
        this.returnFlow = this.originalFlowsGraph.getReturnFlow() != null ? this.lookupCloneOf(bb, this.originalFlowsGraph.getReturnFlow()) : null;
        this.instanceOfFlows = this.lookupClonesOf(bb, this.originalFlowsGraph.instanceOfFlows);
        this.miscEntryFlows = this.lookupClonesOf(bb, this.originalFlowsGraph.miscEntryFlows);
        this.invokeFlows = this.lookupClonesOf(bb, this.originalFlowsGraph.invokeFlows);
        this.sealed = true;
    }

    private <K, V extends TypeFlow<?>> EconomicMap<K, V> lookupClonesOf(PointsToAnalysis bb, EconomicMap<K, V> original) {
        if (original == null) {
            return null;
        }
        EconomicMap result = EconomicMap.create((int)original.size());
        MapCursor cursor = original.getEntries();
        while (cursor.advance()) {
            result.put(cursor.getKey(), (Object)this.lookupCloneOf(bb, (TypeFlow)cursor.getValue()));
        }
        return result;
    }

    private <V extends TypeFlow<?>> List<V> lookupClonesOf(PointsToAnalysis bb, List<V> original) {
        if (original == null) {
            return null;
        }
        ArrayList<TypeFlow> result = new ArrayList<TypeFlow>(original.size());
        for (TypeFlow value : original) {
            result.add(this.lookupCloneOf(bb, value));
        }
        return result;
    }

    @Override
    public void init(PointsToAnalysis bb) {
        throw AnalysisError.shouldNotReachHere();
    }

    @Override
    public <T extends TypeFlow<?>> T lookupCloneOf(PointsToAnalysis bb, T original) {
        assert (original != null) : "Looking for the clone of a 'null' flow in " + this;
        assert (!original.isClone()) : "Looking for the clone of the already cloned flow " + original + " in " + this;
        assert (!(original instanceof FieldTypeFlow)) : "Trying to clone a field type flow";
        assert (!(original instanceof ArrayElementsTypeFlow)) : "Trying to clone an mixed elements type flow";
        if (original instanceof AllInstantiatedTypeFlow || original instanceof AllSynchronizedTypeFlow) {
            return original;
        }
        if (original instanceof ProxyTypeFlow) {
            return (T)((ProxyTypeFlow)original).getInput();
        }
        int slot = original.getSlot();
        assert (slot >= 0 && slot < this.linearizedGraph.length) : "Slot index out of bounds " + slot + " : " + original + " [" + original.getSource() + "]";
        TypeFlow<?> clone = this.linearizedGraph[slot];
        if (clone == null) {
            if (this.sealed) {
                JVMCIError.shouldNotReachHere((String)"Trying to create a clone after the method flows have been sealed.");
            }
            clone = original.copy(bb, this);
            assert (slot == clone.getSlot());
            assert (this.linearizedGraph[slot] == null) : "Clone already exists: " + slot + " : " + original;
            this.linearizedGraph[slot] = clone;
        }
        return (T)clone;
    }

    public void linkClones(PointsToAnalysis bb) {
        for (TypeFlow<?> original : this.originalFlowsGraph.linearizedGraph) {
            TypeFlow<?> clone = this.lookupCloneOf(bb, original);
            clone.initFlow(bb);
            for (TypeFlow<?> originalObserver : original.getObservers()) {
                assert (!(originalObserver instanceof AllInstantiatedTypeFlow));
                assert (!originalObserver.isClone());
                if (MethodFlowsGraphClone.nonCloneableFlow(originalObserver)) {
                    clone.addObserver(bb, originalObserver);
                    continue;
                }
                if (MethodFlowsGraphClone.crossMethodUse(original, originalObserver)) continue;
                TypeFlow<?> clonedObserver = this.lookupCloneOf(bb, originalObserver);
                clone.addObserver(bb, clonedObserver);
            }
            for (TypeFlow<?> originalUse : original.getUses()) {
                assert (!(originalUse instanceof AllInstantiatedTypeFlow));
                assert (!originalUse.isClone()) : "Original use " + originalUse + " should not be a clone. Reached from: " + original;
                if (MethodFlowsGraphClone.nonCloneableFlow(originalUse)) {
                    clone.addUse(bb, originalUse);
                    continue;
                }
                if (MethodFlowsGraphClone.crossMethodUse(original, originalUse)) continue;
                TypeFlow<?> clonedUse = this.lookupCloneOf(bb, originalUse);
                clone.addUse(bb, clonedUse);
            }
            if (!(clone instanceof AbstractStaticInvokeTypeFlow)) continue;
            AbstractStaticInvokeTypeFlow invokeFlow = (AbstractStaticInvokeTypeFlow)clone;
            bb.postFlow(invokeFlow);
        }
    }

    public static boolean nonCloneableFlow(TypeFlow<?> flow) {
        return flow instanceof FieldTypeFlow || flow instanceof ArrayElementsTypeFlow;
    }

    public static boolean crossMethodUse(TypeFlow<?> flow, TypeFlow<?> use) {
        return flow instanceof FormalReturnTypeFlow || use instanceof FormalParamTypeFlow;
    }

    @Override
    public String toString() {
        return "MethodFlowsGraphClone<" + this.method.format("%h.%n(%p)") + " " + this.context + ">";
    }
}

